﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_ViewerThumbnailFormat.h>
#include "../../detail/visrv_DownsampleImage.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // RawDisplayCaptureRgbaMemory から PhotoViewer 用のサムネイルを作成する
    // @param[in]  context.RawDiaplayCaptureRgbaMemory
    // @param[out] context.RawViewerThumbnailMemory
    static nn::Result DownsampleRgbaForViewerThumbnail(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawDisplayCaptureRgbaMemory, 4 * ScreenShotWidth * ScreenShotHeight);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawViewerThumbnailMemory, ViewerThumbnailImageDataSize_Raw);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("down pvRGB");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pDisplayMemory, displayMemorySize, context, RawDisplayCaptureRgbaMemory);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pThumbMemory, thumbMemorySize, context, RawViewerThumbnailMemory);

        int width = 0;
        int height = 0;
        detail::DownsampleImageRgbaAverage4x4(
            &width,
            &height,
            pThumbMemory,
            thumbMemorySize,
            pDisplayMemory,
            displayMemorySize,
            ScreenShotWidth,
            ScreenShotHeight,
            detail::DownsampleImageOption_Opaque
        );

        NN_CAPSRV_ASSERT_EQUAL(width,  static_cast<int>(ViewerThumbnailImageSize_Width));
        NN_CAPSRV_ASSERT_EQUAL(height, static_cast<int>(ViewerThumbnailImageSize_Height));

        NN_RESULT_SUCCESS;
    }

}}}}}
