﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include "../visrv_ScreenShotContext.h"
#include "../../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    static nn::Result CheckScreenShotNotCanceled(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ScreenShotSequenceNumber);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ScreenShotSequenceManager);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(seqNo, context, ScreenShotSequenceNumber);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pMgr, context, ScreenShotSequenceManager);

        uint64_t canceled = 0;
        nn::Result reason;
        pMgr->GetCanceledSequenceNumber(&canceled, &reason);

        if(seqNo <= canceled)
        {
            return reason;
        }

        NN_RESULT_SUCCESS;
    }

}}}}}
