﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "visrv_JpegDestinationMgrBase.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    // 連続した出力バッファに書き出す。
    // 先頭の SOI は出力バッファに書き込まれない。
    class JpegDestinationMgrForBufferWithExif
        : public JpegDestinationMgrBase
    {
    public:
        JpegDestinationMgrForBufferWithExif(void* pBuffer, size_t size) NN_NOEXCEPT
            : m_IsWritingSoi(false)
            , m_pBuffer(pBuffer)
            , m_Size(size)
        {
        }

        virtual void Open(void** pOutBuffer, size_t* pOutBufferSize, j_compress_ptr) NN_NOEXCEPT NN_OVERRIDE
        {
            *pOutBuffer     = m_Soi;
            *pOutBufferSize = sizeof(m_Soi);
            m_IsWritingSoi  = true;
        }

        virtual void GetNextBuffer(void** pOutNextBuffer, size_t* pOutNextBufferSize, j_compress_ptr cinfo) NN_NOEXCEPT NN_OVERRIDE
        {
            if(m_IsWritingSoi)
            {
                NN_SDK_ASSERT_EQUAL(m_Soi[0], 0xFF);
                NN_SDK_ASSERT_EQUAL(m_Soi[1], 0xD8);
                *pOutNextBuffer     = m_pBuffer;
                *pOutNextBufferSize = m_Size;
                m_IsWritingSoi = false;
            }
            else
            {
                AbortByOutOfMemory(cinfo);
            }
        }

    private:
        bool m_IsWritingSoi;
        char m_Soi[2];

        void*  m_pBuffer;
        size_t m_Size;

    };

}}}}
