﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_DownsampleImage.h"

#include <cmath>
#include <algorithm>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../capsrv_Assert.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    namespace {
        void GetSrcPosition(int* pOutIndex0, int* pOutIndex1, float* pOutWeight0, float* pOutWeight1, float dstTarget, float srcSize, float dstSize, int srcPixelCount) NN_NOEXCEPT
        {
            float v = dstTarget / dstSize * srcSize;

            float i = std::floor(v);
            float w = v - i;
            int index0 = static_cast<int>(i);
            int index1 = std::min(index0 + 1, srcPixelCount - 1);

            *pOutIndex0 = index0;
            *pOutIndex1 = index1;
            *pOutWeight0 = 1.f - w;
            *pOutWeight1 = w;
        }
    }

    // TORIAEZU: 処理速度は遅い
    void DownsampleImageRgbaBilinear(
        void* pDstBuffer,
        size_t dstBufferSize,
        int dstWidth,
        int dstHeight,
        size_t dstStride,
        const void* pSrcBuffer,
        size_t srcBufferSize,
        int srcWidth,
        int srcHeight,
        size_t srcStride,
        DownsampleImageOption option
    ) NN_NOEXCEPT
    {
        const int PixelSize = 4;
        NN_CAPSRV_REQUIRES_NOT_NULL(pDstBuffer);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(dstBufferSize, static_cast<size_t>(dstStride * dstHeight));
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(dstWidth, 1);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(dstHeight, 1);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(dstStride, static_cast<size_t>(PixelSize * dstWidth));
        NN_CAPSRV_REQUIRES_NOT_NULL(pSrcBuffer);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(srcBufferSize, static_cast<size_t>(srcStride * srcHeight));
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(srcWidth, 2);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(srcHeight, 2);
        NN_CAPSRV_REQUIRES_GREATER_EQUAL(srcStride, static_cast<size_t>(PixelSize * srcWidth));

        NN_UNUSED(dstBufferSize);
        NN_UNUSED(srcBufferSize);

        auto pDstBase = reinterpret_cast<uint8_t*>(pDstBuffer);
        auto pSrcBase = reinterpret_cast<const uint8_t*>(pSrcBuffer);

        for(int dstY = 0; dstY < dstHeight; dstY++)
        {
            int srcY0 = 0;
            int srcY1 = 0;
            float srcWy0 = 0;
            float srcWy1 = 0;
            GetSrcPosition(&srcY0, &srcY1, &srcWy0, &srcWy1, static_cast<float>(dstY), static_cast<float>(srcHeight - 1), static_cast<float>(dstHeight) - 1, srcHeight);

            auto pDstLine = pDstBase + dstY * dstStride;
            auto pSrcLine0 = pSrcBase + srcY0 * srcStride;
            auto pSrcLine1 = pSrcBase + srcY1 * srcStride;

            for(int dstX = 0; dstX < dstWidth; dstX++)
            {
                int srcX0 = 0;
                int srcX1 = 0;
                float srcWx0 = 0;
                float srcWx1 = 0;
                GetSrcPosition(&srcX0, &srcX1, &srcWx0, &srcWx1, static_cast<float>(dstX), static_cast<float>(srcWidth - 1), static_cast<float>(dstWidth) - 1, srcWidth);

                auto pDstPixel = pDstLine + dstX * PixelSize;
                auto pSrcPixel00 = pSrcLine0 + srcX0 * PixelSize;
                auto pSrcPixel01 = pSrcLine0 + srcX1 * PixelSize;
                auto pSrcPixel10 = pSrcLine1 + srcX0 * PixelSize;
                auto pSrcPixel11 = pSrcLine1 + srcX1 * PixelSize;

                for(int c = 0; c < PixelSize; c++)
                {
                    if(c == 3 && ((option & DownsampleImageOption_Opaque) != 0))
                    {
                        pDstPixel[c] = 255;
                    }
                    else
                    {
                        float value =
                            srcWy0 * srcWx0 * static_cast<float>(pSrcPixel00[c]) +
                            srcWy0 * srcWx1 * static_cast<float>(pSrcPixel01[c]) +
                            srcWy1 * srcWx0 * static_cast<float>(pSrcPixel10[c]) +
                            srcWy1 * srcWx1 * static_cast<float>(pSrcPixel11[c]);
                        if(value > 255)
                        {
                            value = 255;
                        }
                        else if(value < 0)
                        {
                            value = 0;
                        }
                        pDstPixel[c] = static_cast<uint8_t>(value);
                    }
                }
            }
        }
    }

}}}}

