﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    enum DownsampleImageOption
    {
        DownsampleImageOption_None = 0,
        DownsampleImageOption_Opaque = (1 << 0),
    };

    // RGBA 画像を近接ピクセルのバイリニア補間でスケーリングする
    // @pre pDstBuffer != nullptr
    // @pre dstBufferSize >= dstStride * dstHeight
    // @pre dstWidth >= 1
    // @pre dstHeight >= 1
    // @pre dstStride >= 4 * dstWidth
    // @pre pSrcBuffer != nullptr
    // @pre srcBufferSize >= srcStride * srcHeight
    // @pre srcWidth >= 2
    // @pre srcHeight >= 2
    // @pre srcStride >= 4 * srcWidth
    void DownsampleImageRgbaBilinear(
        void* pDstBuffer,
        size_t dstBufferSize,
        int dstWidth,
        int dstHeight,
        size_t dstStride,
        const void* pSrcBuffer,
        size_t srcBufferSize,
        int srcWidth,
        int srcHeight,
        size_t srcStride,
        DownsampleImageOption option
    ) NN_NOEXCEPT;

    // RGBA 画像を 1/4 にスケーリングする
    // @pre srcWidth >= 4
    // @pre srcHeight >= 4
    // @pre srcWidth % 4 == 0
    // @pre srcHeight % 4 == 0
    // @pre srcBufferSize >= 4 * srcWidth * srcHeight
    // @pre dstBufferSize >= srcWidth * srcHeight / 4
    // @post *pOutDstWidth = srcWidth / 4
    // @post *pOutDstHeight = srcHeight / 4
    void DownsampleImageRgbaAverage4x4(
        int* pOutDstWidth,
        int* pOutDstHeight,
        void* pDstBuffer,
        size_t dstBufferSize,
        const void* pSrcBuffer,
        size_t srcBufferSize,
        int srcWidth,
        int srcHeight,
        DownsampleImageOption option
    ) NN_NOEXCEPT;

}}}}
