﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "../capsrvServer_Config.h"
#include "../capsrvServer_WorkMemory.h"
#include "../../capture/capsrv_CaptureModule.h"
#include "../../capture/capsrv_MemoryPool.h"
#include "../../capture/capsrv_ImageBuffer.h"
#include "../../capture/capsrv_DisplayBuffer.h"
#include "../../capture/capsrv_DisplayCapture.h"
#include "../detail/capsrvServer_SegmentedBuffer.h"


namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    class ScreenShotCaptureModule
    {
    public:
        void Initialize(WorkMemory::ScreenShotWorkMemory* pWorkMemory) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;



        capture::CaptureModule* GetModule() NN_NOEXCEPT
        {
            return m_pModule;
        }

        capture::DisplayCapture* GetScreenShotFullSizeCapture() NN_NOEXCEPT
        {
            return &m_ScreenShot.fullSizeCapture;
        }

        capture::ImageBuffer* GetScreenShotOverlayThumbnailImage() NN_NOEXCEPT
        {
            return &m_ScreenShot.overlayThumbnail;
        }

        capture::ImageBuffer* GetScreenShotViewerThumbnailImage() NN_NOEXCEPT
        {
            return &m_ScreenShot.viewerThumbnail;
        }

        capture::DisplayCapture* GetKeepPresentationCapture() NN_NOEXCEPT
        {
            return &m_KeepPresentation.presentationCapture;
        }

        void FlushKeepPresentationBuffer() NN_NOEXCEPT
        {
            m_KeepPresentation.presentationBuffer.FlushCache();
        }

        detail::ScreenShotBufferUnitList* GetKeepPresentationUnitList() NN_NOEXCEPT
        {
            return &m_KeepPresentation.bufferUnitList;
        }

    private:
        capture::CaptureModule* m_pModule;
        capture::MemoryPool m_MemoryPool;

        struct ScreenShot
        {
            capture::DisplayCapture fullSizeCapture;

            capture::ImageBuffer   fullSizeY;
            capture::ImageBuffer   fullSizeU;
            capture::ImageBuffer   fullSizeV;
            capture::DisplayBuffer fullSizeBuffer;

            capture::ImageBuffer   overlayThumbnail;
            capture::ImageBuffer   viewerThumbnail;
        } m_ScreenShot;

        struct KeepPresentation
        {
            capture::DisplayCapture presentationCapture;
            capture::ImageBuffer    presentationRgba;
            capture::DisplayBuffer  presentationBuffer;
            detail::ScreenShotBufferUnitList bufferUnitList;
        } m_KeepPresentation;


    };

}}}}
