﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

#define NN_CAPSRV_ALIGNAS_JPEG NN_ALIGNAS(16)

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    struct NN_CAPSRV_ALIGNAS_JPEG ExifBuildWorkStorage
    {
        char value[744];
    };

    struct NN_CAPSRV_ALIGNAS_JPEG ExifExtractWorkStorage
    {
        char value[240];
    };

    NN_STATIC_ASSERT(NN_ALIGNOF(ExifBuildWorkStorage) >= NN_ALIGNOF(std::max_align_t));
    NN_STATIC_ASSERT(NN_ALIGNOF(ExifExtractWorkStorage) >= NN_ALIGNOF(std::max_align_t));

}}}}
