﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrvServer_ScreenShotFileSignature.h"
#include "capsrvServer_Signature.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // @brief 画面写真の JPEG ファイルの MAC を計算します。
    // @details
    //   入力の署名領域の値は 0 埋めされている必要があります。
    nn::Result CalculateJpegMac(
        Signature* pOutValue,
        int64_t* pOutOffset,
        const void* pJpegData,
        size_t jpegDataSize,
        uint64_t makerNoteVersion,
        int64_t makerNoteOffset,
        int64_t makerNoteSize
        ) NN_NOEXCEPT;

    // @brief 画面写真の JPEG ファイルの MAC が正しいか検査します。
    // @details
    //   署名領域を 0 詰めした値を使って計算します。
    nn::Result CalculateAndCheckJpegMac(
        const void* pJpegData,
        size_t jpegDataSize,
        int64_t makerNoteOffset,
        int64_t makerNoteSize
        ) NN_NOEXCEPT;

    void SetScreenShotFileSignFunction(
        ScreenShotFileSignatureVersion fileSignVersion,
        nn::Result (*function)(Signature* pOutValue, const void* data, size_t dataSize)
    ) NN_NOEXCEPT;


}}}}
