﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumFileContents.h>
#include "../capsrvServer_EnvironmentInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    class AlbumContentsAttribute
    {
    public:
        // ファイル拡張子を取得する( ".jpg" など。ピリオドを含む)
        // contents が無効な場合 nullptr を返す
        static const char* GetFileExtension(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT;

        // ファイル拡張子の文字数を取得する（ピリオドを含む。null 文字含まず）
        static int GetFileExtensionLength(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT;

        // ファイルの種類で決められているファイルサイズの最大値を取得する
        static size_t GetFileSizeLimit(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT;

    };

}}}}
