﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumStorage.h>

namespace nn{ namespace capsrv{ namespace server{

    enum AlbumStorageDirection
    {
        AlbumStorageDirection_Unknown,

        // 読込元ストレージで発生したことを示します。
        AlbumStorageDirection_Source,

        // 書込先ストレージで発生したことを示します
        // チェック用の Read 操作で発生した場合もこちらです。
        AlbumStorageDirection_Destination,
    };

    typedef uint32_t AlbumStorageDirectionType;

    nn::Result ConvertFileSystemResult(nn::Result result, AlbumStorageDirectionType direction) NN_NOEXCEPT;

}}}

