﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "amsrv_InitializeForScreenShotApplicationServer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "screenshotsrv/amsrv_ScreenShotApplicationServerObject.h"

namespace nn{ namespace capsrv{ namespace server{

    namespace {
        bool g_IsInitialized = false;
    }

    void InitializeForScreenShotApplicationServer() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(!g_IsInitialized);
        NN_ABORT_UNLESS_RESULT_SUCCESS(g_ScreenShotApplicationServerManager.Initialize());
        g_ScreenShotApplicationServerManager.StartServer();
        g_IsInitialized = true;
    }

    void FinalizeForScreenShotApplicationServer() NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);

        g_ScreenShotApplicationServerManager.StopServer();
        g_ScreenShotApplicationServerManager.Finalize();
        g_IsInitialized = false;
    }

    void ScreenShotApplicationServerThreadFunction(void*) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(g_IsInitialized);
        g_ScreenShotApplicationServerManager.RunServer();
    }

}}}
