﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumWorker.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "capsrvServer_AlbumServerObject.h"

namespace nn{ namespace capsrv{ namespace server{

    AlbumWorker::AlbumWorker() NN_NOEXCEPT
        : m_IsIdleEvent()
        , m_IsStopRequestedEvent()
        , m_MultiWait()
        , m_StopRequestedEventWaitHolder()
    {
    }


    nn::Result AlbumWorker::Initialize() NN_NOEXCEPT
    {
        nn::os::InitializeEvent(&m_IsIdleEvent, true, nn::os::EventClearMode_ManualClear);
        nn::os::InitializeEvent(&m_IsStopRequestedEvent, false, nn::os::EventClearMode_ManualClear);

        nn::os::InitializeMultiWait(&m_MultiWait);
        nn::os::InitializeMultiWaitHolder(&m_StopRequestedEventWaitHolder, &m_IsStopRequestedEvent);
        m_StopRequestedEventWaitHolder.userData = StopRequestedWaitHolderTag;

        nn::os::LinkMultiWaitHolder(&m_MultiWait, &m_StopRequestedEventWaitHolder);
        //nn::os::LinkMultiWaitHolder(&m_MultiWait, g_AlbumControlRequestQueue.GetDequeueMultiWaitHolder());
        //nn::os::LinkMultiWaitHolder(&m_MultiWait, g_AlbumRequestQueue.GetDequeueMultiWaitHolder());

        NN_RESULT_SUCCESS;
    }

    void AlbumWorker::Finalize() NN_NOEXCEPT
    {
        nn::os::UnlinkAllMultiWaitHolder(&m_MultiWait);

        nn::os::FinalizeMultiWaitHolder(&m_StopRequestedEventWaitHolder);
        nn::os::FinalizeMultiWait(&m_MultiWait);

        nn::os::FinalizeEvent(&m_IsStopRequestedEvent);
        nn::os::FinalizeEvent(&m_IsIdleEvent);
    }

    void AlbumWorker::RunWorker() NN_NOEXCEPT
    {
        // TORIAEZU:
        // 排他としては不十分だが実用上問題ない。
        NN_SDK_REQUIRES(nn::os::TryWaitEvent(&m_IsIdleEvent));
        nn::os::ClearEvent(&m_IsIdleEvent);

        for(;;)
        {
            auto pHolder = nn::os::WaitAny(&m_MultiWait);
            auto tag = pHolder->userData;
            if(tag == StopRequestedWaitHolderTag)
            {
                break;
            }

            switch(tag)
            {
            case AlbumRequestWaitHolderTag_AlbumControl:
                {
                    void (*pFunction)(void*) = nullptr;
                    void* pParameter = nullptr;
                    //g_AlbumControlRequestQueue.BeginProcessingRequest(&pFunction, &pParameter);
                    pFunction(pParameter);
                    //g_AlbumControlRequestQueue.EndProcessingRequest();
                    break;
                }
            case AlbumRequestWaitHolderTag_Album:
                {
                    void (*pFunction)(void*) = nullptr;
                    void* pParameter = nullptr;
                    //g_AlbumRequestQueue.BeginProcessingRequest(&pFunction, &pParameter);
                    pFunction(pParameter);
                    //g_AlbumRequestQueue.EndProcessingRequest();
                    break;
                }
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        nn::os::SignalEvent(&m_IsIdleEvent);
    }

    void AlbumWorker::StopWorker() NN_NOEXCEPT
    {
        nn::os::SignalEvent(&m_IsStopRequestedEvent);
        nn::os::WaitEvent(&m_IsIdleEvent);
    }

}}}
