﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumServerObject.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn{ namespace capsrv{ namespace server{

    AlbumWorkMemory                g_AlbumWorkMemory;
    ResourceIdManager              g_ResourceIdManager;
    EnvironmentInfo                g_EnvironmentInfo;

    album::AlbumManager            g_AlbumManager;
    album::AlbumFileIdGenerator    g_AlbumFileIdGenerator;
    detail::ApplicationResourceManager g_ApplicationResourceManager;
    detail::OverlayThumbnailHolder g_OverlayThumbnailHolder;

    AlbumErrorConverter            g_AlbumErrorConverter;
    album::AlbumMovieUtilityStaticObject g_AlbumMovieUtilityStaticObject;

#if defined(NN_CAPSRV_USE_HIPC)
    AlbumControlServerManager      g_AlbumControlServerManager;
    AlbumServerManager             g_AlbumServerManager;
    os::SdkMutexType               g_AlbumGlobalMutex = NN_OS_SDK_MUTEX_INITIALIZER();
#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)
    AlbumControlServerManager      g_AlbumControlServerManager;
    AlbumServerManager             g_AlbumServerManager;
#endif

}}}
