﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/capsrv/movie/capsrv_MovieFilePath.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>

namespace nn{ namespace capsrv{ namespace movie{

    MovieFilePath MovieFilePath::FromString(const char* str) NN_NOEXCEPT
    {
        MovieFilePath path = {};
        nn::util::Strlcpy(path.value, str, sizeof(MovieFilePath));
        return path;
    }

    bool MovieFilePath::operator==(const MovieFilePath& v) const NN_NOEXCEPT
    {
        return nn::util::Strncmp(this->value, v.value, sizeof(this->value)) == 0;
    }

    bool MovieFilePath::operator!=(const MovieFilePath& v) const NN_NOEXCEPT
    {
        return !(*this == v);
    }

}}}

