﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "capsrv_CaptureModule.h"
#include "capsrv_ImageBuffer.h"
#include "capsrv_FilterMode.h"

namespace nn{ namespace capsrv{ namespace capture{

    static const int CopySourceImageBufferCountMax = 3;
    static const int CopyDestinationImageBufferCountMax = 3;

    nn::Result CopyImageBuffer(
        CaptureModule* pModule,
        ImageBuffer* pDstImage,
        const Rectangle& dstRect,
        const ImageBuffer*const* pSrcImageList,
        int srcImageCount,
        int srcWidth,
        int srcHeight,
        FilterMode filterMode
    ) NN_NOEXCEPT;

    nn::Result CopyImageBuffer(
        CaptureModule* pModule,
        ImageBuffer*const* pDstImageList,
        int dstImageCount,
        const Rectangle& dstRect,
        const ImageBuffer*const* pSrcImageList,
        int srcImageCount,
        int srcWidth,
        int srcHeight,
        FilterMode filterMode
    ) NN_NOEXCEPT;


}}}
