﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrv_LibraryState.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>

#ifdef NN_BUILD_TARGET_PLATFORM_OS_NN
    #ifdef NN_CAPSRV_USE_HIPC
        #define NN_CAPSRV_USE_AM_ARUID
    #else
        #define NN_CAPSRV_USE_DUMMY_ARUID
    #endif
#else
    #define NN_CAPSRV_USE_DUMMY_ARUID
#endif

#ifdef NN_CAPSRV_USE_AM_ARUID
#include <nn/applet/applet_Apis.h>
#endif

namespace nn{ namespace capsrv{

    LibraryState g_LibraryState;

    nn::applet::AppletResourceUserId LibraryState::GetMyAruid() NN_NOEXCEPT
    {
#if defined(NN_CAPSRV_USE_AM_ARUID)
        return nn::applet::GetAppletResourceUserId();
#else // defined(NN_CAPSRV_USE_DUMMY_ARUID)
        return { 0x0000565253504143 }; // "CAPSRV\0\0"
#endif
    }


    LibraryState::LibraryState() NN_NOEXCEPT
        : m_pMovieReadStreamSession()
        , m_MovieReadStreamSessionServiceLevel(ServiceLevel_None)
        , m_pMovieWriteStreamSession()
        , m_MovieWriteStreamSessionServiceLevel(ServiceLevel_None)
    {
    }

    nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> LibraryState::GetMovieReadStreamSession() NN_NOEXCEPT
    {
        return m_pMovieReadStreamSession;
    }

    nn::Result LibraryState::SetMovieReadStreamSession(nn::sf::SharedPointer<nn::capsrv::sf::IMovieReadStreamServiceObject> p, ServiceLevel level) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(m_MovieReadStreamSessionServiceLevel == level || m_MovieReadStreamSessionServiceLevel == ServiceLevel_None, ResultAlbumAlreadyOpened());
        m_pMovieReadStreamSession = p;
        if(p != nullptr)
        {
            m_MovieReadStreamSessionServiceLevel = level;
        }
        else
        {
            m_MovieReadStreamSessionServiceLevel = ServiceLevel_None;
        }
        NN_RESULT_SUCCESS;
    }

    nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> LibraryState::GetMovieWriteStreamSession() NN_NOEXCEPT
    {
        return m_pMovieWriteStreamSession;
    }

    nn::Result LibraryState::SetMovieWriteStreamSession(nn::sf::SharedPointer<nn::capsrv::sf::IMovieWriteStreamServiceObject> p, ServiceLevel level) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(m_MovieWriteStreamSessionServiceLevel == level || m_MovieWriteStreamSessionServiceLevel == ServiceLevel_None, ResultAlbumAlreadyOpened());
        m_pMovieWriteStreamSession = p;
        if(p != nullptr)
        {
            m_MovieWriteStreamSessionServiceLevel = level;
        }
        else
        {
            m_MovieWriteStreamSessionServiceLevel = ServiceLevel_None;
        }
        NN_RESULT_SUCCESS;
    }

}}
