﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined(__APPLE__)
#include <TargetConditionals.h>
#endif

#if defined(ANDROID) || TARGET_OS_IPHONE
#include <pthread.h>
#include <errno.h>
#include <cassert>
#else
#include <Windows.h>
#endif

#if TARGET_OS_IPHONE
#include <assert.h>
#endif

#include <winext/cafe/os/OSMutex.h>

namespace nw {
namespace internal {
namespace winext {

void OSInitMutex(OSMutex* mutex)
{
#if defined(ANDROID) || TARGET_OS_IPHONE
    mutex->mutex = PTHREAD_RECURSIVE_MUTEX_INITIALIZER;
#else
    CRITICAL_SECTION* p = reinterpret_cast<CRITICAL_SECTION*>(mutex->area);
    InitializeCriticalSection(p);
#endif
}

void OSLockMutex(OSMutex* mutex)
{
#if defined(ANDROID) || TARGET_OS_IPHONE
    int ret;

    ret = pthread_mutex_lock(&mutex->mutex);
    assert(ret >= 0);
#else
    CRITICAL_SECTION* p = reinterpret_cast<CRITICAL_SECTION*>(mutex->area);
    EnterCriticalSection(p);
#endif
}

void OSUnlockMutex(OSMutex* mutex)
{
#if defined(ANDROID) || TARGET_OS_IPHONE
    int ret;

    ret = pthread_mutex_unlock(&mutex->mutex);
    assert(ret >= 0);
#else
    CRITICAL_SECTION* p = reinterpret_cast<CRITICAL_SECTION*>(mutex->area);
    LeaveCriticalSection(p);
#endif
}

#if defined(ANDROID) || TARGET_OS_IPHONE
// 呼び出し元のスレッドが、ミューテックスのロックを試みます。
// ミューテックスがすでにロックされている場合、FALSE を返します。
BOOL OSTryLockMutex(OSMutex* mutex)
{
    int result = pthread_mutex_trylock(&mutex->mutex);
    assert(result == 0 || errno == EBUSY);

    return result == 0;
}
#endif

} // namespace winext
} // namespace internal
} // namespace nw

