﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <stdarg.h>
#include <winext/cafe/os.h>

#include <cstdio>
#include <cstdlib>

#include "OSAssert.h"

#if defined(__APPLE__)
#include <TargetConditionals.h>
#endif

#if defined(ANDROID)
#include <android/log.h>
#elif TARGET_OS_IPHONE
#include <cstdio>
#else
#include <windows.h>
#endif

#include <string.h>

namespace nw {
namespace internal {
namespace winext {

void OSReport(const char* msg, ...)
{
    va_list marker;
    va_start(marker, msg);

    OSVReport(msg, marker);

    va_end(marker);
}

void OSVReport(const char* msg, va_list list)
{
#if defined(ANDROID)
    __android_log_vprint(ANDROID_LOG_INFO, "[NW4F::WinExt]", msg, list);
#elif TARGET_OS_IPHONE
    static char buf[4096];
    vsprintf(buf,msg,list);
    printf("%s", buf);
#else
    char buf[4096];
    vsprintf_s(buf,msg,list);

    OutputDebugStringA(buf);    // デバッガに出力
    vprintf(msg, list);        // コンソールに出力
#endif
}

void OSPanic(const char* file, int line, const char* msg, ...)
{
    va_list marker;
    va_start(marker, msg);

    OSVReport(msg, marker);
    va_end(marker);

    abort();
}

void PPCHalt()
{
    abort();
}

} // namespace winext
} // namespace internal
} // namespace nw
