﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __AXFX_PRIVATE_H__
#define __AXFX_PRIVATE_H__

#include <winext/cafe/ax.h>
#include <winext/cafe/axfx.h>

namespace nw {
namespace internal {
namespace winext {

/*
 * heap manager
 */
extern AXFXAlloc    __AXFXAlloc;
extern AXFXFree     __AXFXFree;

extern AXFXAlloc    __AXFX2MemAlloc;
extern AXFXFree     __AXFX2MemFree;

/*
 * flag mutation
 */
void __axfx_flag_set   (u32 *flag, u32 bits);
void __axfx_flag_clear (u32 *flag, u32 bits);

/*
 * error messages
 */
#define AXFX_ERR_MEMORY    "Can't allocate the memory."
#define AXFX_ERR_NO_BUFFER "Buffer is not allocated."
#define AXFX_ERR_PARAMETER "The value of specified parameter is out of range."


/*
 * definitions for legacy fx process
 */
#define AXFX_SAMPLERATE     (32000)
#define AXFX_AUX_BLOCKSIZE  (AX_IN_SAMPLES_PER_FRAME)
#define AXFX_SAMPLES_MSEC   (AX_IN_SAMPLES_PER_MS)
#define AXFX_MSEC_UNIT      (AX_MS_PER_FRAME)

/*
 * status
 */
#define AXFX_EFF_INACTIVE   (0x01)
#define AXFX_EFF_UPDATE     (0x02)

/*
 * for chorus
 */
#define AXFX_CHORUS_MAX_SIZE      3200  // for 50msec baseDelay

extern s32* __AXFXGetLfoSinTable(void);
extern f32* __AXFXGetSrcCoef(u32 setNum);

#define __F32ToFixedPoint(value)  ( (s32)( (value) * 65536.f) )
#define __FixedPointToF32(value)  ( (f32)(value) / 65536.f )

/*
 * for reverb
 */
#define AXFX_REVERB_OUT_GAIN             (0.6f)
#define AXFX_REVERB_CROSSTALK_GAIN       (0.5f)
#define AXFX_REVERB_CROSSTALK_ADJUST     (0.666666f)
#define AXFX_REVERB_CROSSTALK_GAIN_DPL2  (AXFX_REVERB_CROSSTALK_GAIN * AXFX_REVERB_CROSSTALK_ADJUST)

#define PI    3.14159265358979323846f
#define TWOPI 6.283185307179586f



/*---------------------------------------------------------------------------*
   Sound 1 and 2 common definitions
 *---------------------------------------------------------------------------*/
#define AXFX_CENTER_DELAY_MSEC 5
#define AXFX_MAX_ER_DELAY      150  /* In msec */
#define AXFX_NUM_ER_REFL       10
#define AXFX_NUM_LATE_MODES    4
#define AXFX_INPUT_PAN_AMNT    0.2
#define AXFX_NUM_FDN 4              /* the number of early reflections on each channel */



/*---------------------------------------------------------------------------*
   Sound 1 definitions
 *---------------------------------------------------------------------------*/
#define AXFX_REVERB_DRY_LEVEL  0.4
#define AXFX_REVERB_WET_LEVEL  1.0

#if 0
BOOL  AXFX_PS_Delay_Initialize      (AXFX_PS_DELAY_LINE *psdelay, s32 delay_length);
void  AXFX_PS_Delay_Free            (AXFX_PS_DELAY_LINE *psdelay);
void  AXFX_PS_Delay_Clear           (AXFX_PS_DELAY_LINE *psdelay);
void  AXFX_PS_Delay_SetDelay        (AXFX_PS_DELAY_LINE *psdelay, s32 new_delay);
u32   AXFX_PS_Delay_GetMaximumDelay (AXFX_PS_DELAY_LINE *psdelay);
u32   AXFX_PS_Delay_GetDelay        (AXFX_PS_DELAY_LINE *psdelay);
f32x2 AXFX_PS_Delay_NextOut         (AXFX_PS_DELAY_LINE *psdelay);
f32x2 AXFX_PS_Dual_Delay_TapOut     (AXFX_DELAY_LINE *delay0, AXFX_DELAY_LINE *delay1, s32 index_back0, s32 index_back1);
f32x2 AXFX_PS_Delay_TapOut_Interpolate  (AXFX_PS_DELAY_LINE *delay, f32 offset);
f32x2 AXFX_PS_Delay_TapOut          (AXFX_PS_DELAY_LINE *delay, s32 index_back);
f32x2 AXFX_PS_Single_Delay_TapOut   (AXFX_DELAY_LINE *delay, s32 index_back0, s32 index_back1);
f32x2 AXFX_PS_Delay_Tick            (AXFX_PS_DELAY_LINE *delay, f32x2 inputs);
#endif

BOOL AXFX_Delay_Initialize      (AXFX_DELAY_LINE *delay, s32 delay_length); // Initialize an axfx_delay_line as an actual delay line.
void AXFX_Delay_Free            (AXFX_DELAY_LINE *delay); // Free memory used by the delay_line.  The delay_line becomes unusable.
void AXFX_Delay_Clear           (AXFX_DELAY_LINE *delay);
u32  AXFX_Delay_GetMaximumDelay (AXFX_DELAY_LINE *delay);
u32  AXFX_Delay_GetDelay        (AXFX_DELAY_LINE *delay);
void AXFX_Delay_SetDelay        (AXFX_DELAY_LINE *delay, s32 new_delay);
f32  AXFX_Delay_NextOut         (AXFX_DELAY_LINE *delay);
f32  AXFX_Delay_TapOut          (AXFX_DELAY_LINE *delay, s32 index_back); // Return a recently inserted sample.  Valid values are 0 (most recently inserted) to delay (the next sample to be returned by Tick or NextOut)
f32  AXFX_Delay_TapOut_Interpolate (AXFX_DELAY_LINE *delay, f32 index_back); // Like TapOut except non-integer values are allowed as indices giving an interpolated value between [floor(n) and floor(n)+1]th previous samples.
f32  AXFX_Delay_Tick            (AXFX_DELAY_LINE *delay, f32 input); // Insert a sample into the beginning of the delay while returning the next sample coming out of the delay line.

BOOL AXFX_AllPass_Initialize    (AXFX_DELAY_LINE *allpass, u32 length, f32 coef); // Initialize an axfx_delay_line as an all pass filter.
void AXFX_AllPass_Free          (AXFX_DELAY_LINE *delay); // Free memory used by the allpass filter.  The delay_line becomes unusable.
void AXFX_AllPass_SetCoef       (AXFX_DELAY_LINE *allpass, f32 coef);
u32  AXFX_AllPass_GetLen        (AXFX_DELAY_LINE *allpass);
f32  AXFX_AllPass_Tick          (AXFX_DELAY_LINE *allpass, f32 in); // Insert a sample into the beginning of the delay while returning the next sample coming out of the delay line.

s32 __calc_samp_delay (u32 fs, f32 msec_delay);



/*---------------------------------------------------------------------------*
   Sound 1 reverb effect
 *---------------------------------------------------------------------------*/
//  Common 2ch, 4ch, and 6ch Reverb functions
extern f32 __FdnDelayLen[AXFX_NUM_LATE_MODES+1][4];
extern f32 __ApDelayLen[AXFX_NUM_LATE_MODES+1][4];

BOOL __AXFXReverbInit                (AXFX_MULTI_CH_REVERB *reverb);

s32  __AXFX2chReverbGetMemSize        (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX2chReverbInit              (AXFX_MULTI_CH_REVERB *reverb, u32 rate);
void __AXFX2chReverbShutdown          (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX2chReverbSettingsUpdate    (AXFX_MULTI_CH_REVERB *params);
void __AXFX2chReverbCallback          (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_REVERB *reverb, AXAUXCBSTRUCT *info);

s32  __AXFX4chReverbGetMemSize        (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX4chReverbInit              (AXFX_MULTI_CH_REVERB *reverb, u32 rate);
void __AXFX4chReverbShutdown          (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX4chReverbSettingsUpdate    (AXFX_MULTI_CH_REVERB *params);
void __AXFX4chReverbCallback          (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_REVERB *reverb, AXAUXCBSTRUCT *info);

s32  __AXFX6ch6chReverbGetMemSize     (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX6ch6chReverbInit           (AXFX_MULTI_CH_REVERB *reverb, u32 rate);
void __AXFX6ch6chReverbShutdown       (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX6ch6chReverbSettingsUpdate (AXFX_MULTI_CH_REVERB *params);
void __AXFX6ch6chReverbCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_REVERB *reverb, AXAUXCBSTRUCT *info);

s32  __AXFX6chReverbGetMemSize        (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX6chReverbInit              (AXFX_MULTI_CH_REVERB *reverb, u32 rate);
void __AXFX6chReverbShutdown          (AXFX_MULTI_CH_REVERB *reverb);
BOOL __AXFX6chReverbSettingsUpdate    (AXFX_MULTI_CH_REVERB *params);
void __AXFX6chReverbCallback          (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_REVERB *reverb, AXAUXCBSTRUCT *info);

BOOL __AXFXReverbHandleSettingsUpdate (AXFX_MULTI_CH_REVERB *reverb, BOOL clearFlag);



/*---------------------------------------------------------------------------*
    Sound 1 delay effect
 *---------------------------------------------------------------------------*/
#define AXFX_MULTI_DELAY_MAX_DELAY_MSEC 2000.0
#define AXFX_MULTI_DELAY_WET_LEVEL 0.4

s32  __AXFX2chMultiDelayGetMemSize     (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX2chMultiDelayInit           (AXFX_MULTI_CH_DELAY *multi_delay, u32 rate);
void __AXFX2chMultiDelayShutdown       (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX2chMultiDelaySettingsUpdate (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX2chMultiDelaySettingsUpdateNoReset (AXFX_MULTI_CH_DELAY *multi_delay);
void __AXFX2chMultiDelayCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_DELAY *multi_delay, AXAUXCBSTRUCT *info);

s32  __AXFX4chMultiDelayGetMemSize     (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX4chMultiDelayInit           (AXFX_MULTI_CH_DELAY *multi_delay, u32 rate);
void __AXFX4chMultiDelayShutdown       (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX4chMultiDelaySettingsUpdate (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX4chMultiDelaySettingsUpdateNoReset (AXFX_MULTI_CH_DELAY *multi_delay);
void __AXFX4chMultiDelayCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_DELAY *multi_delay, AXAUXCBSTRUCT *info);

s32  __AXFX6chMultiDelayGetMemSize     (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX6chMultiDelayInit           (AXFX_MULTI_CH_DELAY *multi_delay, u32 rate);
void __AXFX6chMultiDelayShutdown       (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX6chMultiDelaySettingsUpdate (AXFX_MULTI_CH_DELAY *multi_delay);
BOOL __AXFX6chMultiDelaySettingsUpdateNoReset (AXFX_MULTI_CH_DELAY *multi_delay);
void __AXFX6chMultiDelayCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_DELAY *multi_delay, AXAUXCBSTRUCT *info);

BOOL __AXFXMultiDelaySettingsCommon    (AXFX_MULTI_CH_DELAY *multi_delay, u32 num_out_chans);


#if 0
/*---------------------------------------------------------------------------*
   Sound 1 chorus new effect
 *---------------------------------------------------------------------------*/
typedef struct AXFX_MULTI_CH_CHORUS_NEW
{
    // user params
    f32 delayTime;
    f32 depth;
    f32 rate;
    f32 feedback;
    f32 outGain;
    // internal members
    AXFX_CHORUS_MODE   mode;
    u32                active;
    u32                fs;
    AXFX_PS_DELAY_LINE DELAYLINE[AXFX_MULTI_CH_MAX_CHANNELS/2]; // Not all filters use 6 delay lines
    f32                ifeedback;
    f32                center_delay_ms;
    f32                lfo_phase;
    f32                lfo_phase_inc;
    AXFX_MULTI_CH_CHORUS *chorus; // Original chorus struct.  Only used for its user parameter values
} AXFX_MULTI_CH_CHORUS_NEW;

s32  __AXFX2chChorusGetMemSize     (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX2chChorusInit           (AXFX_MULTI_CH_CHORUS *chorus, u32 rate);
void __AXFX2chChorusShutdown       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX2chChorusSettings       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX2chChorusSettingsUpdate (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX2chChorusSettingsUpdateNoReset (AXFX_MULTI_CH_CHORUS *chorus);
void __AXFX2chChorusCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_CHORUS *chorus, AXAUXCBSTRUCT *info);

s32  __AXFX4chChorusGetMemSize     (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX4chChorusInit           (AXFX_MULTI_CH_CHORUS *chorus, u32 rate);
void __AXFX4chChorusShutdown       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX4chChorusSettings       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX4chChorusSettingsUpdate (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX4chChorusSettingsUpdateNoReset (AXFX_MULTI_CH_CHORUS *chorus);
void __AXFX4chChorusCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_CHORUS *chorus, AXAUXCBSTRUCT *info);

s32  __AXFX6chChorusGetMemSize     (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX6chChorusInit           (AXFX_MULTI_CH_CHORUS *chorus, u32 rate);
void __AXFX6chChorusShutdown       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX6chChorusSettings       (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX6chChorusSettingsUpdate (AXFX_MULTI_CH_CHORUS *chorus);
BOOL __AXFX6chChorusSettingsUpdateNoReset (AXFX_MULTI_CH_CHORUS *chorus);
void __AXFX6chChorusCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_CHORUS *chorus, AXAUXCBSTRUCT *info);

s32  AXFXMultiChChorusGetMemSize2     (AXFX_MULTI_CH_CHORUS_NEW *chorus);
BOOL AXFXMultiChChorusInit2           (AXFX_MULTI_CH_CHORUS_NEW *chorus, AXFX_CHORUS_MODE mode, AXFX_SAMPLE_RATE sampleRate);
void AXFXMultiChChorusShutdown2       (AXFX_MULTI_CH_CHORUS_NEW *chorus);
BOOL AXFXMultiChChorusSettings2       (AXFX_MULTI_CH_CHORUS_NEW *chorus);
BOOL AXFXMultiChChorusSettingsUpdate2 (AXFX_MULTI_CH_CHORUS_NEW *chorus);
void AXFXMultiChChorusCallback2       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX_MULTI_CH_CHORUS_NEW *chorus, AXAUXCBSTRUCT *info);



/*---------------------------------------------------------------------------*
   Sound 2 definitions
 *---------------------------------------------------------------------------*/
typedef struct
{
    // The buffer pointers.  buff_end is set to the last possible buffer sample.
    // (buff_end - buff) is the "max delay" length.
    f32   *buff;
    f32   *buff_end;
    u32   max_delay; // Maximum delay allowed.
    // The in/out pointers which wrap back to buff when they reach buff_end
    // max_delay - (out - in) is the "current delay" length.
    f32   *in;
    f32   *out;
    u32   delay; // Actual delay configured (can be 0 through max_delay)
    // Used by allpass filter
    f32    coef;
} AXFX2_DELAY_LINE;

typedef struct
{
    // The buffer pointers.  buff_end is set to the last possible buffer sample.
    // (buff_end - buff) is the "max delay" length.
    f32x2  *buff;
    f32x2  *buff_end;
    u32     max_delay; // Maximum delay allowed.
    // The in/out pointers which wrap back to buff when they reach buff_end
    // max_delay - (out - in) is the "current delay" length.
    f32x2  *in;
    f32x2  *out;
    u32     delay; // Actual delay configured (can be 0 through max_delay)
    // Used by allpass filter
    f32     coef;
} AXFX2_PS_DELAY_LINE;

BOOL AXFX2_Delay_Initialize        (AXFX2_DELAY_LINE *delay, s32 max_delay);
void AXFX2_Delay_Free              (AXFX2_DELAY_LINE *delay);
void AXFX2_Delay_Clear             (AXFX2_DELAY_LINE *delay);
BOOL AXFX2_Delay_SetDelay          (AXFX2_DELAY_LINE *delay, s32 new_delay);
u32  AXFX2_Delay_GetMaximumDelay   (AXFX2_DELAY_LINE *delay);
u32  AXFX2_Delay_GetDelay          (AXFX2_DELAY_LINE *delay);
f32  AXFX2_Delay_NextOut           (AXFX2_DELAY_LINE *delay);
f32  AXFX2_Delay_TapOut            (AXFX2_DELAY_LINE *delay, s32 index_back);
f32  AXFX2_Delay_TapOut_Interpolate(AXFX2_DELAY_LINE *delay, f32 offset);
f32  AXFX2_Delay_Tick              (AXFX2_DELAY_LINE *delay, f32 input);
f32x2 AXFX2_PS_Dual_Delay_NextOut  (AXFX2_DELAY_LINE *delay0, AXFX2_DELAY_LINE *delay1);
f32x2 AXFX2_PS_Dual_Delay_Tick     (AXFX2_DELAY_LINE *delay0, AXFX2_DELAY_LINE *delay1, f32 input0, f32 input1);
f32x2 AXFX2_PS_Dual_Delay_TapOut   (AXFX2_DELAY_LINE *delay0, AXFX2_DELAY_LINE *delay1, s32 index_back0, s32 index_back1);
f32x2 AXFX2_PS_Single_Delay_TapOut (AXFX2_DELAY_LINE *delay, s32 index_back0, s32 index_back1);


BOOL  AXFX2_AllPass_Initialize   (AXFX2_DELAY_LINE *allpass, u32 length, f32 coef);
void  AXFX2_AllPass_Free         (AXFX2_DELAY_LINE *delay);
void  AXFX2_AllPass_SetCoef      (AXFX2_DELAY_LINE *allpass, f32 coef);
u32   AXFX2_AllPass_GetLen       (AXFX2_DELAY_LINE *allpass);
f32   AXFX2_AllPass_Tick         (AXFX2_DELAY_LINE *allpass, f32 in);
f32x2 AXFX2_PS_Dual_AllPass_Tick (AXFX2_DELAY_LINE *allpass0, AXFX2_DELAY_LINE *allpass1, f32 in0, f32 in1);

BOOL  AXFX2_PS_Delay_Initialize         (AXFX2_PS_DELAY_LINE *psdelay, s32 delay_length);
void  AXFX2_PS_Delay_Free               (AXFX2_PS_DELAY_LINE *psdelay);
void  AXFX2_PS_Delay_Clear              (AXFX2_PS_DELAY_LINE *psdelay);
BOOL  AXFX2_PS_Delay_SetDelay           (AXFX2_PS_DELAY_LINE *psdelay, s32 new_delay);
u32   AXFX2_PS_Delay_GetMaximumDelay    (AXFX2_PS_DELAY_LINE *psdelay);
u32   AXFX2_PS_Delay_GetDelay           (AXFX2_PS_DELAY_LINE *psdelay);
f32x2 AXFX2_PS_Delay_NextOut            (AXFX2_PS_DELAY_LINE *psdelay);
//f32x2 AXFX2_PS_Delay_TapOut_Interpolate (AXFX2_PS_DELAY_LINE *delay, f32 offset);
//f32x2 AXFX2_PS_Delay_TapOut             (AXFX2_PS_DELAY_LINE *delay, s32 index_back);
f32x2 AXFX2_PS_Delay_Tick               (AXFX2_PS_DELAY_LINE *delay, f32x2 inputs);

s32 __calculate_samp_delay (u32 fs, f32 msec_delay);



/*---------------------------------------------------------------------------*
   Sound 2 reverb effect
 *---------------------------------------------------------------------------*/
#define AXFX_NUM_ER_TAPS         10
#define REVERB_MAX_NUM_ER_DELAY   4
#define AXFX_HF_FREQ           5000.0 /* freq at which hf decay is controlled */

typedef struct
{
    AXFX_REVERB_MODE mode;
    u32 fs;
    // Derived parameters and objects
    f32 reverb_level;
    f32 late_level;
    // early reflections
    AXFX2_DELAY_LINE early_delay;
    u32              early_tap[AXFX_NUM_ER_TAPS];  // 10
    f32              early_coef[AXFX_NUM_ER_TAPS]; // 10
    // late reverb
    u32          late_tap;
    f32          cos_w_hf;
    f32          ap_coef;
    AXFX2_DELAY_LINE  center_delay; // Used by 6 channel mono-mixed reverb
    AXFX2_DELAY_LINE  fdn_delay[AXFX_NUM_FDN]; // 4
    AXFX2_DELAY_LINE  ap[AXFX_NUM_FDN];
    f32        fdn_fb[AXFX_NUM_FDN];       // feedback coefficients
    f32        fdn_lp_coef[AXFX_NUM_FDN];  // low-pass filter coefficients
    f32        fdn_lp_z[AXFX_NUM_FDN];
    // Output gain
    f32 dry_gain;
    f32 out_gain;
    u32 pad[4];
} AXFX_REVERB_PRIVATE;

s32  __AXFX22chMonoMixedReverbGetMemSize     (u32 fs);
BOOL __AXFX22chMonoMixedReverbInit           (AXFX2_REVERB *reverb);
BOOL __AXFX22chMonoMixedReverbSettingsUpdate (AXFX2_REVERB *params, BOOL clearFlag);
void __AXFX22chMonoMixedReverbCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB *reverb, AXAUXCBSTRUCT *info);

s32  __AXFX24chMonoMixedReverbGetMemSize     (u32 fs);
BOOL __AXFX24chMonoMixedReverbInit           (AXFX2_REVERB *reverb);
void __AXFX24chMonoMixedReverbCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB *reverb, AXAUXCBSTRUCT *info);

s32  __AXFX26chMonoMixedReverbGetMemSize     (u32 fs);
BOOL __AXFX26chMonoMixedReverbInit           (AXFX2_REVERB *reverb);
void __AXFX26chMonoMixedReverbCallback       (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB *reverb, AXAUXCBSTRUCT *info);

BOOL __AXFX2ReverbHandleSettingsUpdate (AXFX2_REVERB *reverb, BOOL clearFlag);



/*---------------------------------------------------------------------------*
   Sound 2 reverb I3DL2 effect
 *---------------------------------------------------------------------------*/
#define AXFX_MAX_REFL_DELAY            0.300  // in sec
#define AXFX_MAX_RVRB_DELAY            0.100  // in sec
#define AXFX_NUM_ER_TAPS_I3DL2 20

typedef struct
{
    AXFX_REVERB_MODE mode;
    // vars
    u32 fs;      // sample_rate
    f32 hf_freq; // ref freq for input LPFs and FDN shelf filters
    // early reflection stuff
    f32 first_refl_time;       // delay to the first reflection, in msec
    f32 refl_time_scale;       // number of msec to scale each reflection time by
    f32 lpf_a1, lpf_b0;        // coefficients for filters on input
    u32 er_tap_times[AXFX_NUM_ER_TAPS_I3DL2]; // 20  The actual delay lengths used as determined by the parameter values, in samples
    // levels
    f32 early_level;
    f32 late_level;
    // 4 arm FDN late reverb
    u32 er_late_tap;          // tap time from early reflections to the late reverb
    f32 cos_w_hf;
    f32 ap_coef;
    AXFX2_DELAY_LINE fdn_delay[AXFX_NUM_FDN];  // 4 delay lines
    // all-pass filters
    AXFX2_DELAY_LINE ap[AXFX_NUM_FDN];
    AXFX2_DELAY_LINE ap2[AXFX_NUM_FDN];
    // FDN shelf filter
    f32 fdn_filt_coef[3][AXFX_NUM_FDN]; // low-pass filter coefficients
    f32 fdn_filt_z[AXFX_NUM_FDN];       // shelf filter memory
    //// Child class vars
    // input LPF filters
    f32 lpf_z;
    // early reflections
    AXFX2_DELAY_LINE early_delay;
    // late reverb
    AXFX2_DELAY_LINE center_delay;
    f32 dry_gain;
    f32 out_gain;
    u32 pad[4];
} AXFX_REVERB_I3DL2_PRIVATE;


void __AXFX22chMonoMixedReverbI3dl2Callback (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB_I3DL2 *reverb_i3dl2, AXAUXCBSTRUCT *info);
void __AXFX24chMonoMixedReverbI3dl2Callback (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB_I3DL2 *reverb_i3dl2, AXAUXCBSTRUCT *info);
void __AXFX26chMonoMixedReverbI3dl2Callback (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_REVERB_I3DL2 *reverb_i3dl2, AXAUXCBSTRUCT *info);
BOOL __paramsCheckAndUpdateMonoMixed        (AXFX2_REVERB_I3DL2 *reverb_i3dl2, BOOL clearFlag);
void __paramsCheckAndUpdate_i3dl2           (AXFX2_REVERB_I3DL2 *reverb_i3dl2, BOOL clearFlag);
void __changeParamsBase_i3dl2               (AXFX2_REVERB_I3DL2 *parms);
void __set_all_fdn_params_i3dl2             (AXFX2_REVERB_I3DL2 *parms);
void __set_fdn_coefs_i3dl2                  (AXFX2_REVERB_I3DL2 *parms, u32 fdn_num);



/*---------------------------------------------------------------------------*
    Sound 2 chorus effect
 *---------------------------------------------------------------------------*/
typedef struct
{
    AXFX_CHORUS_MODE mode;
    u32 num_chans;
    u32 fs;
    AXFX2_DELAY_LINE delay[AXFX_MULTI_CH_MAX_CHANNELS-1]; // The subwoofer channel is not 'flanged'
    f32 feedback;
    f32 center_delay_ms;
    f32 mod_depth;
    f32 LFO_PHASE[AXFX_MULTI_CH_MAX_CHANNELS-1];
    f32 lfo_phase_inc;
    f32 dry_gain;
    f32 out_gain;
    u32 pad[4];
} AXFX_CHORUS_PRIVATE;



/*---------------------------------------------------------------------------*
   Sound 2 delay effect
 *---------------------------------------------------------------------------*/
typedef struct
{
    u32             active;
    u32             fs;
    AXFX_DELAY_MODE mode;
    u32             num_chans;
    AXFX2_PS_DELAY_LINE psdelay[AXFX_MULTI_CH_MAX_CHANNELS/2]; // Paired singles operate on two f32's at a time
    f32 fb;
    f32 gain;
    f32 fb_direct;
    f32 fb_cross;
    f32 lpf_b0;
    f32 lpf_a1;
    f32x2 pslpf_z[AXFX_MULTI_CH_MAX_CHANNELS/2];
    f32 max_delay;
    f32 out_gain;
    f32 dry_gain;
    u32 pad[4];
} AXFX_DELAY_PRIVATE;

BOOL __AXFX22chDelayInit                  (AXFX2_DELAY *delay, u32 rate);
void __AXFX22chDelayShutdown              (AXFX2_DELAY *delay);
BOOL __AXFX22chDelaySettings              (AXFX2_DELAY *delay);
BOOL __AXFX22chDelaySettingsUpdate        (AXFX2_DELAY *delay);
BOOL __AXFX22chDelaySettingsUpdateNoReset (AXFX2_DELAY *delay);
void __AXFX22chDelayCallback              (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_DELAY *delay, AXAUXCBSTRUCT *info);

BOOL __AXFX24chDelayInit                  (AXFX2_DELAY *delay, u32 rate);
void __AXFX24chDelayShutdown              (AXFX2_DELAY *delay);
BOOL __AXFX24chDelaySettings              (AXFX2_DELAY *delay);
BOOL __AXFX24chDelaySettingsUpdate        (AXFX2_DELAY *delay);
BOOL __AXFX24chDelaySettingsUpdateNoReset (AXFX2_DELAY *delay);
void __AXFX24chDelayCallback              (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_DELAY *delay, AXAUXCBSTRUCT *info);

BOOL __AXFX26chDelayInit                  (AXFX2_DELAY *delay, u32 rate);
void __AXFX26chDelayShutdown              (AXFX2_DELAY *delay);
BOOL __AXFX26chDelaySettings              (AXFX2_DELAY *delay);
BOOL __AXFX26chDelaySettingsUpdate        (AXFX2_DELAY *delay);
BOOL __AXFX26chDelaySettingsUpdateNoReset (AXFX2_DELAY *delay);
void __AXFX26chDelayCallback              (AXFX_6CH_BUFFERUPDATE *bufferUpdate, AXFX2_DELAY *delay, AXAUXCBSTRUCT *info);

BOOL __AXFX2DelaySettingsCommon (AXFX2_DELAY *delay_user, u32 num_out_chans, BOOL clearFlag);



/*---------------------------------------------------------------------------*
   Sound 2 flanger effect
 *---------------------------------------------------------------------------*/
#define AXFX_FLANGER_MAX_DELAY 14.5 // msec

typedef struct
{
    f32 mod_depth;
    f32 feedback;
    u32                active;
    u32                fs;
    AXFX_FLANGER_MODE  mode;
    u32                num_delay_buffers;
    AXFX2_DELAY_LINE   delay[AXFX_MULTI_CH_MAX_CHANNELS-1]; // The subwoofer channel is not 'flanged'
    f32                feedfwd;
    f32                fbfwd;
    f32                center_delay_ms;
    f32                lfo_phase;
    f32                lfo_phase_inc;
    f32 out_gain;
    f32 dry_gain;
    u32 pad[4];
} AXFX_FLANGER_PRIVATE;


/*---------------------------------------------------------------------------*
   Sound 2 phaser effect
 *---------------------------------------------------------------------------*/
#define AXFX_PHASER_NUM_APS  3
#define AXFX_PHASER_IN_DELAY 0.5

// Runtime private structure referenced by axfx.h:AXFX_MULTI_CH_PHASER
typedef struct
{
    u32               fs;
    AXFX_PHASER_MODE  mode;
    u32               num_delay_buffers;
    f32 feedback;
    f32 mod_depth;
    AXFX2_DELAY_LINE delay         [AXFX_MULTI_CH_MAX_CHANNELS-1]; // The subwoofer channel is not 'phasered'
    f32             max_freq;                          // highest possible notch freq, in Hz
    f32             min_freq;                          // lowest possible notch freq in radians per sample
    f32             mult_scale;
    f32             pole_radius;
    f32             freq_mults    [AXFX_PHASER_NUM_APS];
    f32             notch_freq1;                       // the current freq for the lowest notch, in rads per sec
    f32             filter_coefs  [AXFX_PHASER_NUM_APS] [2] [AXFX_MULTI_CH_MAX_CHANNELS-1]; // The subwoof channel is not 'phaswered'
    f32             filter_memory [AXFX_PHASER_NUM_APS] [4] [AXFX_MULTI_CH_MAX_CHANNELS-1]; // The subwoof channel is not 'phaswered'
    f32             fb_samp       [AXFX_MULTI_CH_MAX_CHANNELS-1];
    f32 out_gain_LFE;
    f32 feedfwd;
    f32 lfo_phase;
    f32 lfo_phase_inc;
    f32 phase_spread;
    f32 twopi_over_n;
    f32 out_gain;
    f32 dry_gain;
    u32 pad[4];
} AXFX_PHASER_PRIVATE;


/*---------------------------------------------------------------------------*
   Sound 2 overdrive effect
 *---------------------------------------------------------------------------*/
#define AXFX_OVERDRIVE_TABLE_SIZE 50
#define AXFX_OVERDRIVE_NUM_CURVES  3
#define AXFX_OVERDRIVE_STEP_SIZE   0.020408163265306

// crossover freq for the tone filter
#define AXFX_OVERDRIVE_TONE_FREQ 1000.0

// Runtime private structure referenced by axfx.h:AXFX_OVERDRIVE
typedef struct
{
    u32                 active;
    u32                 fs;
    AXFX_OVERDRIVE_MODE mode;
    u32 num_chans;
    f32 input_gain;
    f32 soft_thr;
    u32 dist_type;
    f32 tone_c;
    f32 tone_b0;
    f32 tone_b1;
    f32 tone_a1;
    f32 tone_z[AXFX_MULTI_CH_MAX_CHANNELS-1][2];  // memory for the tone filter.  an array for each processed channel
    f32 out_gain_LFE;
    f32 dry_gain;
    f32 out_gain;
    u32 pad[4];
} AXFX_OVERDRIVE_PRIVATE;


/*---------------------------------------------------------------------------*
   Sound 2 compressor effect
 *---------------------------------------------------------------------------*/
#define AXFX_COMPRESSOR_RMS_TIME    0.05  // integration time of RMS filter, in seconds
#define AXFX_COMPRESSOR_KNEE_WIDTH  3.0   // width of compression knee, in dB
#define AXFX_COMPRESSOR_ENV_THRESH  0.08  // amount by which the gain must change to flip attack/release state
#define AXFX_COMPRESSOR_ENV_THRESH2 0.001 // how close the envelope must approach the gain to reset the reference level

// Runtime private structure referenced by axfx.h:AXFX_COMPRESSOR
typedef struct
{
    u32                  active;
    u32                  fs;
    AXFX_COMPRESSOR_MODE mode;
    u32                  num_chans;
    f32 thresh;      // compression threshold
    f32 ratio;       // compression ratio
    s32 makeup_on;   // add gain makeup?
    f32 makeup_gain; // amount of additional gain to add when makeup is on
    f32 rms_tav;     // filter coeff for RMS leaky integrator
    f32 rms_z;       // memory for RMS leaky integrator
    f32 min_log;     // minimum db/log value
    f32 knee_A;      // used in calculating the gain when in the compression knee
    f32 knee_thr1;   // threshold for the bottom of the knee
    f32 knee_thr2;   // threshold for the top of the knee
    f32 env_z1;      // memory for used in the envelope
    f32 env_z2;      // memory for used in the envelope
    f32 env_AT;      // coeff for envelope when in attack
    f32 env_RT;      // coeff for envelope when in release
    f32 env_coeff;   // coeff for envelope that gets used
    f32 out_gain;    // additional gain/attenuation applied on the output
    u32 pad[4];
} AXFX_COMPRESSOR_PRIVATE;


/*---------------------------------------------------------------------------*
   Sound 2 pitchshift effect
 *---------------------------------------------------------------------------*/
#define AXFX_PITCHSHIFT_DELAY_LEN_MS 50.0      // in msec
#define AXFX_PITCHSHIFT_NUM_DELAYS   3         // how many time-varying delays are being added
#define AXFX_PITCHSHIFT_WINDOW_MULT  2.0/6.0   // normalization of window

// Runtime private structure referenced by axfx.h:AXFX_PITCHSHIFT
typedef struct
{
    u32                  fs;
    AXFX_PITCHSHIFT_MODE mode;
    u32                  num_chans;
    AXFX2_DELAY_LINE delay[AXFX_MULTI_CH_MAX_CHANNELS];
    f32              delay_ptr[AXFX_PITCHSHIFT_NUM_DELAYS];    // the delay time in samples (possibly fractional) for each delay
    f32              window_gain[AXFX_PITCHSHIFT_NUM_DELAYS];
    f32              window_phase_mult;                               // multiplier for cosine window calc
    f32              delay_inc;                                       // the increment in delay time for each sample period. in samples.
    f32              out_gain;
    f32              dry_gain;
    s32              max_delay_samps;
    u32 pad[4];
} AXFX_PITCHSHIFT_PRIVATE;

#endif

void __MultiCh_API_Deprecated_Warning (char *functionName);


} // namespace winext
} // namespace internal
} // namespace nw

#endif // __AXFX_PRIVATE_H__
