﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <winext/cafe/os.h>
#include <winext/cafe/mem.h>
#include <winext/cafe/ax.h>
#include <winext/cafe/axfx.h>
#include "AXFXPrivate.h"
#include <cstdlib>

namespace nw {
    namespace internal {
        namespace winext {

static void* __AXFXAllocFunction(u32 bytes)
{
    // return MEMAllocFromDefaultHeap(bytes);
    return std::malloc(bytes);
}

static void __AXFXFreeFunction(void *p)
{
    // MEMFreeToDefaultHeap(p);
    std::free(p);
}


/*--------------------------------------------------------------------------*
    memory allocation
 *--------------------------------------------------------------------------*/
AXFXAlloc   __AXFXAlloc = &__AXFXAllocFunction;
AXFXFree    __AXFXFree  = &__AXFXFreeFunction;

/*---------------------------------------------------------------------------*
  Name:         AXFX2SetMemAllocFns

  Description:  Installs custom memory allocation routines for the AXFX effects
                engines.

  Arguments:    alloc    pointer to function for allocation memory.
                free     pointer to function for freeing memory.

  Returns:      none.
 *---------------------------------------------------------------------------*/
BOOL AXFX2SetMemAllocFns(AXFXAlloc alloc, AXFXFree free)
{
    if (alloc && free)
    {
        AXFXSetHooks(alloc, free);
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/*---------------------------------------------------------------------------*
  Name:         AXFX2GetMemAllocFns

  Description:  Returns current memory allocation routines for the AXFX effects
                engines.

  Arguments:    alloc    pointer to function for allocation memory.
                free     pointer to function for freeing memory.

  Returns:      TRUE = for successful return.
 *---------------------------------------------------------------------------*/
BOOL AXFX2GetMemAllocFns(AXFXAlloc *alloc, AXFXFree *free)
{
    if(alloc && free)

    {
        AXFXGetHooks(alloc, free);
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/*---------------------------------------------------------------------------*
  Name:         AXFXSetHooks

  Description:  Installs custom memory allocation routines for the AXFX effects
                engines.

  Arguments:    alloc    pointer to function for allocation memory.
                free     pointer to function for freeing memory.

  Returns:      none.
 *---------------------------------------------------------------------------*/
void AXFXSetHooks(AXFXAlloc alloc, AXFXFree free)
{
    ASSERT(alloc && free);

    __AXFXAlloc = alloc;
    __AXFXFree  = free;
}


/*---------------------------------------------------------------------------*
  Name:         AXFXGetHooks

  Description:  Returns current memory allocation routines for the AXFX effects
                engines.

  Arguments:    alloc    pointer to function for allocation memory.
                free     pointer to function for freeing memory.

  Returns:      none.
 *---------------------------------------------------------------------------*/
void AXFXGetHooks(AXFXAlloc *alloc, AXFXFree *free)
{
    ASSERT(alloc && free);

    *alloc = __AXFXAlloc;
    *free  = __AXFXFree;
}

        } // namespace winext
    } // namespace internal
} // namespace nw
