﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <winext/cafe/os.h>
#include "AXPrivate.h"

namespace nw {
namespace internal {
namespace winext {

static AXPROFILE    *__AXProfile;
static u32          __AXMaxProfiles;
static u32          __AXCurrentProfile;
static u32          __AXProfileInitialized = 0;

AXPROFILE* __AXGetCurrentProfile(void)
{
    if (__AXProfileInitialized)
    {
        AXPROFILE *profile = &__AXProfile[__AXCurrentProfile];

        __AXCurrentProfile++;
        __AXCurrentProfile %= __AXMaxProfiles;

        return profile;
    }

    return 0;
}


/*--------------------------------------------------------------------------*
    toggle between profiler buffers and return last profile set count
 *--------------------------------------------------------------------------*/
u32 AXGetSwapProfile(AXPROFILE *profile, u32 maxProfiles)
{
    u32 n;
    int old;

    ASSERT(profile);
    ASSERT(maxProfiles);

    old = OSDisableInterrupts();

    n = __AXCurrentProfile;

//    if (n)
//        n--;

    __AXProfile             = profile;
    __AXMaxProfiles         = maxProfiles;
    __AXCurrentProfile      = 0;
    __AXProfileInitialized  = 1;

    OSRestoreInterrupts(old);

    return n;
}
/*--------------------------------------------------------------------------*
    initialize profiler
 *--------------------------------------------------------------------------*/
void AXInitProfile(AXPROFILE *profile, u32 maxProfiles)
{
    ASSERT(profile);
    ASSERT(maxProfiles);

    __AXProfile             = profile;
    __AXMaxProfiles         = maxProfiles;
    __AXCurrentProfile      = 0;
    __AXProfileInitialized  = 1;
}

u32 AXGetProfile(void)
{
    int old;
    u32 n;

    old = OSDisableInterrupts();

    n = __AXCurrentProfile;

//    if (n)
//        n--;

    __AXCurrentProfile = 0;

    OSRestoreInterrupts(old);

    return n;
}

} // namespace winext
} // namespace internal
} // namespace nw
