﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ut/ut_Inlines.h>
#include <nw/ut/ut_FileStream.h>


namespace nw {
namespace ut {

//---------------------------------------------------------------------------
bool
FileStream::Seek( s32 offset, u32 origin )
{
    NW_UNUSED_VARIABLE( offset );
    NW_UNUSED_VARIABLE( origin );

    NW_ASSERTMSG( CanSeek(), "Stream don't support SEEK function\n" );

    return false;
}


//---------------------------------------------------------------------------
void
FileStream::Cancel()
{
    NW_ASSERTMSG( CanCancel(), "Stream don't support CANCEL function\n" );
}


//---------------------------------------------------------------------------
bool
FileStream::CancelAsync( IoStreamCallback callback, void* arg )
{
    NW_UNUSED_VARIABLE( callback );
    NW_UNUSED_VARIABLE( arg );

    NW_ASSERTMSG( CanCancel(), "Stream don't support CANCEL function\n" );
    NW_ASSERTMSG( CanAsync(),  "Stream don't support ASYNC function\n" );
    return false;
}




//---------------------------------------------------------------------------
u32
FileStream::FilePosition::Skip( s32 offset )
{
    if ( offset != 0 )
    {
        s64 position = m_Position + offset;

        position = Clamp( position, static_cast<s64>(0), static_cast<s64>(m_FileSize) );

        m_Position = static_cast<u32>(position);
    }
    return m_Position;
}


//---------------------------------------------------------------------------
u32
FileStream::FilePosition::Append( s32 offset )
{
    s64 position = m_Position + offset;

    if ( position < 0 )
    {
        m_Position = 0;
    }
    else
    {
        m_Position = static_cast<u32>(position);
        m_FileSize = Max( m_Position, m_FileSize );
    }
    return m_Position;
}

//---------------------------------------------------------------------------
void
FileStream::FilePosition::Seek( s32 offset, u32 origin )
{
    switch ( origin )
    {
    case FILE_STREAM_SEEK_BEGIN:
        m_Position = 0;
        break;
    case FILE_STREAM_SEEK_CURRENT:
        break;
    case FILE_STREAM_SEEK_END:
        m_Position = m_FileSize;
        break;
    }
    (void)Skip( offset );
}




}   /* namespace ut */
}   /* namespace nw */

