﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ut/res/ut_ResDictionary.h>

namespace nw {
namespace ut {
namespace internal {

//----------------------------------------------------------------------
s32
ResDicLinear::GetIndex(const char* key) const
{
    if ( (! this->IsValid()) || (! key) ) { return -1; }

    const ResDicLinearData::ResDicNodeData* x = ref().data;

    for ( int i = 0; i < s32(ref().numData); ++i )
    {
        if ( x->toName.offset != 0 && std::strcmp(key, x->toName.to_ptr()) == 0 )
        {
            return static_cast<s32>( i );
        }
        ++x;
    }
    return -1;
}


//----------------------------------------------------------------------
ResDicPatriciaData::ResDicNodeData*
ResDicPatricia::Get(const ResName rhs) const
{
    size_t len = rhs.GetLength();
    const char* s = rhs.GetName();
    const ResDataType& r = ref();

    const ResDicPatriciaData::ResDicNodeData* p;
    const ResDicPatriciaData::ResDicNodeData* x;

    p = &r.data[0];
    x = &r.data[p->idxLeft];

    while(p->ref > x->ref)
    {
        p = x;
        // ビットが1なら右、0なら左をたどる

        u32 wd = u32(x->ref) >> 3;
        u32 pos = u32(x->ref) & 7;

        if (wd < len && ((s[wd] >> pos) & 1))
        {
            x = &r.data[x->idxRight];
        }
        else
        {
            x = &r.data[x->idxLeft];
        }
    }

    if (rhs == ResName(((u8*)&r + x->ofsString - sizeof(u32))))
    {
        return const_cast<ResDicPatriciaData::ResDicNodeData*>(x);
    }
    return NULL;
}

//----------------------------------------------------------------------
ResDicPatriciaData::ResDicNodeData*
ResDicPatricia::Get(const char* s, size_t len) const
{
    const ResDicPatriciaData::ResDicNodeData* p;
    const ResDicPatriciaData::ResDicNodeData* x;
    const ResDataType& r = this->ref();

    p = &r.data[0];
    x = &r.data[p->idxLeft];

    while(p->ref > x->ref)
    {
        p = x;
        // ビットが1なら右、0なら左をたどる

        u32 wd = u32(x->ref) >> 3;
        u32 pos = u32(x->ref) & 7;

        if (wd < len && ((s[wd] >> pos) & 1))
        {
            x = &r.data[x->idxRight];
        }
        else
        {
            x = &r.data[x->idxLeft];
        }
    }

    if (x->ofsString != 0 && !std::strcmp(s, x->ofsString.to_ptr<char>()))
    {
        return const_cast<ResDicPatriciaData::ResDicNodeData*>(x);
    }
    return NULL;
}



/* ------------------------------------------------------------------------
    ResDic
   ------------------------------------------------------------------------ */

} /* nemaspace internal */
} /* namespace ut */
} /* namespace nw */

