﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ut/ut_Inlines.h>
#include <nw/ut/os/ut_Thread.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <windows.h>
#include <process.h>
#elif defined(NW_PLATFORM_ANDROID)
#include <semaphore.h>
#endif

namespace nw {
namespace ut {

namespace {

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
void APIENTRY DummyFunc( ULONG_PTR dwParam )
{
    (void)dwParam;
}
#endif

} // namespace

//---------------------------------------------------------------------------
Thread::Thread( ThreadHandler* handler ) :
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
  m_Thread( NULL ),
  m_ThreadID( 0 ),
#endif
  m_pThreadHandler( handler )
{
#if defined(NW_PLATFORM_CAFE)
    m_Thread = ut::RoundUpTo<OSThread*>(m_ThreadBuffer, OSTHREAD_ALIGNMENT);

    OSInitThreadQueue( &m_ThreadQueue );
#endif
}

//---------------------------------------------------------------------------
Thread::~Thread()
{
    Destroy();
}

//---------------------------------------------------------------------------
bool
Thread::Create( const CreateArg& arg )
{
    m_Arg = arg;

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    m_Thread = reinterpret_cast<HANDLE>(_beginthreadex(
        NULL,
        arg.stackSize,
        ThreadFunc,
        this,
        arg.creationFlags,
        &m_ThreadID
    ));
    return m_Thread != NULL;

#elif defined(NW_PLATFORM_ANDROID)
    int result = sem_init(&m_ResumeSemaphore, 0, 0);
    NW_ASSERT(result >= 0);
    return pthread_create(&m_Thread, NULL, ThreadFunc, this) >= 0;
#elif defined(NW_PLATFORM_IOS)
    m_ResumeSemaphore = dispatch_semaphore_create(0);
    NW_ASSERT(m_ResumeSemaphore != nullptr);
    return pthread_create(&m_Thread, NULL, ThreadFunc, this) >= 0;
#else
    bool result = OSCreateThread(
        m_Thread,
        ThreadFunc,
        0,
        this,
        ut::AddOffsetToPtr( arg.stackBase, arg.stackSize ),
        arg.stackSize,
        arg.priority,
        static_cast<u16>(arg.attribute)
    );
    if ( result && arg.nameString )
    {
        OSSetThreadName( m_Thread, arg.nameString );
    }
    return result;
#endif
}

//---------------------------------------------------------------------------
void
Thread::Destroy()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    if ( m_Thread != NULL )
    {
        CloseHandle( m_Thread );
        m_Thread = NULL;
    }
#endif
}

//---------------------------------------------------------------------------
void
Thread::SetPriority( s32 priority )
{
    m_Arg.priority = priority;

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    SetThreadPriority( m_Thread, priority );
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    NW_UNUSED_VARIABLE(priority);
    NW_NOT_IMPLEMENTED();
#else
    OSSetThreadPriority( m_Thread, priority );
#endif
}

//---------------------------------------------------------------------------
s32
Thread::GetPriority() const
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    return GetThreadPriority( m_Thread );
#else
    return m_Arg.priority;
#endif
}

//---------------------------------------------------------------------------
void
Thread::Join()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    WaitForSingleObject( m_Thread, INFINITE );
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    const int result = pthread_join(m_Thread, NULL);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#else
    OSJoinThread( m_Thread, NULL );
#endif
}

//---------------------------------------------------------------------------
void
Thread::Resume()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    ResumeThread( m_Thread );
#elif defined(NW_PLATFORM_ANDROID)
    int result = sem_post(&m_ResumeSemaphore);
    NW_ASSERT(result >= 0);
#elif defined(NW_PLATFORM_IOS)
    const long result = dispatch_semaphore_signal(m_ResumeSemaphore);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#else
    OSResumeThread( m_Thread );
#endif
}

//---------------------------------------------------------------------------
void
Thread::Exit()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    ExitThread( 0 );
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    pthread_exit( nullptr );
#else
    OSExitThread( NULL );
#endif
}

//---------------------------------------------------------------------------
void
Thread::Sleep()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    SleepEx( INFINITE, true );
#elif defined(NW_PLATFORM_ANDROID)
    int result = sem_wait(&m_ResumeSemaphore);
    NW_ASSERT(result >= 0);
#elif defined(NW_PLATFORM_IOS)
    const long result = dispatch_semaphore_wait(m_ResumeSemaphore, DISPATCH_TIME_FOREVER);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#else
    OSSleepThread( &m_ThreadQueue );
#endif
}

//---------------------------------------------------------------------------
void
Thread::Wakeup()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    QueueUserAPC( DummyFunc, m_Thread, 0 );
#elif defined(NW_PLATFORM_ANDROID)
    int result = sem_post(&m_ResumeSemaphore);
    NW_ASSERT(result >= 0);
#elif defined(NW_PLATFORM_IOS)
    const long result = dispatch_semaphore_signal(m_ResumeSemaphore);
    NW_ASSERT(result >= 0);
    NW_UNUSED_VARIABLE(result);
#else
    OSWakeupThread( &m_ThreadQueue );
#endif
}

//---------------------------------------------------------------------------
bool
Thread::IsTerminated()
{
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    DWORD dwParam;
    GetExitCodeThread( m_Thread, &dwParam );
    if ( dwParam == STILL_ACTIVE )
    {
        return false;
    }
    return true;
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    NW_NOT_IMPLEMENTED();
    return false;
#else
    return OSIsThreadTerminated( m_Thread );
#endif
}

//---------------------------------------------------------------------------
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
unsigned int __stdcall
Thread::ThreadFunc(void* arg)
{
    Thread* thread = reinterpret_cast<Thread*>( arg );
    thread->m_pThreadHandler->ThreadHandlerProc();

    return 0;
}
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
void*
Thread::ThreadFunc(void* ptrArg)
{
    Thread* thread = reinterpret_cast<Thread*>(ptrArg);

    // TODO:
    thread->Sleep();

#if 0
    OSReport("[Thread(%p):AffinityMask] (%08x) (%08x/%08x/%08x)\n",
        thread,
        OSGetThreadAffinity(&thread->m_Thread),
        OS_THREAD_ATTR_AFFINITY_CORE0,
        OS_THREAD_ATTR_AFFINITY_CORE1,
        OS_THREAD_ATTR_AFFINITY_CORE2);
#endif

    thread->m_pThreadHandler->ThreadHandlerProc();

    return 0;
}
#else
int
Thread::ThreadFunc(int intArg, void* ptrArg)
{
    Thread* thread = reinterpret_cast<Thread*>( ptrArg );

#if 0
    OSReport("[Thread(%p):AffinityMask] (%08x) (%08x/%08x/%08x)\n",
        thread,
        OSGetThreadAffinity( &thread->m_Thread ),
        OS_THREAD_ATTR_AFFINITY_CORE0,
        OS_THREAD_ATTR_AFFINITY_CORE1,
        OS_THREAD_ATTR_AFFINITY_CORE2 );
#endif

    thread->m_pThreadHandler->ThreadHandlerProc();

    return 0;
}
#endif

} // namespace os
} // namespace nw


