﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//
// http://unicode.org/reports/tr14/ を基準にゲーム開発で必要となりそうなものだけを取り込んだもの。
//

#include <nw/ut/ut_Inlines.h>
#include <nw/ut/ut_Memory.h>
#include <nw/font/font_WordWrapping.h>

#define ARRAY_LENGTH(a) (sizeof(a) / sizeof(a[0]))

namespace nw {
namespace font {

namespace {

//
// 改行処理
//
enum LineBreakAction
{
    cDirect = 0     // 改行可能(SPを含む場合は最後の空白のあと)
    , cIndirect     // 間接改行可能(1つ以上空白を含む場合に改行可能)
    , cCmIndirect   // 間接改行可能な複合文字(CM属性のもの)
    , cCmProhibit   // 改行禁止な複合文字(CM属性のもの)
    , cProhibit     // 改行禁止
};

//
// 改行属性
// 詳細はhttp://unicode.org/reports/tr14/
//
enum LineBreakProperty
{
    // Pair-Table内
    cProperty_OP = 0
    , cProperty_CL
    , cProperty_CP
    , cProperty_QU
    , cProperty_GL
    , cProperty_NS
    , cProperty_EX
    , cProperty_SY
    , cProperty_IS
    , cProperty_PR
    , cProperty_PO
    , cProperty_NU
    , cProperty_AL
    , cProperty_HL
    , cProperty_ID
    , cProperty_IN
    , cProperty_HY
    , cProperty_BA
    , cProperty_BB
    , cProperty_B2
    , cProperty_ZW
    , cProperty_CM
    , cProperty_WJ
    , cProperty_H2
    , cProperty_H3
    , cProperty_JL
    , cProperty_JV
    , cProperty_JT
    , cProperty_RI
    // Pair-Table外
    , cProperty_AI
    , cProperty_BK
    , cProperty_CB
    , cProperty_CJ
    , cProperty_CR
    , cProperty_LF
    , cProperty_NL
    , cProperty_SA
    , cProperty_SG
    , cProperty_SP
    , cProperty_XX
    , cProperty_Max
    , cProperty_PairTableEnd = cProperty_RI+1
};

//
// Unicodeから改行属性へのマッピング・テーブル型。
//
struct UnicodeToLineBreakProperty
{
    u16 mCode;
    u8 mNum;
    u8 mProperty; // (LineBreakProperty)
};

} // namespace {anonymous}

//
// Unicodeから改行属性へのマッピング・テーブル。
// テーブルに存在しないデータはIDとして扱います。
//
static const UnicodeToLineBreakProperty cUnicodeToProperty[] =
{
    { 0x0000,   8, cProperty_CM },
    { 0x0009,   0, cProperty_BA },
    { 0x000A,   0, cProperty_LF },
    { 0x000B,   1, cProperty_BK },
    { 0x000D,   0, cProperty_CR },
    { 0x000E,  17, cProperty_CM },
    { 0x0020,   0, cProperty_SP },
    { 0x0021,   0, cProperty_EX },
    { 0x0022,   0, cProperty_QU },
    { 0x0023,   0, cProperty_AL },
    { 0x0024,   0, cProperty_PR },
    { 0x0025,   0, cProperty_PO },
    { 0x0026,   0, cProperty_AL },
    { 0x0027,   0, cProperty_QU },
    { 0x0028,   0, cProperty_OP },
    { 0x0029,   0, cProperty_CP },
    { 0x002A,   0, cProperty_AL },
    { 0x002B,   0, cProperty_PR },
    { 0x002C,   0, cProperty_IS },
    { 0x002D,   0, cProperty_HY },
    { 0x002E,   0, cProperty_IS },
    { 0x002F,   0, cProperty_SY },
    { 0x0030,   9, cProperty_NU },
    { 0x003A,   1, cProperty_IS },
    { 0x003C,   2, cProperty_AL },
    { 0x003F,   0, cProperty_EX },
    { 0x0040,  26, cProperty_AL },
    { 0x005B,   0, cProperty_OP },
    { 0x005C,   0, cProperty_PR },
    { 0x005D,   0, cProperty_CP },
    { 0x005E,  28, cProperty_AL },
    { 0x007B,   0, cProperty_OP },
    { 0x007C,   0, cProperty_BA },
    { 0x007D,   0, cProperty_CL },
    { 0x007E,   0, cProperty_AL },
    { 0x007F,   5, cProperty_CM },
    { 0x0085,   0, cProperty_NL },
    { 0x0086,  25, cProperty_CM },
    { 0x00A0,   0, cProperty_GL },
    { 0x00A1,   0, cProperty_OP },
    { 0x00A2,   0, cProperty_PO },
    { 0x00A3,   2, cProperty_PR },
    { 0x00A6,   0, cProperty_AL },
    { 0x00A7,   1, cProperty_AI },
    { 0x00A9,   0, cProperty_AL },
    { 0x00AA,   0, cProperty_AI },
    { 0x00AB,   0, cProperty_QU },
    { 0x00AC,   0, cProperty_AL },
    { 0x00AD,   0, cProperty_BA },
    { 0x00AE,   1, cProperty_AL },
    { 0x00B0,   0, cProperty_PO },
    { 0x00B1,   0, cProperty_PR },
    { 0x00B2,   1, cProperty_AI },
    { 0x00B4,   0, cProperty_BB },
    { 0x00B5,   0, cProperty_AL },
    { 0x00B6,   4, cProperty_AI },
    { 0x00BB,   0, cProperty_QU },
    { 0x00BC,   2, cProperty_AI },
    { 0x00BF,   0, cProperty_OP },
    { 0x00C0,  22, cProperty_AL },
    { 0x00D7,   0, cProperty_AI },
    { 0x00D8,  30, cProperty_AL },
    { 0x00F7,   0, cProperty_AI },
    { 0x00F8, 255, cProperty_AL },
    { 0x01F8, 206, cProperty_AL },
    { 0x02C7,   0, cProperty_AI },
    { 0x02C8,   0, cProperty_BB },
    { 0x02C9,   2, cProperty_AI },
    { 0x02CC,   0, cProperty_BB },
    { 0x02CD,   0, cProperty_AI },
    { 0x02CE,   1, cProperty_AL },
    { 0x02D0,   0, cProperty_AI },
    { 0x02D1,   6, cProperty_AL },
    { 0x02D8,   3, cProperty_AI },
    { 0x02DC,   0, cProperty_AL },
    { 0x02DD,   0, cProperty_AI },
    { 0x02DE,   0, cProperty_AL },
    { 0x02DF,   0, cProperty_BB },
    { 0x02E0,  31, cProperty_AL },
    { 0x0300,  78, cProperty_CM },
    { 0x034F,   0, cProperty_GL },
    { 0x0350,  11, cProperty_CM },
    { 0x035C,   6, cProperty_GL },
    { 0x0363,  12, cProperty_CM },
    { 0x0370,   7, cProperty_AL },
    { 0x037A,   3, cProperty_AL },
    { 0x037E,   0, cProperty_IS },
    { 0x0384,   6, cProperty_AL },
    { 0x038C,   0, cProperty_AL },
    { 0x038E,  19, cProperty_AL },
    { 0x03A3, 223, cProperty_AL },
    { 0x0483,   6, cProperty_CM },
    { 0x048A, 157, cProperty_AL },
    { 0x0531,  37, cProperty_AL },
    { 0x0559,   6, cProperty_AL },
    { 0x0561,  38, cProperty_AL },
    { 0x0589,   0, cProperty_IS },
    { 0x058A,   0, cProperty_BA },
    { 0x058F,   0, cProperty_PR },
    { 0x0591,  44, cProperty_CM },
    { 0x05BE,   0, cProperty_BA },
    { 0x05BF,   0, cProperty_CM },
    { 0x05C0,   0, cProperty_AL },
    { 0x05C1,   1, cProperty_CM },
    { 0x05C3,   0, cProperty_AL },
    { 0x05C4,   1, cProperty_CM },
    { 0x05C6,   0, cProperty_EX },
    { 0x05C7,   0, cProperty_CM },
    { 0x05D0,  26, cProperty_HL },
    { 0x05F0,   2, cProperty_HL },
    { 0x05F3,   1, cProperty_AL },
    { 0x0600,   4, cProperty_AL },
    { 0x0606,   2, cProperty_AL },
    { 0x0609,   2, cProperty_PO },
    { 0x060C,   1, cProperty_IS },
    { 0x060E,   1, cProperty_AL },
    { 0x0610,  10, cProperty_CM },
    { 0x061B,   0, cProperty_EX },
    { 0x061E,   1, cProperty_EX },
    { 0x0620,  42, cProperty_AL },
    { 0x064B,  20, cProperty_CM },
    { 0x0660,   9, cProperty_NU },
    { 0x066A,   0, cProperty_PO },
    { 0x066B,   1, cProperty_NU },
    { 0x066D,   2, cProperty_AL },
    { 0x0670,   0, cProperty_CM },
    { 0x0671,  98, cProperty_AL },
    { 0x06D4,   0, cProperty_EX },
    { 0x06D5,   0, cProperty_AL },
    { 0x06D6,   6, cProperty_CM },
    { 0x06DD,   1, cProperty_AL },
    { 0x06DF,   5, cProperty_CM },
    { 0x06E5,   1, cProperty_AL },
    { 0x06E7,   1, cProperty_CM },
    { 0x06E9,   0, cProperty_AL },
    { 0x06EA,   3, cProperty_CM },
    { 0x06EE,   1, cProperty_AL },
    { 0x06F0,   9, cProperty_NU },
    { 0x06FA,  19, cProperty_AL },
    { 0x070F,   1, cProperty_AL },
    { 0x0711,   0, cProperty_CM },
    { 0x0712,  29, cProperty_AL },
    { 0x0730,  26, cProperty_CM },
    { 0x074D,  88, cProperty_AL },
    { 0x07A6,  10, cProperty_CM },
    { 0x07B1,   0, cProperty_AL },
    { 0x07C0,   9, cProperty_NU },
    { 0x07CA,  32, cProperty_AL },
    { 0x07EB,   8, cProperty_CM },
    { 0x07F4,   3, cProperty_AL },
    { 0x07F8,   0, cProperty_IS },
    { 0x07F9,   0, cProperty_EX },
    { 0x07FA,   0, cProperty_AL },
    { 0x0800,  21, cProperty_AL },
    { 0x0816,   3, cProperty_CM },
    { 0x081A,   0, cProperty_AL },
    { 0x081B,   8, cProperty_CM },
    { 0x0824,   0, cProperty_AL },
    { 0x0825,   2, cProperty_CM },
    { 0x0828,   0, cProperty_AL },
    { 0x0829,   4, cProperty_CM },
    { 0x0830,  14, cProperty_AL },
    { 0x0840,  24, cProperty_AL },
    { 0x0859,   2, cProperty_CM },
    { 0x085E,   0, cProperty_AL },
    { 0x08A0,   0, cProperty_AL },
    { 0x08A2,  10, cProperty_AL },
    { 0x08E4,  26, cProperty_CM },
    { 0x0900,   3, cProperty_CM },
    { 0x0904,  53, cProperty_AL },
    { 0x093A,   2, cProperty_CM },
    { 0x093D,   0, cProperty_AL },
    { 0x093E,  17, cProperty_CM },
    { 0x0950,   0, cProperty_AL },
    { 0x0951,   6, cProperty_CM },
    { 0x0958,   9, cProperty_AL },
    { 0x0962,   1, cProperty_CM },
    { 0x0964,   1, cProperty_BA },
    { 0x0966,   9, cProperty_NU },
    { 0x0970,   7, cProperty_AL },
    { 0x0979,   6, cProperty_AL },
    { 0x0981,   2, cProperty_CM },
    { 0x0985,   7, cProperty_AL },
    { 0x098F,   1, cProperty_AL },
    { 0x0993,  21, cProperty_AL },
    { 0x09AA,   6, cProperty_AL },
    { 0x09B2,   0, cProperty_AL },
    { 0x09B6,   3, cProperty_AL },
    { 0x09BC,   0, cProperty_CM },
    { 0x09BD,   0, cProperty_AL },
    { 0x09BE,   6, cProperty_CM },
    { 0x09C7,   1, cProperty_CM },
    { 0x09CB,   2, cProperty_CM },
    { 0x09CE,   0, cProperty_AL },
    { 0x09D7,   0, cProperty_CM },
    { 0x09DC,   1, cProperty_AL },
    { 0x09DF,   2, cProperty_AL },
    { 0x09E2,   1, cProperty_CM },
    { 0x09E6,   9, cProperty_NU },
    { 0x09F0,   1, cProperty_AL },
    { 0x09F2,   1, cProperty_PO },
    { 0x09F4,   4, cProperty_AL },
    { 0x09F9,   0, cProperty_PO },
    { 0x09FA,   0, cProperty_AL },
    { 0x09FB,   0, cProperty_PR },
    { 0x0A01,   2, cProperty_CM },
    { 0x0A05,   5, cProperty_AL },
    { 0x0A0F,   1, cProperty_AL },
    { 0x0A13,  21, cProperty_AL },
    { 0x0A2A,   6, cProperty_AL },
    { 0x0A32,   1, cProperty_AL },
    { 0x0A35,   1, cProperty_AL },
    { 0x0A38,   1, cProperty_AL },
    { 0x0A3C,   0, cProperty_CM },
    { 0x0A3E,   4, cProperty_CM },
    { 0x0A47,   1, cProperty_CM },
    { 0x0A4B,   2, cProperty_CM },
    { 0x0A51,   0, cProperty_CM },
    { 0x0A59,   3, cProperty_AL },
    { 0x0A5E,   0, cProperty_AL },
    { 0x0A66,   9, cProperty_NU },
    { 0x0A70,   1, cProperty_CM },
    { 0x0A72,   2, cProperty_AL },
    { 0x0A75,   0, cProperty_CM },
    { 0x0A81,   2, cProperty_CM },
    { 0x0A85,   8, cProperty_AL },
    { 0x0A8F,   2, cProperty_AL },
    { 0x0A93,  21, cProperty_AL },
    { 0x0AAA,   6, cProperty_AL },
    { 0x0AB2,   1, cProperty_AL },
    { 0x0AB5,   4, cProperty_AL },
    { 0x0ABC,   0, cProperty_CM },
    { 0x0ABD,   0, cProperty_AL },
    { 0x0ABE,   7, cProperty_CM },
    { 0x0AC7,   2, cProperty_CM },
    { 0x0ACB,   2, cProperty_CM },
    { 0x0AD0,   0, cProperty_AL },
    { 0x0AE0,   1, cProperty_AL },
    { 0x0AE2,   1, cProperty_CM },
    { 0x0AE6,   9, cProperty_NU },
    { 0x0AF0,   0, cProperty_AL },
    { 0x0AF1,   0, cProperty_PR },
    { 0x0B01,   2, cProperty_CM },
    { 0x0B05,   7, cProperty_AL },
    { 0x0B0F,   1, cProperty_AL },
    { 0x0B13,  21, cProperty_AL },
    { 0x0B2A,   6, cProperty_AL },
    { 0x0B32,   1, cProperty_AL },
    { 0x0B35,   4, cProperty_AL },
    { 0x0B3C,   0, cProperty_CM },
    { 0x0B3D,   0, cProperty_AL },
    { 0x0B3E,   6, cProperty_CM },
    { 0x0B47,   1, cProperty_CM },
    { 0x0B4B,   2, cProperty_CM },
    { 0x0B56,   1, cProperty_CM },
    { 0x0B5C,   1, cProperty_AL },
    { 0x0B5F,   2, cProperty_AL },
    { 0x0B62,   1, cProperty_CM },
    { 0x0B66,   9, cProperty_NU },
    { 0x0B70,   7, cProperty_AL },
    { 0x0B82,   0, cProperty_CM },
    { 0x0B83,   0, cProperty_AL },
    { 0x0B85,   5, cProperty_AL },
    { 0x0B8E,   2, cProperty_AL },
    { 0x0B92,   3, cProperty_AL },
    { 0x0B99,   1, cProperty_AL },
    { 0x0B9C,   0, cProperty_AL },
    { 0x0B9E,   1, cProperty_AL },
    { 0x0BA3,   1, cProperty_AL },
    { 0x0BA8,   2, cProperty_AL },
    { 0x0BAE,  11, cProperty_AL },
    { 0x0BBE,   4, cProperty_CM },
    { 0x0BC6,   2, cProperty_CM },
    { 0x0BCA,   3, cProperty_CM },
    { 0x0BD0,   0, cProperty_AL },
    { 0x0BD7,   0, cProperty_CM },
    { 0x0BE6,   9, cProperty_NU },
    { 0x0BF0,   8, cProperty_AL },
    { 0x0BF9,   0, cProperty_PR },
    { 0x0BFA,   0, cProperty_AL },
    { 0x0C01,   2, cProperty_CM },
    { 0x0C05,   7, cProperty_AL },
    { 0x0C0E,   2, cProperty_AL },
    { 0x0C12,  22, cProperty_AL },
    { 0x0C2A,   9, cProperty_AL },
    { 0x0C35,   4, cProperty_AL },
    { 0x0C3D,   0, cProperty_AL },
    { 0x0C3E,   6, cProperty_CM },
    { 0x0C46,   2, cProperty_CM },
    { 0x0C4A,   3, cProperty_CM },
    { 0x0C55,   1, cProperty_CM },
    { 0x0C58,   1, cProperty_AL },
    { 0x0C60,   1, cProperty_AL },
    { 0x0C62,   1, cProperty_CM },
    { 0x0C66,   9, cProperty_NU },
    { 0x0C78,   7, cProperty_AL },
    { 0x0C82,   1, cProperty_CM },
    { 0x0C85,   7, cProperty_AL },
    { 0x0C8E,   2, cProperty_AL },
    { 0x0C92,  22, cProperty_AL },
    { 0x0CAA,   9, cProperty_AL },
    { 0x0CB5,   4, cProperty_AL },
    { 0x0CBC,   0, cProperty_CM },
    { 0x0CBD,   0, cProperty_AL },
    { 0x0CBE,   6, cProperty_CM },
    { 0x0CC6,   2, cProperty_CM },
    { 0x0CCA,   3, cProperty_CM },
    { 0x0CD5,   1, cProperty_CM },
    { 0x0CDE,   0, cProperty_AL },
    { 0x0CE0,   1, cProperty_AL },
    { 0x0CE2,   1, cProperty_CM },
    { 0x0CE6,   9, cProperty_NU },
    { 0x0CF1,   1, cProperty_AL },
    { 0x0D02,   1, cProperty_CM },
    { 0x0D05,   7, cProperty_AL },
    { 0x0D0E,   2, cProperty_AL },
    { 0x0D12,  40, cProperty_AL },
    { 0x0D3D,   0, cProperty_AL },
    { 0x0D3E,   6, cProperty_CM },
    { 0x0D46,   2, cProperty_CM },
    { 0x0D4A,   3, cProperty_CM },
    { 0x0D4E,   0, cProperty_AL },
    { 0x0D57,   0, cProperty_CM },
    { 0x0D60,   1, cProperty_AL },
    { 0x0D62,   1, cProperty_CM },
    { 0x0D66,   9, cProperty_NU },
    { 0x0D70,   5, cProperty_AL },
    { 0x0D79,   0, cProperty_PO },
    { 0x0D7A,   5, cProperty_AL },
    { 0x0D82,   1, cProperty_CM },
    { 0x0D85,  17, cProperty_AL },
    { 0x0D9A,  23, cProperty_AL },
    { 0x0DB3,   8, cProperty_AL },
    { 0x0DBD,   0, cProperty_AL },
    { 0x0DC0,   6, cProperty_AL },
    { 0x0DCA,   0, cProperty_CM },
    { 0x0DCF,   5, cProperty_CM },
    { 0x0DD6,   0, cProperty_CM },
    { 0x0DD8,   7, cProperty_CM },
    { 0x0DF2,   1, cProperty_CM },
    { 0x0DF4,   0, cProperty_AL },
    { 0x0E01,  57, cProperty_SA },
    { 0x0E3F,   0, cProperty_PR },
    { 0x0E40,  14, cProperty_SA },
    { 0x0E4F,   0, cProperty_AL },
    { 0x0E50,   9, cProperty_NU },
    { 0x0E5A,   1, cProperty_BA },
    { 0x0E81,   1, cProperty_SA },
    { 0x0E84,   0, cProperty_SA },
    { 0x0E87,   1, cProperty_SA },
    { 0x0E8A,   0, cProperty_SA },
    { 0x0E8D,   0, cProperty_SA },
    { 0x0E94,   3, cProperty_SA },
    { 0x0E99,   6, cProperty_SA },
    { 0x0EA1,   2, cProperty_SA },
    { 0x0EA5,   0, cProperty_SA },
    { 0x0EA7,   0, cProperty_SA },
    { 0x0EAA,   1, cProperty_SA },
    { 0x0EAD,  12, cProperty_SA },
    { 0x0EBB,   2, cProperty_SA },
    { 0x0EC0,   4, cProperty_SA },
    { 0x0EC6,   0, cProperty_SA },
    { 0x0EC8,   5, cProperty_SA },
    { 0x0ED0,   9, cProperty_NU },
    { 0x0EDC,   3, cProperty_SA },
    { 0x0F00,   0, cProperty_AL },
    { 0x0F01,   3, cProperty_BB },
    { 0x0F05,   0, cProperty_AL },
    { 0x0F06,   1, cProperty_BB },
    { 0x0F08,   0, cProperty_GL },
    { 0x0F09,   1, cProperty_BB },
    { 0x0F0B,   0, cProperty_BA },
    { 0x0F0C,   0, cProperty_GL },
    { 0x0F0D,   4, cProperty_EX },
    { 0x0F12,   0, cProperty_GL },
    { 0x0F13,   0, cProperty_AL },
    { 0x0F14,   0, cProperty_EX },
    { 0x0F15,   2, cProperty_AL },
    { 0x0F18,   1, cProperty_CM },
    { 0x0F1A,   5, cProperty_AL },
    { 0x0F20,   9, cProperty_NU },
    { 0x0F2A,   9, cProperty_AL },
    { 0x0F34,   0, cProperty_BA },
    { 0x0F35,   0, cProperty_CM },
    { 0x0F36,   0, cProperty_AL },
    { 0x0F37,   0, cProperty_CM },
    { 0x0F38,   0, cProperty_AL },
    { 0x0F39,   0, cProperty_CM },
    { 0x0F3A,   0, cProperty_OP },
    { 0x0F3B,   0, cProperty_CL },
    { 0x0F3C,   0, cProperty_OP },
    { 0x0F3D,   0, cProperty_CL },
    { 0x0F3E,   1, cProperty_CM },
    { 0x0F40,   7, cProperty_AL },
    { 0x0F49,  35, cProperty_AL },
    { 0x0F71,  13, cProperty_CM },
    { 0x0F7F,   0, cProperty_BA },
    { 0x0F80,   4, cProperty_CM },
    { 0x0F85,   0, cProperty_BA },
    { 0x0F86,   1, cProperty_CM },
    { 0x0F88,   4, cProperty_AL },
    { 0x0F8D,  10, cProperty_CM },
    { 0x0F99,  35, cProperty_CM },
    { 0x0FBE,   1, cProperty_BA },
    { 0x0FC0,   5, cProperty_AL },
    { 0x0FC6,   0, cProperty_CM },
    { 0x0FC7,   5, cProperty_AL },
    { 0x0FCE,   1, cProperty_AL },
    { 0x0FD0,   1, cProperty_BB },
    { 0x0FD2,   0, cProperty_BA },
    { 0x0FD3,   0, cProperty_BB },
    { 0x0FD4,   4, cProperty_AL },
    { 0x0FD9,   1, cProperty_GL },
    { 0x1000,  63, cProperty_SA },
    { 0x1040,   9, cProperty_NU },
    { 0x104A,   1, cProperty_BA },
    { 0x104C,   3, cProperty_AL },
    { 0x1050,  63, cProperty_SA },
    { 0x1090,   9, cProperty_NU },
    { 0x109A,   5, cProperty_SA },
    { 0x10A0,  37, cProperty_AL },
    { 0x10C7,   0, cProperty_AL },
    { 0x10CD,   0, cProperty_AL },
    { 0x10D0,  47, cProperty_AL },
    { 0x1100,  95, cProperty_JL },
    { 0x1160,  71, cProperty_JV },
    { 0x11A8,  87, cProperty_JT },
    { 0x1200,  72, cProperty_AL },
    { 0x124A,   3, cProperty_AL },
    { 0x1250,   6, cProperty_AL },
    { 0x1258,   0, cProperty_AL },
    { 0x125A,   3, cProperty_AL },
    { 0x1260,  40, cProperty_AL },
    { 0x128A,   3, cProperty_AL },
    { 0x1290,  32, cProperty_AL },
    { 0x12B2,   3, cProperty_AL },
    { 0x12B8,   6, cProperty_AL },
    { 0x12C0,   0, cProperty_AL },
    { 0x12C2,   3, cProperty_AL },
    { 0x12C8,  14, cProperty_AL },
    { 0x12D8,  56, cProperty_AL },
    { 0x1312,   3, cProperty_AL },
    { 0x1318,  66, cProperty_AL },
    { 0x135D,   2, cProperty_CM },
    { 0x1360,   0, cProperty_AL },
    { 0x1361,   0, cProperty_BA },
    { 0x1362,  26, cProperty_AL },
    { 0x1380,  25, cProperty_AL },
    { 0x13A0,  84, cProperty_AL },
    { 0x1400,   0, cProperty_BA },
    { 0x1401, 255, cProperty_AL },
    { 0x1501, 255, cProperty_AL },
    { 0x1601, 126, cProperty_AL },
    { 0x1680,   0, cProperty_BA },
    { 0x1681,  25, cProperty_AL },
    { 0x169B,   0, cProperty_OP },
    { 0x169C,   0, cProperty_CL },
    { 0x16A0,  74, cProperty_AL },
    { 0x16EB,   2, cProperty_BA },
    { 0x16EE,   2, cProperty_AL },
    { 0x1700,  12, cProperty_AL },
    { 0x170E,   3, cProperty_AL },
    { 0x1712,   2, cProperty_CM },
    { 0x1720,  17, cProperty_AL },
    { 0x1732,   2, cProperty_CM },
    { 0x1735,   1, cProperty_BA },
    { 0x1740,  17, cProperty_AL },
    { 0x1752,   1, cProperty_CM },
    { 0x1760,  12, cProperty_AL },
    { 0x176E,   2, cProperty_AL },
    { 0x1772,   1, cProperty_CM },
    { 0x1780,  83, cProperty_SA },
    { 0x17D4,   1, cProperty_BA },
    { 0x17D6,   0, cProperty_NS },
    { 0x17D7,   0, cProperty_SA },
    { 0x17D8,   0, cProperty_BA },
    { 0x17D9,   0, cProperty_AL },
    { 0x17DA,   0, cProperty_BA },
    { 0x17DB,   0, cProperty_PR },
    { 0x17DC,   1, cProperty_SA },
    { 0x17E0,   9, cProperty_NU },
    { 0x17F0,   9, cProperty_AL },
    { 0x1800,   1, cProperty_AL },
    { 0x1802,   1, cProperty_EX },
    { 0x1804,   1, cProperty_BA },
    { 0x1806,   0, cProperty_BB },
    { 0x1807,   0, cProperty_AL },
    { 0x1808,   1, cProperty_EX },
    { 0x180A,   0, cProperty_AL },
    { 0x180B,   2, cProperty_CM },
    { 0x180E,   0, cProperty_GL },
    { 0x1810,   9, cProperty_NU },
    { 0x1820,  87, cProperty_AL },
    { 0x1880,  40, cProperty_AL },
    { 0x18A9,   0, cProperty_CM },
    { 0x18AA,   0, cProperty_AL },
    { 0x18B0,  69, cProperty_AL },
    { 0x1900,  28, cProperty_AL },
    { 0x1920,  11, cProperty_CM },
    { 0x1930,  11, cProperty_CM },
    { 0x1940,   0, cProperty_AL },
    { 0x1944,   1, cProperty_EX },
    { 0x1946,   9, cProperty_NU },
    { 0x1950,  29, cProperty_SA },
    { 0x1970,   4, cProperty_SA },
    { 0x1980,  43, cProperty_SA },
    { 0x19B0,  25, cProperty_SA },
    { 0x19D0,   9, cProperty_NU },
    { 0x19DA,   0, cProperty_SA },
    { 0x19DE,   1, cProperty_SA },
    { 0x19E0,  54, cProperty_AL },
    { 0x1A17,   4, cProperty_CM },
    { 0x1A1E,   1, cProperty_AL },
    { 0x1A20,  62, cProperty_SA },
    { 0x1A60,  28, cProperty_SA },
    { 0x1A7F,   0, cProperty_CM },
    { 0x1A80,   9, cProperty_NU },
    { 0x1A90,   9, cProperty_NU },
    { 0x1AA0,  13, cProperty_SA },
    { 0x1B00,   4, cProperty_CM },
    { 0x1B05,  46, cProperty_AL },
    { 0x1B34,  16, cProperty_CM },
    { 0x1B45,   6, cProperty_AL },
    { 0x1B50,   9, cProperty_NU },
    { 0x1B5A,   1, cProperty_BA },
    { 0x1B5C,   0, cProperty_AL },
    { 0x1B5D,   3, cProperty_BA },
    { 0x1B61,   9, cProperty_AL },
    { 0x1B6B,   8, cProperty_CM },
    { 0x1B74,   8, cProperty_AL },
    { 0x1B80,   2, cProperty_CM },
    { 0x1B83,  29, cProperty_AL },
    { 0x1BA1,  12, cProperty_CM },
    { 0x1BAE,   1, cProperty_AL },
    { 0x1BB0,   9, cProperty_NU },
    { 0x1BBA,  43, cProperty_AL },
    { 0x1BE6,  13, cProperty_CM },
    { 0x1BFC,  39, cProperty_AL },
    { 0x1C24,  19, cProperty_CM },
    { 0x1C3B,   4, cProperty_BA },
    { 0x1C40,   9, cProperty_NU },
    { 0x1C4D,   2, cProperty_AL },
    { 0x1C50,   9, cProperty_NU },
    { 0x1C5A,  35, cProperty_AL },
    { 0x1C7E,   1, cProperty_BA },
    { 0x1CC0,   7, cProperty_AL },
    { 0x1CD0,   2, cProperty_CM },
    { 0x1CD3,   0, cProperty_AL },
    { 0x1CD4,  20, cProperty_CM },
    { 0x1CE9,   3, cProperty_AL },
    { 0x1CED,   0, cProperty_CM },
    { 0x1CEE,   3, cProperty_AL },
    { 0x1CF2,   2, cProperty_CM },
    { 0x1CF5,   1, cProperty_AL },
    { 0x1D00, 191, cProperty_AL },
    { 0x1DC0,  38, cProperty_CM },
    { 0x1DFC,   3, cProperty_CM },
    { 0x1E00, 255, cProperty_AL },
    { 0x1F00,  21, cProperty_AL },
    { 0x1F18,   5, cProperty_AL },
    { 0x1F20,  37, cProperty_AL },
    { 0x1F48,   5, cProperty_AL },
    { 0x1F50,   7, cProperty_AL },
    { 0x1F59,   0, cProperty_AL },
    { 0x1F5B,   0, cProperty_AL },
    { 0x1F5D,   0, cProperty_AL },
    { 0x1F5F,  30, cProperty_AL },
    { 0x1F80,  52, cProperty_AL },
    { 0x1FB6,  14, cProperty_AL },
    { 0x1FC6,  13, cProperty_AL },
    { 0x1FD6,   5, cProperty_AL },
    { 0x1FDD,  18, cProperty_AL },
    { 0x1FF2,   2, cProperty_AL },
    { 0x1FF6,   6, cProperty_AL },
    { 0x1FFD,   0, cProperty_BB },
    { 0x1FFE,   0, cProperty_AL },
    { 0x2000,   6, cProperty_BA },
    { 0x2007,   0, cProperty_GL },
    { 0x2008,   2, cProperty_BA },
    { 0x200B,   0, cProperty_ZW },
    { 0x200C,   3, cProperty_CM },
    { 0x2010,   0, cProperty_BA },
    { 0x2011,   0, cProperty_GL },
    { 0x2012,   1, cProperty_BA },
    { 0x2014,   0, cProperty_B2 },
    { 0x2015,   1, cProperty_AI },
    { 0x2017,   0, cProperty_AL },
    { 0x2018,   1, cProperty_QU },
    { 0x201A,   0, cProperty_OP },
    { 0x201B,   2, cProperty_QU },
    { 0x201E,   0, cProperty_OP },
    { 0x201F,   0, cProperty_QU },
    { 0x2020,   1, cProperty_AI },
    { 0x2022,   1, cProperty_AL },
    { 0x2024,   2, cProperty_IN },
    { 0x2027,   0, cProperty_BA },
    { 0x2028,   1, cProperty_BK },
    { 0x202A,   4, cProperty_CM },
    { 0x202F,   0, cProperty_GL },
    { 0x2030,   7, cProperty_PO },
    { 0x2038,   0, cProperty_AL },
    { 0x2039,   1, cProperty_QU },
    { 0x203B,   0, cProperty_AI },
    { 0x203C,   1, cProperty_NS },
    { 0x203E,   5, cProperty_AL },
    { 0x2044,   0, cProperty_IS },
    { 0x2045,   0, cProperty_OP },
    { 0x2046,   0, cProperty_CL },
    { 0x2047,   2, cProperty_NS },
    { 0x204A,  11, cProperty_AL },
    { 0x2056,   0, cProperty_BA },
    { 0x2057,   0, cProperty_AL },
    { 0x2058,   3, cProperty_BA },
    { 0x205C,   0, cProperty_AL },
    { 0x205D,   2, cProperty_BA },
    { 0x2060,   0, cProperty_WJ },
    { 0x2061,   3, cProperty_AL },
    { 0x206A,   5, cProperty_CM },
    { 0x2070,   1, cProperty_AL },
    { 0x2074,   0, cProperty_AI },
    { 0x2075,   7, cProperty_AL },
    { 0x207D,   0, cProperty_OP },
    { 0x207E,   0, cProperty_CL },
    { 0x207F,   0, cProperty_AI },
    { 0x2080,   0, cProperty_AL },
    { 0x2081,   3, cProperty_AI },
    { 0x2085,   7, cProperty_AL },
    { 0x208D,   0, cProperty_OP },
    { 0x208E,   0, cProperty_CL },
    { 0x2090,  12, cProperty_AL },
    { 0x20A0,   6, cProperty_PR },
    { 0x20A7,   0, cProperty_PO },
    { 0x20A8,  13, cProperty_PR },
    { 0x20B6,   0, cProperty_PO },
    { 0x20B7,   3, cProperty_PR },
    { 0x20D0,  32, cProperty_CM },
    { 0x2100,   2, cProperty_AL },
    { 0x2103,   0, cProperty_PO },
    { 0x2104,   0, cProperty_AL },
    { 0x2105,   0, cProperty_AI },
    { 0x2106,   2, cProperty_AL },
    { 0x2109,   0, cProperty_PO },
    { 0x210A,   8, cProperty_AL },
    { 0x2113,   0, cProperty_AI },
    { 0x2114,   1, cProperty_AL },
    { 0x2116,   0, cProperty_PR },
    { 0x2117,   9, cProperty_AL },
    { 0x2121,   1, cProperty_AI },
    { 0x2123,   7, cProperty_AL },
    { 0x212B,   0, cProperty_AI },
    { 0x212C,  39, cProperty_AL },
    { 0x2154,   1, cProperty_AI },
    { 0x2156,   4, cProperty_AL },
    { 0x215B,   0, cProperty_AI },
    { 0x215C,   1, cProperty_AL },
    { 0x215E,   0, cProperty_AI },
    { 0x215F,   0, cProperty_AL },
    { 0x2160,  11, cProperty_AI },
    { 0x216C,   3, cProperty_AL },
    { 0x2170,   9, cProperty_AI },
    { 0x217A,  14, cProperty_AL },
    { 0x2189,   0, cProperty_AI },
    { 0x2190,   9, cProperty_AI },
    { 0x219A,  55, cProperty_AL },
    { 0x21D2,   0, cProperty_AI },
    { 0x21D3,   0, cProperty_AL },
    { 0x21D4,   0, cProperty_AI },
    { 0x21D5,  42, cProperty_AL },
    { 0x2200,   0, cProperty_AI },
    { 0x2201,   0, cProperty_AL },
    { 0x2202,   1, cProperty_AI },
    { 0x2204,   2, cProperty_AL },
    { 0x2207,   1, cProperty_AI },
    { 0x2209,   1, cProperty_AL },
    { 0x220B,   0, cProperty_AI },
    { 0x220C,   2, cProperty_AL },
    { 0x220F,   0, cProperty_AI },
    { 0x2210,   0, cProperty_AL },
    { 0x2211,   0, cProperty_AI },
    { 0x2212,   1, cProperty_PR },
    { 0x2214,   0, cProperty_AL },
    { 0x2215,   0, cProperty_AI },
    { 0x2216,   3, cProperty_AL },
    { 0x221A,   0, cProperty_AI },
    { 0x221B,   1, cProperty_AL },
    { 0x221D,   3, cProperty_AI },
    { 0x2221,   1, cProperty_AL },
    { 0x2223,   0, cProperty_AI },
    { 0x2224,   0, cProperty_AL },
    { 0x2225,   0, cProperty_AI },
    { 0x2226,   0, cProperty_AL },
    { 0x2227,   5, cProperty_AI },
    { 0x222D,   0, cProperty_AL },
    { 0x222E,   0, cProperty_AI },
    { 0x222F,   4, cProperty_AL },
    { 0x2234,   3, cProperty_AI },
    { 0x2238,   3, cProperty_AL },
    { 0x223C,   1, cProperty_AI },
    { 0x223E,   9, cProperty_AL },
    { 0x2248,   0, cProperty_AI },
    { 0x2249,   2, cProperty_AL },
    { 0x224C,   0, cProperty_AI },
    { 0x224D,   4, cProperty_AL },
    { 0x2252,   0, cProperty_AI },
    { 0x2253,  12, cProperty_AL },
    { 0x2260,   1, cProperty_AI },
    { 0x2262,   1, cProperty_AL },
    { 0x2264,   3, cProperty_AI },
    { 0x2268,   1, cProperty_AL },
    { 0x226A,   1, cProperty_AI },
    { 0x226C,   1, cProperty_AL },
    { 0x226E,   1, cProperty_AI },
    { 0x2270,  17, cProperty_AL },
    { 0x2282,   1, cProperty_AI },
    { 0x2284,   1, cProperty_AL },
    { 0x2286,   1, cProperty_AI },
    { 0x2288,  12, cProperty_AL },
    { 0x2295,   0, cProperty_AI },
    { 0x2296,   2, cProperty_AL },
    { 0x2299,   0, cProperty_AI },
    { 0x229A,  10, cProperty_AL },
    { 0x22A5,   0, cProperty_AI },
    { 0x22A6,  24, cProperty_AL },
    { 0x22BF,   0, cProperty_AI },
    { 0x22C0,  81, cProperty_AL },
    { 0x2312,   0, cProperty_AI },
    { 0x2313,   6, cProperty_AL },
    { 0x231C,  12, cProperty_AL },
    { 0x2329,   0, cProperty_OP },
    { 0x232A,   0, cProperty_CL },
    { 0x232B, 196, cProperty_AL },
    { 0x2400,  38, cProperty_AL },
    { 0x2440,  10, cProperty_AL },
    { 0x2460, 158, cProperty_AI },
    { 0x24FF,   0, cProperty_AL },
    { 0x2500,  75, cProperty_AI },
    { 0x254C,   3, cProperty_AL },
    { 0x2550,  36, cProperty_AI },
    { 0x2575,  10, cProperty_AL },
    { 0x2580,  15, cProperty_AI },
    { 0x2590,   1, cProperty_AL },
    { 0x2592,   3, cProperty_AI },
    { 0x2596,   9, cProperty_AL },
    { 0x25A0,   1, cProperty_AI },
    { 0x25A2,   0, cProperty_AL },
    { 0x25A3,   6, cProperty_AI },
    { 0x25AA,   7, cProperty_AL },
    { 0x25B2,   1, cProperty_AI },
    { 0x25B4,   1, cProperty_AL },
    { 0x25B6,   1, cProperty_AI },
    { 0x25B8,   3, cProperty_AL },
    { 0x25BC,   1, cProperty_AI },
    { 0x25BE,   1, cProperty_AL },
    { 0x25C0,   1, cProperty_AI },
    { 0x25C2,   3, cProperty_AL },
    { 0x25C6,   2, cProperty_AI },
    { 0x25C9,   1, cProperty_AL },
    { 0x25CB,   0, cProperty_AI },
    { 0x25CC,   1, cProperty_AL },
    { 0x25CE,   3, cProperty_AI },
    { 0x25D2,  15, cProperty_AL },
    { 0x25E2,   3, cProperty_AI },
    { 0x25E6,   8, cProperty_AL },
    { 0x25EF,   0, cProperty_AI },
    { 0x25F0,  15, cProperty_AL },
    { 0x2604,   0, cProperty_AL },
    { 0x2605,   1, cProperty_AI },
    { 0x2607,   1, cProperty_AL },
    { 0x2609,   0, cProperty_AI },
    { 0x260A,   3, cProperty_AL },
    { 0x260E,   1, cProperty_AI },
    { 0x2610,   3, cProperty_AL },
    { 0x2616,   1, cProperty_AI },
    { 0x2619,   0, cProperty_AL },
    { 0x2620,  24, cProperty_AL },
    { 0x263C,   3, cProperty_AL },
    { 0x2640,   0, cProperty_AI },
    { 0x2641,   0, cProperty_AL },
    { 0x2642,   0, cProperty_AI },
    { 0x2643,  28, cProperty_AL },
    { 0x2660,   1, cProperty_AI },
    { 0x2662,   0, cProperty_AL },
    { 0x2663,   2, cProperty_AI },
    { 0x2666,   0, cProperty_AL },
    { 0x2667,   0, cProperty_AI },
    { 0x2669,   1, cProperty_AI },
    { 0x266B,   0, cProperty_AL },
    { 0x266C,   1, cProperty_AI },
    { 0x266E,   0, cProperty_AL },
    { 0x266F,   0, cProperty_AI },
    { 0x2670,  14, cProperty_AL },
    { 0x2680,  29, cProperty_AL },
    { 0x269E,   1, cProperty_AI },
    { 0x26A0,  28, cProperty_AL },
    { 0x26C9,   3, cProperty_AI },
    { 0x26CE,   0, cProperty_AL },
    { 0x26D2,   0, cProperty_AI },
    { 0x26D5,   2, cProperty_AI },
    { 0x26DA,   1, cProperty_AI },
    { 0x26DD,   1, cProperty_AI },
    { 0x26E2,   0, cProperty_AL },
    { 0x26E3,   0, cProperty_AI },
    { 0x26E4,   3, cProperty_AL },
    { 0x26E8,   1, cProperty_AI },
    { 0x26EB,   5, cProperty_AI },
    { 0x26F6,   0, cProperty_AI },
    { 0x26FB,   1, cProperty_AI },
    { 0x2705,   2, cProperty_AL },
    { 0x270E,  72, cProperty_AL },
    { 0x2757,   0, cProperty_AI },
    { 0x2758,   2, cProperty_AL },
    { 0x275B,   3, cProperty_QU },
    { 0x275F,   2, cProperty_AL },
    { 0x2762,   1, cProperty_EX },
    { 0x2764,   3, cProperty_AL },
    { 0x2768,   0, cProperty_OP },
    { 0x2769,   0, cProperty_CL },
    { 0x276A,   0, cProperty_OP },
    { 0x276B,   0, cProperty_CL },
    { 0x276C,   0, cProperty_OP },
    { 0x276D,   0, cProperty_CL },
    { 0x276E,   0, cProperty_OP },
    { 0x276F,   0, cProperty_CL },
    { 0x2770,   0, cProperty_OP },
    { 0x2771,   0, cProperty_CL },
    { 0x2772,   0, cProperty_OP },
    { 0x2773,   0, cProperty_CL },
    { 0x2774,   0, cProperty_OP },
    { 0x2775,   0, cProperty_CL },
    { 0x2776,  29, cProperty_AI },
    { 0x2794,  48, cProperty_AL },
    { 0x27C5,   0, cProperty_OP },
    { 0x27C6,   0, cProperty_CL },
    { 0x27C7,  30, cProperty_AL },
    { 0x27E6,   0, cProperty_OP },
    { 0x27E7,   0, cProperty_CL },
    { 0x27E8,   0, cProperty_OP },
    { 0x27E9,   0, cProperty_CL },
    { 0x27EA,   0, cProperty_OP },
    { 0x27EB,   0, cProperty_CL },
    { 0x27EC,   0, cProperty_OP },
    { 0x27ED,   0, cProperty_CL },
    { 0x27EE,   0, cProperty_OP },
    { 0x27EF,   0, cProperty_CL },
    { 0x27F0, 255, cProperty_AL },
    { 0x28F0, 146, cProperty_AL },
    { 0x2983,   0, cProperty_OP },
    { 0x2984,   0, cProperty_CL },
    { 0x2985,   0, cProperty_OP },
    { 0x2986,   0, cProperty_CL },
    { 0x2987,   0, cProperty_OP },
    { 0x2988,   0, cProperty_CL },
    { 0x2989,   0, cProperty_OP },
    { 0x298A,   0, cProperty_CL },
    { 0x298B,   0, cProperty_OP },
    { 0x298C,   0, cProperty_CL },
    { 0x298D,   0, cProperty_OP },
    { 0x298E,   0, cProperty_CL },
    { 0x298F,   0, cProperty_OP },
    { 0x2990,   0, cProperty_CL },
    { 0x2991,   0, cProperty_OP },
    { 0x2992,   0, cProperty_CL },
    { 0x2993,   0, cProperty_OP },
    { 0x2994,   0, cProperty_CL },
    { 0x2995,   0, cProperty_OP },
    { 0x2996,   0, cProperty_CL },
    { 0x2997,   0, cProperty_OP },
    { 0x2998,   0, cProperty_CL },
    { 0x2999,  62, cProperty_AL },
    { 0x29D8,   0, cProperty_OP },
    { 0x29D9,   0, cProperty_CL },
    { 0x29DA,   0, cProperty_OP },
    { 0x29DB,   0, cProperty_CL },
    { 0x29DC,  31, cProperty_AL },
    { 0x29FC,   0, cProperty_OP },
    { 0x29FD,   0, cProperty_CL },
    { 0x29FE, 255, cProperty_AL },
    { 0x2AFE,  78, cProperty_AL },
    { 0x2B50,   4, cProperty_AL },
    { 0x2B55,   4, cProperty_AI },
    { 0x2C00,  46, cProperty_AL },
    { 0x2C30,  46, cProperty_AL },
    { 0x2C60, 142, cProperty_AL },
    { 0x2CEF,   2, cProperty_CM },
    { 0x2CF2,   1, cProperty_AL },
    { 0x2CF9,   0, cProperty_EX },
    { 0x2CFA,   2, cProperty_BA },
    { 0x2CFD,   0, cProperty_AL },
    { 0x2CFE,   0, cProperty_EX },
    { 0x2CFF,   0, cProperty_BA },
    { 0x2D00,  37, cProperty_AL },
    { 0x2D27,   0, cProperty_AL },
    { 0x2D2D,   0, cProperty_AL },
    { 0x2D30,  55, cProperty_AL },
    { 0x2D6F,   0, cProperty_AL },
    { 0x2D70,   0, cProperty_BA },
    { 0x2D7F,   0, cProperty_CM },
    { 0x2D80,  22, cProperty_AL },
    { 0x2DA0,   6, cProperty_AL },
    { 0x2DA8,   6, cProperty_AL },
    { 0x2DB0,   6, cProperty_AL },
    { 0x2DB8,   6, cProperty_AL },
    { 0x2DC0,   6, cProperty_AL },
    { 0x2DC8,   6, cProperty_AL },
    { 0x2DD0,   6, cProperty_AL },
    { 0x2DD8,   6, cProperty_AL },
    { 0x2DE0,  31, cProperty_CM },
    { 0x2E00,  13, cProperty_QU },
    { 0x2E0E,   7, cProperty_BA },
    { 0x2E16,   0, cProperty_AL },
    { 0x2E17,   0, cProperty_BA },
    { 0x2E18,   0, cProperty_OP },
    { 0x2E19,   0, cProperty_BA },
    { 0x2E1A,   1, cProperty_AL },
    { 0x2E1C,   1, cProperty_QU },
    { 0x2E1E,   1, cProperty_AL },
    { 0x2E20,   1, cProperty_QU },
    { 0x2E22,   0, cProperty_OP },
    { 0x2E23,   0, cProperty_CL },
    { 0x2E24,   0, cProperty_OP },
    { 0x2E25,   0, cProperty_CL },
    { 0x2E26,   0, cProperty_OP },
    { 0x2E27,   0, cProperty_CL },
    { 0x2E28,   0, cProperty_OP },
    { 0x2E29,   0, cProperty_CL },
    { 0x2E2A,   3, cProperty_BA },
    { 0x2E2E,   0, cProperty_EX },
    { 0x2E2F,   0, cProperty_AL },
    { 0x2E30,   1, cProperty_BA },
    { 0x2E32,   0, cProperty_AL },
    { 0x2E33,   1, cProperty_BA },
    { 0x2E35,   4, cProperty_AL },
    { 0x2E3A,   1, cProperty_B2 },
    { 0x3001,   1, cProperty_CL },
    { 0x3005,   0, cProperty_NS },
    { 0x3008,   0, cProperty_OP },
    { 0x3009,   0, cProperty_CL },
    { 0x300A,   0, cProperty_OP },
    { 0x300B,   0, cProperty_CL },
    { 0x300C,   0, cProperty_OP },
    { 0x300D,   0, cProperty_CL },
    { 0x300E,   0, cProperty_OP },
    { 0x300F,   0, cProperty_CL },
    { 0x3010,   0, cProperty_OP },
    { 0x3011,   0, cProperty_CL },
    { 0x3014,   0, cProperty_OP },
    { 0x3015,   0, cProperty_CL },
    { 0x3016,   0, cProperty_OP },
    { 0x3017,   0, cProperty_CL },
    { 0x3018,   0, cProperty_OP },
    { 0x3019,   0, cProperty_CL },
    { 0x301A,   0, cProperty_OP },
    { 0x301B,   0, cProperty_CL },
    { 0x301C,   0, cProperty_NS },
    { 0x301D,   0, cProperty_OP },
    { 0x301E,   1, cProperty_CL },
    { 0x302A,   5, cProperty_CM },
    { 0x303B,   1, cProperty_NS },
    { 0x3041,   0, cProperty_CJ },
    { 0x3043,   0, cProperty_CJ },
    { 0x3045,   0, cProperty_CJ },
    { 0x3047,   0, cProperty_CJ },
    { 0x3049,   0, cProperty_CJ },
    { 0x3063,   0, cProperty_CJ },
    { 0x3083,   0, cProperty_CJ },
    { 0x3085,   0, cProperty_CJ },
    { 0x3087,   0, cProperty_CJ },
    { 0x308E,   0, cProperty_CJ },
    { 0x3095,   1, cProperty_CJ },
    { 0x3099,   1, cProperty_CM },
    { 0x309B,   3, cProperty_NS },
    { 0x30A0,   0, cProperty_NS },
    { 0x30A1,   0, cProperty_CJ },
    { 0x30A3,   0, cProperty_CJ },
    { 0x30A5,   0, cProperty_CJ },
    { 0x30A7,   0, cProperty_CJ },
    { 0x30A9,   0, cProperty_CJ },
    { 0x30C3,   0, cProperty_CJ },
    { 0x30E3,   0, cProperty_CJ },
    { 0x30E5,   0, cProperty_CJ },
    { 0x30E7,   0, cProperty_CJ },
    { 0x30EE,   0, cProperty_CJ },
    { 0x30F5,   1, cProperty_CJ },
    { 0x30FB,   0, cProperty_NS },
    { 0x30FC,   0, cProperty_CJ },
    { 0x30FD,   1, cProperty_NS },
    { 0x31F0,  15, cProperty_CJ },
    { 0x3248,   7, cProperty_AI },
    { 0x4DC0,  63, cProperty_AL },
    { 0xA015,   0, cProperty_NS },
    { 0xA4D0,  45, cProperty_AL },
    { 0xA4FE,   1, cProperty_BA },
    { 0xA500, 255, cProperty_AL },
    { 0xA600,  12, cProperty_AL },
    { 0xA60D,   0, cProperty_BA },
    { 0xA60E,   0, cProperty_EX },
    { 0xA60F,   0, cProperty_BA },
    { 0xA610,  15, cProperty_AL },
    { 0xA620,   9, cProperty_NU },
    { 0xA62A,   1, cProperty_AL },
    { 0xA640,  46, cProperty_AL },
    { 0xA66F,   3, cProperty_CM },
    { 0xA673,   0, cProperty_AL },
    { 0xA674,   9, cProperty_CM },
    { 0xA67E,  25, cProperty_AL },
    { 0xA69F,   0, cProperty_CM },
    { 0xA6A0,  79, cProperty_AL },
    { 0xA6F0,   1, cProperty_CM },
    { 0xA6F2,   0, cProperty_AL },
    { 0xA6F3,   4, cProperty_BA },
    { 0xA700, 142, cProperty_AL },
    { 0xA790,   3, cProperty_AL },
    { 0xA7A0,  10, cProperty_AL },
    { 0xA7F8,   9, cProperty_AL },
    { 0xA802,   0, cProperty_CM },
    { 0xA803,   2, cProperty_AL },
    { 0xA806,   0, cProperty_CM },
    { 0xA807,   3, cProperty_AL },
    { 0xA80B,   0, cProperty_CM },
    { 0xA80C,  22, cProperty_AL },
    { 0xA823,   4, cProperty_CM },
    { 0xA828,   3, cProperty_AL },
    { 0xA830,   7, cProperty_AL },
    { 0xA838,   0, cProperty_PO },
    { 0xA839,   0, cProperty_AL },
    { 0xA840,  51, cProperty_AL },
    { 0xA874,   1, cProperty_BB },
    { 0xA876,   1, cProperty_EX },
    { 0xA880,   1, cProperty_CM },
    { 0xA882,  49, cProperty_AL },
    { 0xA8B4,  16, cProperty_CM },
    { 0xA8CE,   1, cProperty_BA },
    { 0xA8D0,   9, cProperty_NU },
    { 0xA8E0,  17, cProperty_CM },
    { 0xA8F2,   9, cProperty_AL },
    { 0xA900,   9, cProperty_NU },
    { 0xA90A,  27, cProperty_AL },
    { 0xA926,   7, cProperty_CM },
    { 0xA92E,   1, cProperty_BA },
    { 0xA930,  22, cProperty_AL },
    { 0xA947,  12, cProperty_CM },
    { 0xA95F,   0, cProperty_AL },
    { 0xA960,  28, cProperty_JL },
    { 0xA980,   3, cProperty_CM },
    { 0xA984,  46, cProperty_AL },
    { 0xA9B3,  13, cProperty_CM },
    { 0xA9C1,   5, cProperty_AL },
    { 0xA9C7,   2, cProperty_BA },
    { 0xA9CA,   3, cProperty_AL },
    { 0xA9CF,   0, cProperty_AL },
    { 0xA9D0,   9, cProperty_NU },
    { 0xA9DE,   1, cProperty_AL },
    { 0xAA00,  40, cProperty_AL },
    { 0xAA29,  13, cProperty_CM },
    { 0xAA40,   2, cProperty_AL },
    { 0xAA43,   0, cProperty_CM },
    { 0xAA44,   7, cProperty_AL },
    { 0xAA4C,   1, cProperty_CM },
    { 0xAA50,   9, cProperty_NU },
    { 0xAA5C,   0, cProperty_AL },
    { 0xAA5D,   2, cProperty_BA },
    { 0xAA60,  27, cProperty_SA },
    { 0xAA80,  66, cProperty_SA },
    { 0xAADB,   4, cProperty_SA },
    { 0xAAE0,  10, cProperty_AL },
    { 0xAAEB,   4, cProperty_CM },
    { 0xAAF0,   1, cProperty_BA },
    { 0xAAF2,   2, cProperty_AL },
    { 0xAAF5,   1, cProperty_CM },
    { 0xAB01,   5, cProperty_AL },
    { 0xAB09,   5, cProperty_AL },
    { 0xAB11,   5, cProperty_AL },
    { 0xAB20,   6, cProperty_AL },
    { 0xAB28,   6, cProperty_AL },
    { 0xABC0,  34, cProperty_AL },
    { 0xABE3,   7, cProperty_CM },
    { 0xABEB,   0, cProperty_BA },
    { 0xABEC,   1, cProperty_CM },
    { 0xABF0,   9, cProperty_NU },
    { 0xAC00,   0, cProperty_H2 },
    { 0xAC01,  25, cProperty_H3 },
    { 0xAC1C,   0, cProperty_H2 },
    { 0xAC1D,  25, cProperty_H3 },
    { 0xAC38,   0, cProperty_H2 },
    { 0xAC39,  25, cProperty_H3 },
    { 0xAC54,   0, cProperty_H2 },
    { 0xAC55,  25, cProperty_H3 },
    { 0xAC70,   0, cProperty_H2 },
    { 0xAC71,  25, cProperty_H3 },
    { 0xAC8C,   0, cProperty_H2 },
    { 0xAC8D,  25, cProperty_H3 },
    { 0xACA8,   0, cProperty_H2 },
    { 0xACA9,  25, cProperty_H3 },
    { 0xACC4,   0, cProperty_H2 },
    { 0xACC5,  25, cProperty_H3 },
    { 0xACE0,   0, cProperty_H2 },
    { 0xACE1,  25, cProperty_H3 },
    { 0xACFC,   0, cProperty_H2 },
    { 0xACFD,  25, cProperty_H3 },
    { 0xAD18,   0, cProperty_H2 },
    { 0xAD19,  25, cProperty_H3 },
    { 0xAD34,   0, cProperty_H2 },
    { 0xAD35,  25, cProperty_H3 },
    { 0xAD50,   0, cProperty_H2 },
    { 0xAD51,  25, cProperty_H3 },
    { 0xAD6C,   0, cProperty_H2 },
    { 0xAD6D,  25, cProperty_H3 },
    { 0xAD88,   0, cProperty_H2 },
    { 0xAD89,  25, cProperty_H3 },
    { 0xADA4,   0, cProperty_H2 },
    { 0xADA5,  25, cProperty_H3 },
    { 0xADC0,   0, cProperty_H2 },
    { 0xADC1,  25, cProperty_H3 },
    { 0xADDC,   0, cProperty_H2 },
    { 0xADDD,  25, cProperty_H3 },
    { 0xADF8,   0, cProperty_H2 },
    { 0xADF9,  25, cProperty_H3 },
    { 0xAE14,   0, cProperty_H2 },
    { 0xAE15,  25, cProperty_H3 },
    { 0xAE30,   0, cProperty_H2 },
    { 0xAE31,  25, cProperty_H3 },
    { 0xAE4C,   0, cProperty_H2 },
    { 0xAE4D,  25, cProperty_H3 },
    { 0xAE68,   0, cProperty_H2 },
    { 0xAE69,  25, cProperty_H3 },
    { 0xAE84,   0, cProperty_H2 },
    { 0xAE85,  25, cProperty_H3 },
    { 0xAEA0,   0, cProperty_H2 },
    { 0xAEA1,  25, cProperty_H3 },
    { 0xAEBC,   0, cProperty_H2 },
    { 0xAEBD,  25, cProperty_H3 },
    { 0xAED8,   0, cProperty_H2 },
    { 0xAED9,  25, cProperty_H3 },
    { 0xAEF4,   0, cProperty_H2 },
    { 0xAEF5,  25, cProperty_H3 },
    { 0xAF10,   0, cProperty_H2 },
    { 0xAF11,  25, cProperty_H3 },
    { 0xAF2C,   0, cProperty_H2 },
    { 0xAF2D,  25, cProperty_H3 },
    { 0xAF48,   0, cProperty_H2 },
    { 0xAF49,  25, cProperty_H3 },
    { 0xAF64,   0, cProperty_H2 },
    { 0xAF65,  25, cProperty_H3 },
    { 0xAF80,   0, cProperty_H2 },
    { 0xAF81,  25, cProperty_H3 },
    { 0xAF9C,   0, cProperty_H2 },
    { 0xAF9D,  25, cProperty_H3 },
    { 0xAFB8,   0, cProperty_H2 },
    { 0xAFB9,  25, cProperty_H3 },
    { 0xAFD4,   0, cProperty_H2 },
    { 0xAFD5,  25, cProperty_H3 },
    { 0xAFF0,   0, cProperty_H2 },
    { 0xAFF1,  25, cProperty_H3 },
    { 0xB00C,   0, cProperty_H2 },
    { 0xB00D,  25, cProperty_H3 },
    { 0xB028,   0, cProperty_H2 },
    { 0xB029,  25, cProperty_H3 },
    { 0xB044,   0, cProperty_H2 },
    { 0xB045,  25, cProperty_H3 },
    { 0xB060,   0, cProperty_H2 },
    { 0xB061,  25, cProperty_H3 },
    { 0xB07C,   0, cProperty_H2 },
    { 0xB07D,  25, cProperty_H3 },
    { 0xB098,   0, cProperty_H2 },
    { 0xB099,  25, cProperty_H3 },
    { 0xB0B4,   0, cProperty_H2 },
    { 0xB0B5,  25, cProperty_H3 },
    { 0xB0D0,   0, cProperty_H2 },
    { 0xB0D1,  25, cProperty_H3 },
    { 0xB0EC,   0, cProperty_H2 },
    { 0xB0ED,  25, cProperty_H3 },
    { 0xB108,   0, cProperty_H2 },
    { 0xB109,  25, cProperty_H3 },
    { 0xB124,   0, cProperty_H2 },
    { 0xB125,  25, cProperty_H3 },
    { 0xB140,   0, cProperty_H2 },
    { 0xB141,  25, cProperty_H3 },
    { 0xB15C,   0, cProperty_H2 },
    { 0xB15D,  25, cProperty_H3 },
    { 0xB178,   0, cProperty_H2 },
    { 0xB179,  25, cProperty_H3 },
    { 0xB194,   0, cProperty_H2 },
    { 0xB195,  25, cProperty_H3 },
    { 0xB1B0,   0, cProperty_H2 },
    { 0xB1B1,  25, cProperty_H3 },
    { 0xB1CC,   0, cProperty_H2 },
    { 0xB1CD,  25, cProperty_H3 },
    { 0xB1E8,   0, cProperty_H2 },
    { 0xB1E9,  25, cProperty_H3 },
    { 0xB204,   0, cProperty_H2 },
    { 0xB205,  25, cProperty_H3 },
    { 0xB220,   0, cProperty_H2 },
    { 0xB221,  25, cProperty_H3 },
    { 0xB23C,   0, cProperty_H2 },
    { 0xB23D,  25, cProperty_H3 },
    { 0xB258,   0, cProperty_H2 },
    { 0xB259,  25, cProperty_H3 },
    { 0xB274,   0, cProperty_H2 },
    { 0xB275,  25, cProperty_H3 },
    { 0xB290,   0, cProperty_H2 },
    { 0xB291,  25, cProperty_H3 },
    { 0xB2AC,   0, cProperty_H2 },
    { 0xB2AD,  25, cProperty_H3 },
    { 0xB2C8,   0, cProperty_H2 },
    { 0xB2C9,  25, cProperty_H3 },
    { 0xB2E4,   0, cProperty_H2 },
    { 0xB2E5,  25, cProperty_H3 },
    { 0xB300,   0, cProperty_H2 },
    { 0xB301,  25, cProperty_H3 },
    { 0xB31C,   0, cProperty_H2 },
    { 0xB31D,  25, cProperty_H3 },
    { 0xB338,   0, cProperty_H2 },
    { 0xB339,  25, cProperty_H3 },
    { 0xB354,   0, cProperty_H2 },
    { 0xB355,  25, cProperty_H3 },
    { 0xB370,   0, cProperty_H2 },
    { 0xB371,  25, cProperty_H3 },
    { 0xB38C,   0, cProperty_H2 },
    { 0xB38D,  25, cProperty_H3 },
    { 0xB3A8,   0, cProperty_H2 },
    { 0xB3A9,  25, cProperty_H3 },
    { 0xB3C4,   0, cProperty_H2 },
    { 0xB3C5,  25, cProperty_H3 },
    { 0xB3E0,   0, cProperty_H2 },
    { 0xB3E1,  25, cProperty_H3 },
    { 0xB3FC,   0, cProperty_H2 },
    { 0xB3FD,  25, cProperty_H3 },
    { 0xB418,   0, cProperty_H2 },
    { 0xB419,  25, cProperty_H3 },
    { 0xB434,   0, cProperty_H2 },
    { 0xB435,  25, cProperty_H3 },
    { 0xB450,   0, cProperty_H2 },
    { 0xB451,  25, cProperty_H3 },
    { 0xB46C,   0, cProperty_H2 },
    { 0xB46D,  25, cProperty_H3 },
    { 0xB488,   0, cProperty_H2 },
    { 0xB489,  25, cProperty_H3 },
    { 0xB4A4,   0, cProperty_H2 },
    { 0xB4A5,  25, cProperty_H3 },
    { 0xB4C0,   0, cProperty_H2 },
    { 0xB4C1,  25, cProperty_H3 },
    { 0xB4DC,   0, cProperty_H2 },
    { 0xB4DD,  25, cProperty_H3 },
    { 0xB4F8,   0, cProperty_H2 },
    { 0xB4F9,  25, cProperty_H3 },
    { 0xB514,   0, cProperty_H2 },
    { 0xB515,  25, cProperty_H3 },
    { 0xB530,   0, cProperty_H2 },
    { 0xB531,  25, cProperty_H3 },
    { 0xB54C,   0, cProperty_H2 },
    { 0xB54D,  25, cProperty_H3 },
    { 0xB568,   0, cProperty_H2 },
    { 0xB569,  25, cProperty_H3 },
    { 0xB584,   0, cProperty_H2 },
    { 0xB585,  25, cProperty_H3 },
    { 0xB5A0,   0, cProperty_H2 },
    { 0xB5A1,  25, cProperty_H3 },
    { 0xB5BC,   0, cProperty_H2 },
    { 0xB5BD,  25, cProperty_H3 },
    { 0xB5D8,   0, cProperty_H2 },
    { 0xB5D9,  25, cProperty_H3 },
    { 0xB5F4,   0, cProperty_H2 },
    { 0xB5F5,  25, cProperty_H3 },
    { 0xB610,   0, cProperty_H2 },
    { 0xB611,  25, cProperty_H3 },
    { 0xB62C,   0, cProperty_H2 },
    { 0xB62D,  25, cProperty_H3 },
    { 0xB648,   0, cProperty_H2 },
    { 0xB649,  25, cProperty_H3 },
    { 0xB664,   0, cProperty_H2 },
    { 0xB665,  25, cProperty_H3 },
    { 0xB680,   0, cProperty_H2 },
    { 0xB681,  25, cProperty_H3 },
    { 0xB69C,   0, cProperty_H2 },
    { 0xB69D,  25, cProperty_H3 },
    { 0xB6B8,   0, cProperty_H2 },
    { 0xB6B9,  25, cProperty_H3 },
    { 0xB6D4,   0, cProperty_H2 },
    { 0xB6D5,  25, cProperty_H3 },
    { 0xB6F0,   0, cProperty_H2 },
    { 0xB6F1,  25, cProperty_H3 },
    { 0xB70C,   0, cProperty_H2 },
    { 0xB70D,  25, cProperty_H3 },
    { 0xB728,   0, cProperty_H2 },
    { 0xB729,  25, cProperty_H3 },
    { 0xB744,   0, cProperty_H2 },
    { 0xB745,  25, cProperty_H3 },
    { 0xB760,   0, cProperty_H2 },
    { 0xB761,  25, cProperty_H3 },
    { 0xB77C,   0, cProperty_H2 },
    { 0xB77D,  25, cProperty_H3 },
    { 0xB798,   0, cProperty_H2 },
    { 0xB799,  25, cProperty_H3 },
    { 0xB7B4,   0, cProperty_H2 },
    { 0xB7B5,  25, cProperty_H3 },
    { 0xB7D0,   0, cProperty_H2 },
    { 0xB7D1,  25, cProperty_H3 },
    { 0xB7EC,   0, cProperty_H2 },
    { 0xB7ED,  25, cProperty_H3 },
    { 0xB808,   0, cProperty_H2 },
    { 0xB809,  25, cProperty_H3 },
    { 0xB824,   0, cProperty_H2 },
    { 0xB825,  25, cProperty_H3 },
    { 0xB840,   0, cProperty_H2 },
    { 0xB841,  25, cProperty_H3 },
    { 0xB85C,   0, cProperty_H2 },
    { 0xB85D,  25, cProperty_H3 },
    { 0xB878,   0, cProperty_H2 },
    { 0xB879,  25, cProperty_H3 },
    { 0xB894,   0, cProperty_H2 },
    { 0xB895,  25, cProperty_H3 },
    { 0xB8B0,   0, cProperty_H2 },
    { 0xB8B1,  25, cProperty_H3 },
    { 0xB8CC,   0, cProperty_H2 },
    { 0xB8CD,  25, cProperty_H3 },
    { 0xB8E8,   0, cProperty_H2 },
    { 0xB8E9,  25, cProperty_H3 },
    { 0xB904,   0, cProperty_H2 },
    { 0xB905,  25, cProperty_H3 },
    { 0xB920,   0, cProperty_H2 },
    { 0xB921,  25, cProperty_H3 },
    { 0xB93C,   0, cProperty_H2 },
    { 0xB93D,  25, cProperty_H3 },
    { 0xB958,   0, cProperty_H2 },
    { 0xB959,  25, cProperty_H3 },
    { 0xB974,   0, cProperty_H2 },
    { 0xB975,  25, cProperty_H3 },
    { 0xB990,   0, cProperty_H2 },
    { 0xB991,  25, cProperty_H3 },
    { 0xB9AC,   0, cProperty_H2 },
    { 0xB9AD,  25, cProperty_H3 },
    { 0xB9C8,   0, cProperty_H2 },
    { 0xB9C9,  25, cProperty_H3 },
    { 0xB9E4,   0, cProperty_H2 },
    { 0xB9E5,  25, cProperty_H3 },
    { 0xBA00,   0, cProperty_H2 },
    { 0xBA01,  25, cProperty_H3 },
    { 0xBA1C,   0, cProperty_H2 },
    { 0xBA1D,  25, cProperty_H3 },
    { 0xBA38,   0, cProperty_H2 },
    { 0xBA39,  25, cProperty_H3 },
    { 0xBA54,   0, cProperty_H2 },
    { 0xBA55,  25, cProperty_H3 },
    { 0xBA70,   0, cProperty_H2 },
    { 0xBA71,  25, cProperty_H3 },
    { 0xBA8C,   0, cProperty_H2 },
    { 0xBA8D,  25, cProperty_H3 },
    { 0xBAA8,   0, cProperty_H2 },
    { 0xBAA9,  25, cProperty_H3 },
    { 0xBAC4,   0, cProperty_H2 },
    { 0xBAC5,  25, cProperty_H3 },
    { 0xBAE0,   0, cProperty_H2 },
    { 0xBAE1,  25, cProperty_H3 },
    { 0xBAFC,   0, cProperty_H2 },
    { 0xBAFD,  25, cProperty_H3 },
    { 0xBB18,   0, cProperty_H2 },
    { 0xBB19,  25, cProperty_H3 },
    { 0xBB34,   0, cProperty_H2 },
    { 0xBB35,  25, cProperty_H3 },
    { 0xBB50,   0, cProperty_H2 },
    { 0xBB51,  25, cProperty_H3 },
    { 0xBB6C,   0, cProperty_H2 },
    { 0xBB6D,  25, cProperty_H3 },
    { 0xBB88,   0, cProperty_H2 },
    { 0xBB89,  25, cProperty_H3 },
    { 0xBBA4,   0, cProperty_H2 },
    { 0xBBA5,  25, cProperty_H3 },
    { 0xBBC0,   0, cProperty_H2 },
    { 0xBBC1,  25, cProperty_H3 },
    { 0xBBDC,   0, cProperty_H2 },
    { 0xBBDD,  25, cProperty_H3 },
    { 0xBBF8,   0, cProperty_H2 },
    { 0xBBF9,  25, cProperty_H3 },
    { 0xBC14,   0, cProperty_H2 },
    { 0xBC15,  25, cProperty_H3 },
    { 0xBC30,   0, cProperty_H2 },
    { 0xBC31,  25, cProperty_H3 },
    { 0xBC4C,   0, cProperty_H2 },
    { 0xBC4D,  25, cProperty_H3 },
    { 0xBC68,   0, cProperty_H2 },
    { 0xBC69,  25, cProperty_H3 },
    { 0xBC84,   0, cProperty_H2 },
    { 0xBC85,  25, cProperty_H3 },
    { 0xBCA0,   0, cProperty_H2 },
    { 0xBCA1,  25, cProperty_H3 },
    { 0xBCBC,   0, cProperty_H2 },
    { 0xBCBD,  25, cProperty_H3 },
    { 0xBCD8,   0, cProperty_H2 },
    { 0xBCD9,  25, cProperty_H3 },
    { 0xBCF4,   0, cProperty_H2 },
    { 0xBCF5,  25, cProperty_H3 },
    { 0xBD10,   0, cProperty_H2 },
    { 0xBD11,  25, cProperty_H3 },
    { 0xBD2C,   0, cProperty_H2 },
    { 0xBD2D,  25, cProperty_H3 },
    { 0xBD48,   0, cProperty_H2 },
    { 0xBD49,  25, cProperty_H3 },
    { 0xBD64,   0, cProperty_H2 },
    { 0xBD65,  25, cProperty_H3 },
    { 0xBD80,   0, cProperty_H2 },
    { 0xBD81,  25, cProperty_H3 },
    { 0xBD9C,   0, cProperty_H2 },
    { 0xBD9D,  25, cProperty_H3 },
    { 0xBDB8,   0, cProperty_H2 },
    { 0xBDB9,  25, cProperty_H3 },
    { 0xBDD4,   0, cProperty_H2 },
    { 0xBDD5,  25, cProperty_H3 },
    { 0xBDF0,   0, cProperty_H2 },
    { 0xBDF1,  25, cProperty_H3 },
    { 0xBE0C,   0, cProperty_H2 },
    { 0xBE0D,  25, cProperty_H3 },
    { 0xBE28,   0, cProperty_H2 },
    { 0xBE29,  25, cProperty_H3 },
    { 0xBE44,   0, cProperty_H2 },
    { 0xBE45,  25, cProperty_H3 },
    { 0xBE60,   0, cProperty_H2 },
    { 0xBE61,  25, cProperty_H3 },
    { 0xBE7C,   0, cProperty_H2 },
    { 0xBE7D,  25, cProperty_H3 },
    { 0xBE98,   0, cProperty_H2 },
    { 0xBE99,  25, cProperty_H3 },
    { 0xBEB4,   0, cProperty_H2 },
    { 0xBEB5,  25, cProperty_H3 },
    { 0xBED0,   0, cProperty_H2 },
    { 0xBED1,  25, cProperty_H3 },
    { 0xBEEC,   0, cProperty_H2 },
    { 0xBEED,  25, cProperty_H3 },
    { 0xBF08,   0, cProperty_H2 },
    { 0xBF09,  25, cProperty_H3 },
    { 0xBF24,   0, cProperty_H2 },
    { 0xBF25,  25, cProperty_H3 },
    { 0xBF40,   0, cProperty_H2 },
    { 0xBF41,  25, cProperty_H3 },
    { 0xBF5C,   0, cProperty_H2 },
    { 0xBF5D,  25, cProperty_H3 },
    { 0xBF78,   0, cProperty_H2 },
    { 0xBF79,  25, cProperty_H3 },
    { 0xBF94,   0, cProperty_H2 },
    { 0xBF95,  25, cProperty_H3 },
    { 0xBFB0,   0, cProperty_H2 },
    { 0xBFB1,  25, cProperty_H3 },
    { 0xBFCC,   0, cProperty_H2 },
    { 0xBFCD,  25, cProperty_H3 },
    { 0xBFE8,   0, cProperty_H2 },
    { 0xBFE9,  25, cProperty_H3 },
    { 0xC004,   0, cProperty_H2 },
    { 0xC005,  25, cProperty_H3 },
    { 0xC020,   0, cProperty_H2 },
    { 0xC021,  25, cProperty_H3 },
    { 0xC03C,   0, cProperty_H2 },
    { 0xC03D,  25, cProperty_H3 },
    { 0xC058,   0, cProperty_H2 },
    { 0xC059,  25, cProperty_H3 },
    { 0xC074,   0, cProperty_H2 },
    { 0xC075,  25, cProperty_H3 },
    { 0xC090,   0, cProperty_H2 },
    { 0xC091,  25, cProperty_H3 },
    { 0xC0AC,   0, cProperty_H2 },
    { 0xC0AD,  25, cProperty_H3 },
    { 0xC0C8,   0, cProperty_H2 },
    { 0xC0C9,  25, cProperty_H3 },
    { 0xC0E4,   0, cProperty_H2 },
    { 0xC0E5,  25, cProperty_H3 },
    { 0xC100,   0, cProperty_H2 },
    { 0xC101,  25, cProperty_H3 },
    { 0xC11C,   0, cProperty_H2 },
    { 0xC11D,  25, cProperty_H3 },
    { 0xC138,   0, cProperty_H2 },
    { 0xC139,  25, cProperty_H3 },
    { 0xC154,   0, cProperty_H2 },
    { 0xC155,  25, cProperty_H3 },
    { 0xC170,   0, cProperty_H2 },
    { 0xC171,  25, cProperty_H3 },
    { 0xC18C,   0, cProperty_H2 },
    { 0xC18D,  25, cProperty_H3 },
    { 0xC1A8,   0, cProperty_H2 },
    { 0xC1A9,  25, cProperty_H3 },
    { 0xC1C4,   0, cProperty_H2 },
    { 0xC1C5,  25, cProperty_H3 },
    { 0xC1E0,   0, cProperty_H2 },
    { 0xC1E1,  25, cProperty_H3 },
    { 0xC1FC,   0, cProperty_H2 },
    { 0xC1FD,  25, cProperty_H3 },
    { 0xC218,   0, cProperty_H2 },
    { 0xC219,  25, cProperty_H3 },
    { 0xC234,   0, cProperty_H2 },
    { 0xC235,  25, cProperty_H3 },
    { 0xC250,   0, cProperty_H2 },
    { 0xC251,  25, cProperty_H3 },
    { 0xC26C,   0, cProperty_H2 },
    { 0xC26D,  25, cProperty_H3 },
    { 0xC288,   0, cProperty_H2 },
    { 0xC289,  25, cProperty_H3 },
    { 0xC2A4,   0, cProperty_H2 },
    { 0xC2A5,  25, cProperty_H3 },
    { 0xC2C0,   0, cProperty_H2 },
    { 0xC2C1,  25, cProperty_H3 },
    { 0xC2DC,   0, cProperty_H2 },
    { 0xC2DD,  25, cProperty_H3 },
    { 0xC2F8,   0, cProperty_H2 },
    { 0xC2F9,  25, cProperty_H3 },
    { 0xC314,   0, cProperty_H2 },
    { 0xC315,  25, cProperty_H3 },
    { 0xC330,   0, cProperty_H2 },
    { 0xC331,  25, cProperty_H3 },
    { 0xC34C,   0, cProperty_H2 },
    { 0xC34D,  25, cProperty_H3 },
    { 0xC368,   0, cProperty_H2 },
    { 0xC369,  25, cProperty_H3 },
    { 0xC384,   0, cProperty_H2 },
    { 0xC385,  25, cProperty_H3 },
    { 0xC3A0,   0, cProperty_H2 },
    { 0xC3A1,  25, cProperty_H3 },
    { 0xC3BC,   0, cProperty_H2 },
    { 0xC3BD,  25, cProperty_H3 },
    { 0xC3D8,   0, cProperty_H2 },
    { 0xC3D9,  25, cProperty_H3 },
    { 0xC3F4,   0, cProperty_H2 },
    { 0xC3F5,  25, cProperty_H3 },
    { 0xC410,   0, cProperty_H2 },
    { 0xC411,  25, cProperty_H3 },
    { 0xC42C,   0, cProperty_H2 },
    { 0xC42D,  25, cProperty_H3 },
    { 0xC448,   0, cProperty_H2 },
    { 0xC449,  25, cProperty_H3 },
    { 0xC464,   0, cProperty_H2 },
    { 0xC465,  25, cProperty_H3 },
    { 0xC480,   0, cProperty_H2 },
    { 0xC481,  25, cProperty_H3 },
    { 0xC49C,   0, cProperty_H2 },
    { 0xC49D,  25, cProperty_H3 },
    { 0xC4B8,   0, cProperty_H2 },
    { 0xC4B9,  25, cProperty_H3 },
    { 0xC4D4,   0, cProperty_H2 },
    { 0xC4D5,  25, cProperty_H3 },
    { 0xC4F0,   0, cProperty_H2 },
    { 0xC4F1,  25, cProperty_H3 },
    { 0xC50C,   0, cProperty_H2 },
    { 0xC50D,  25, cProperty_H3 },
    { 0xC528,   0, cProperty_H2 },
    { 0xC529,  25, cProperty_H3 },
    { 0xC544,   0, cProperty_H2 },
    { 0xC545,  25, cProperty_H3 },
    { 0xC560,   0, cProperty_H2 },
    { 0xC561,  25, cProperty_H3 },
    { 0xC57C,   0, cProperty_H2 },
    { 0xC57D,  25, cProperty_H3 },
    { 0xC598,   0, cProperty_H2 },
    { 0xC599,  25, cProperty_H3 },
    { 0xC5B4,   0, cProperty_H2 },
    { 0xC5B5,  25, cProperty_H3 },
    { 0xC5D0,   0, cProperty_H2 },
    { 0xC5D1,  25, cProperty_H3 },
    { 0xC5EC,   0, cProperty_H2 },
    { 0xC5ED,  25, cProperty_H3 },
    { 0xC608,   0, cProperty_H2 },
    { 0xC609,  25, cProperty_H3 },
    { 0xC624,   0, cProperty_H2 },
    { 0xC625,  25, cProperty_H3 },
    { 0xC640,   0, cProperty_H2 },
    { 0xC641,  25, cProperty_H3 },
    { 0xC65C,   0, cProperty_H2 },
    { 0xC65D,  25, cProperty_H3 },
    { 0xC678,   0, cProperty_H2 },
    { 0xC679,  25, cProperty_H3 },
    { 0xC694,   0, cProperty_H2 },
    { 0xC695,  25, cProperty_H3 },
    { 0xC6B0,   0, cProperty_H2 },
    { 0xC6B1,  25, cProperty_H3 },
    { 0xC6CC,   0, cProperty_H2 },
    { 0xC6CD,  25, cProperty_H3 },
    { 0xC6E8,   0, cProperty_H2 },
    { 0xC6E9,  25, cProperty_H3 },
    { 0xC704,   0, cProperty_H2 },
    { 0xC705,  25, cProperty_H3 },
    { 0xC720,   0, cProperty_H2 },
    { 0xC721,  25, cProperty_H3 },
    { 0xC73C,   0, cProperty_H2 },
    { 0xC73D,  25, cProperty_H3 },
    { 0xC758,   0, cProperty_H2 },
    { 0xC759,  25, cProperty_H3 },
    { 0xC774,   0, cProperty_H2 },
    { 0xC775,  25, cProperty_H3 },
    { 0xC790,   0, cProperty_H2 },
    { 0xC791,  25, cProperty_H3 },
    { 0xC7AC,   0, cProperty_H2 },
    { 0xC7AD,  25, cProperty_H3 },
    { 0xC7C8,   0, cProperty_H2 },
    { 0xC7C9,  25, cProperty_H3 },
    { 0xC7E4,   0, cProperty_H2 },
    { 0xC7E5,  25, cProperty_H3 },
    { 0xC800,   0, cProperty_H2 },
    { 0xC801,  25, cProperty_H3 },
    { 0xC81C,   0, cProperty_H2 },
    { 0xC81D,  25, cProperty_H3 },
    { 0xC838,   0, cProperty_H2 },
    { 0xC839,  25, cProperty_H3 },
    { 0xC854,   0, cProperty_H2 },
    { 0xC855,  25, cProperty_H3 },
    { 0xC870,   0, cProperty_H2 },
    { 0xC871,  25, cProperty_H3 },
    { 0xC88C,   0, cProperty_H2 },
    { 0xC88D,  25, cProperty_H3 },
    { 0xC8A8,   0, cProperty_H2 },
    { 0xC8A9,  25, cProperty_H3 },
    { 0xC8C4,   0, cProperty_H2 },
    { 0xC8C5,  25, cProperty_H3 },
    { 0xC8E0,   0, cProperty_H2 },
    { 0xC8E1,  25, cProperty_H3 },
    { 0xC8FC,   0, cProperty_H2 },
    { 0xC8FD,  25, cProperty_H3 },
    { 0xC918,   0, cProperty_H2 },
    { 0xC919,  25, cProperty_H3 },
    { 0xC934,   0, cProperty_H2 },
    { 0xC935,  25, cProperty_H3 },
    { 0xC950,   0, cProperty_H2 },
    { 0xC951,  25, cProperty_H3 },
    { 0xC96C,   0, cProperty_H2 },
    { 0xC96D,  25, cProperty_H3 },
    { 0xC988,   0, cProperty_H2 },
    { 0xC989,  25, cProperty_H3 },
    { 0xC9A4,   0, cProperty_H2 },
    { 0xC9A5,  25, cProperty_H3 },
    { 0xC9C0,   0, cProperty_H2 },
    { 0xC9C1,  25, cProperty_H3 },
    { 0xC9DC,   0, cProperty_H2 },
    { 0xC9DD,  25, cProperty_H3 },
    { 0xC9F8,   0, cProperty_H2 },
    { 0xC9F9,  25, cProperty_H3 },
    { 0xCA14,   0, cProperty_H2 },
    { 0xCA15,  25, cProperty_H3 },
    { 0xCA30,   0, cProperty_H2 },
    { 0xCA31,  25, cProperty_H3 },
    { 0xCA4C,   0, cProperty_H2 },
    { 0xCA4D,  25, cProperty_H3 },
    { 0xCA68,   0, cProperty_H2 },
    { 0xCA69,  25, cProperty_H3 },
    { 0xCA84,   0, cProperty_H2 },
    { 0xCA85,  25, cProperty_H3 },
    { 0xCAA0,   0, cProperty_H2 },
    { 0xCAA1,  25, cProperty_H3 },
    { 0xCABC,   0, cProperty_H2 },
    { 0xCABD,  25, cProperty_H3 },
    { 0xCAD8,   0, cProperty_H2 },
    { 0xCAD9,  25, cProperty_H3 },
    { 0xCAF4,   0, cProperty_H2 },
    { 0xCAF5,  25, cProperty_H3 },
    { 0xCB10,   0, cProperty_H2 },
    { 0xCB11,  25, cProperty_H3 },
    { 0xCB2C,   0, cProperty_H2 },
    { 0xCB2D,  25, cProperty_H3 },
    { 0xCB48,   0, cProperty_H2 },
    { 0xCB49,  25, cProperty_H3 },
    { 0xCB64,   0, cProperty_H2 },
    { 0xCB65,  25, cProperty_H3 },
    { 0xCB80,   0, cProperty_H2 },
    { 0xCB81,  25, cProperty_H3 },
    { 0xCB9C,   0, cProperty_H2 },
    { 0xCB9D,  25, cProperty_H3 },
    { 0xCBB8,   0, cProperty_H2 },
    { 0xCBB9,  25, cProperty_H3 },
    { 0xCBD4,   0, cProperty_H2 },
    { 0xCBD5,  25, cProperty_H3 },
    { 0xCBF0,   0, cProperty_H2 },
    { 0xCBF1,  25, cProperty_H3 },
    { 0xCC0C,   0, cProperty_H2 },
    { 0xCC0D,  25, cProperty_H3 },
    { 0xCC28,   0, cProperty_H2 },
    { 0xCC29,  25, cProperty_H3 },
    { 0xCC44,   0, cProperty_H2 },
    { 0xCC45,  25, cProperty_H3 },
    { 0xCC60,   0, cProperty_H2 },
    { 0xCC61,  25, cProperty_H3 },
    { 0xCC7C,   0, cProperty_H2 },
    { 0xCC7D,  25, cProperty_H3 },
    { 0xCC98,   0, cProperty_H2 },
    { 0xCC99,  25, cProperty_H3 },
    { 0xCCB4,   0, cProperty_H2 },
    { 0xCCB5,  25, cProperty_H3 },
    { 0xCCD0,   0, cProperty_H2 },
    { 0xCCD1,  25, cProperty_H3 },
    { 0xCCEC,   0, cProperty_H2 },
    { 0xCCED,  25, cProperty_H3 },
    { 0xCD08,   0, cProperty_H2 },
    { 0xCD09,  25, cProperty_H3 },
    { 0xCD24,   0, cProperty_H2 },
    { 0xCD25,  25, cProperty_H3 },
    { 0xCD40,   0, cProperty_H2 },
    { 0xCD41,  25, cProperty_H3 },
    { 0xCD5C,   0, cProperty_H2 },
    { 0xCD5D,  25, cProperty_H3 },
    { 0xCD78,   0, cProperty_H2 },
    { 0xCD79,  25, cProperty_H3 },
    { 0xCD94,   0, cProperty_H2 },
    { 0xCD95,  25, cProperty_H3 },
    { 0xCDB0,   0, cProperty_H2 },
    { 0xCDB1,  25, cProperty_H3 },
    { 0xCDCC,   0, cProperty_H2 },
    { 0xCDCD,  25, cProperty_H3 },
    { 0xCDE8,   0, cProperty_H2 },
    { 0xCDE9,  25, cProperty_H3 },
    { 0xCE04,   0, cProperty_H2 },
    { 0xCE05,  25, cProperty_H3 },
    { 0xCE20,   0, cProperty_H2 },
    { 0xCE21,  25, cProperty_H3 },
    { 0xCE3C,   0, cProperty_H2 },
    { 0xCE3D,  25, cProperty_H3 },
    { 0xCE58,   0, cProperty_H2 },
    { 0xCE59,  25, cProperty_H3 },
    { 0xCE74,   0, cProperty_H2 },
    { 0xCE75,  25, cProperty_H3 },
    { 0xCE90,   0, cProperty_H2 },
    { 0xCE91,  25, cProperty_H3 },
    { 0xCEAC,   0, cProperty_H2 },
    { 0xCEAD,  25, cProperty_H3 },
    { 0xCEC8,   0, cProperty_H2 },
    { 0xCEC9,  25, cProperty_H3 },
    { 0xCEE4,   0, cProperty_H2 },
    { 0xCEE5,  25, cProperty_H3 },
    { 0xCF00,   0, cProperty_H2 },
    { 0xCF01,  25, cProperty_H3 },
    { 0xCF1C,   0, cProperty_H2 },
    { 0xCF1D,  25, cProperty_H3 },
    { 0xCF38,   0, cProperty_H2 },
    { 0xCF39,  25, cProperty_H3 },
    { 0xCF54,   0, cProperty_H2 },
    { 0xCF55,  25, cProperty_H3 },
    { 0xCF70,   0, cProperty_H2 },
    { 0xCF71,  25, cProperty_H3 },
    { 0xCF8C,   0, cProperty_H2 },
    { 0xCF8D,  25, cProperty_H3 },
    { 0xCFA8,   0, cProperty_H2 },
    { 0xCFA9,  25, cProperty_H3 },
    { 0xCFC4,   0, cProperty_H2 },
    { 0xCFC5,  25, cProperty_H3 },
    { 0xCFE0,   0, cProperty_H2 },
    { 0xCFE1,  25, cProperty_H3 },
    { 0xCFFC,   0, cProperty_H2 },
    { 0xCFFD,  25, cProperty_H3 },
    { 0xD018,   0, cProperty_H2 },
    { 0xD019,  25, cProperty_H3 },
    { 0xD034,   0, cProperty_H2 },
    { 0xD035,  25, cProperty_H3 },
    { 0xD050,   0, cProperty_H2 },
    { 0xD051,  25, cProperty_H3 },
    { 0xD06C,   0, cProperty_H2 },
    { 0xD06D,  25, cProperty_H3 },
    { 0xD088,   0, cProperty_H2 },
    { 0xD089,  25, cProperty_H3 },
    { 0xD0A4,   0, cProperty_H2 },
    { 0xD0A5,  25, cProperty_H3 },
    { 0xD0C0,   0, cProperty_H2 },
    { 0xD0C1,  25, cProperty_H3 },
    { 0xD0DC,   0, cProperty_H2 },
    { 0xD0DD,  25, cProperty_H3 },
    { 0xD0F8,   0, cProperty_H2 },
    { 0xD0F9,  25, cProperty_H3 },
    { 0xD114,   0, cProperty_H2 },
    { 0xD115,  25, cProperty_H3 },
    { 0xD130,   0, cProperty_H2 },
    { 0xD131,  25, cProperty_H3 },
    { 0xD14C,   0, cProperty_H2 },
    { 0xD14D,  25, cProperty_H3 },
    { 0xD168,   0, cProperty_H2 },
    { 0xD169,  25, cProperty_H3 },
    { 0xD184,   0, cProperty_H2 },
    { 0xD185,  25, cProperty_H3 },
    { 0xD1A0,   0, cProperty_H2 },
    { 0xD1A1,  25, cProperty_H3 },
    { 0xD1BC,   0, cProperty_H2 },
    { 0xD1BD,  25, cProperty_H3 },
    { 0xD1D8,   0, cProperty_H2 },
    { 0xD1D9,  25, cProperty_H3 },
    { 0xD1F4,   0, cProperty_H2 },
    { 0xD1F5,  25, cProperty_H3 },
    { 0xD210,   0, cProperty_H2 },
    { 0xD211,  25, cProperty_H3 },
    { 0xD22C,   0, cProperty_H2 },
    { 0xD22D,  25, cProperty_H3 },
    { 0xD248,   0, cProperty_H2 },
    { 0xD249,  25, cProperty_H3 },
    { 0xD264,   0, cProperty_H2 },
    { 0xD265,  25, cProperty_H3 },
    { 0xD280,   0, cProperty_H2 },
    { 0xD281,  25, cProperty_H3 },
    { 0xD29C,   0, cProperty_H2 },
    { 0xD29D,  25, cProperty_H3 },
    { 0xD2B8,   0, cProperty_H2 },
    { 0xD2B9,  25, cProperty_H3 },
    { 0xD2D4,   0, cProperty_H2 },
    { 0xD2D5,  25, cProperty_H3 },
    { 0xD2F0,   0, cProperty_H2 },
    { 0xD2F1,  25, cProperty_H3 },
    { 0xD30C,   0, cProperty_H2 },
    { 0xD30D,  25, cProperty_H3 },
    { 0xD328,   0, cProperty_H2 },
    { 0xD329,  25, cProperty_H3 },
    { 0xD344,   0, cProperty_H2 },
    { 0xD345,  25, cProperty_H3 },
    { 0xD360,   0, cProperty_H2 },
    { 0xD361,  25, cProperty_H3 },
    { 0xD37C,   0, cProperty_H2 },
    { 0xD37D,  25, cProperty_H3 },
    { 0xD398,   0, cProperty_H2 },
    { 0xD399,  25, cProperty_H3 },
    { 0xD3B4,   0, cProperty_H2 },
    { 0xD3B5,  25, cProperty_H3 },
    { 0xD3D0,   0, cProperty_H2 },
    { 0xD3D1,  25, cProperty_H3 },
    { 0xD3EC,   0, cProperty_H2 },
    { 0xD3ED,  25, cProperty_H3 },
    { 0xD408,   0, cProperty_H2 },
    { 0xD409,  25, cProperty_H3 },
    { 0xD424,   0, cProperty_H2 },
    { 0xD425,  25, cProperty_H3 },
    { 0xD440,   0, cProperty_H2 },
    { 0xD441,  25, cProperty_H3 },
    { 0xD45C,   0, cProperty_H2 },
    { 0xD45D,  25, cProperty_H3 },
    { 0xD478,   0, cProperty_H2 },
    { 0xD479,  25, cProperty_H3 },
    { 0xD494,   0, cProperty_H2 },
    { 0xD495,  25, cProperty_H3 },
    { 0xD4B0,   0, cProperty_H2 },
    { 0xD4B1,  25, cProperty_H3 },
    { 0xD4CC,   0, cProperty_H2 },
    { 0xD4CD,  25, cProperty_H3 },
    { 0xD4E8,   0, cProperty_H2 },
    { 0xD4E9,  25, cProperty_H3 },
    { 0xD504,   0, cProperty_H2 },
    { 0xD505,  25, cProperty_H3 },
    { 0xD520,   0, cProperty_H2 },
    { 0xD521,  25, cProperty_H3 },
    { 0xD53C,   0, cProperty_H2 },
    { 0xD53D,  25, cProperty_H3 },
    { 0xD558,   0, cProperty_H2 },
    { 0xD559,  25, cProperty_H3 },
    { 0xD574,   0, cProperty_H2 },
    { 0xD575,  25, cProperty_H3 },
    { 0xD590,   0, cProperty_H2 },
    { 0xD591,  25, cProperty_H3 },
    { 0xD5AC,   0, cProperty_H2 },
    { 0xD5AD,  25, cProperty_H3 },
    { 0xD5C8,   0, cProperty_H2 },
    { 0xD5C9,  25, cProperty_H3 },
    { 0xD5E4,   0, cProperty_H2 },
    { 0xD5E5,  25, cProperty_H3 },
    { 0xD600,   0, cProperty_H2 },
    { 0xD601,  25, cProperty_H3 },
    { 0xD61C,   0, cProperty_H2 },
    { 0xD61D,  25, cProperty_H3 },
    { 0xD638,   0, cProperty_H2 },
    { 0xD639,  25, cProperty_H3 },
    { 0xD654,   0, cProperty_H2 },
    { 0xD655,  25, cProperty_H3 },
    { 0xD670,   0, cProperty_H2 },
    { 0xD671,  25, cProperty_H3 },
    { 0xD68C,   0, cProperty_H2 },
    { 0xD68D,  25, cProperty_H3 },
    { 0xD6A8,   0, cProperty_H2 },
    { 0xD6A9,  25, cProperty_H3 },
    { 0xD6C4,   0, cProperty_H2 },
    { 0xD6C5,  25, cProperty_H3 },
    { 0xD6E0,   0, cProperty_H2 },
    { 0xD6E1,  25, cProperty_H3 },
    { 0xD6FC,   0, cProperty_H2 },
    { 0xD6FD,  25, cProperty_H3 },
    { 0xD718,   0, cProperty_H2 },
    { 0xD719,  25, cProperty_H3 },
    { 0xD734,   0, cProperty_H2 },
    { 0xD735,  25, cProperty_H3 },
    { 0xD750,   0, cProperty_H2 },
    { 0xD751,  25, cProperty_H3 },
    { 0xD76C,   0, cProperty_H2 },
    { 0xD76D,  25, cProperty_H3 },
    { 0xD788,   0, cProperty_H2 },
    { 0xD789,  25, cProperty_H3 },
    { 0xD7B0,  22, cProperty_JV },
    { 0xD7CB,  48, cProperty_JT },
    { 0xD800, 255, cProperty_SG },
    { 0xD900, 255, cProperty_SG },
    { 0xDA00, 255, cProperty_SG },
    { 0xDB00, 126, cProperty_SG },
    { 0xDB80, 126, cProperty_SG },
    { 0xDC00, 255, cProperty_SG },
    { 0xDD00, 255, cProperty_SG },
    { 0xDE00, 255, cProperty_SG },
    { 0xDF00, 254, cProperty_SG },
    { 0xFB00,   6, cProperty_AL },
    { 0xFB13,   4, cProperty_AL },
    { 0xFB1D,   0, cProperty_HL },
    { 0xFB1E,   0, cProperty_CM },
    { 0xFB1F,   9, cProperty_HL },
    { 0xFB29,   0, cProperty_AL },
    { 0xFB2A,  12, cProperty_HL },
    { 0xFB38,   4, cProperty_HL },
    { 0xFB3E,   0, cProperty_HL },
    { 0xFB40,   1, cProperty_HL },
    { 0xFB43,   1, cProperty_HL },
    { 0xFB46,   9, cProperty_HL },
    { 0xFB50, 113, cProperty_AL },
    { 0xFBD3, 255, cProperty_AL },
    { 0xFCD3, 106, cProperty_AL },
    { 0xFD3E,   0, cProperty_OP },
    { 0xFD3F,   0, cProperty_CL },
    { 0xFD50,  63, cProperty_AL },
    { 0xFD92,  53, cProperty_AL },
    { 0xFDF0,  11, cProperty_AL },
    { 0xFDFC,   0, cProperty_PO },
    { 0xFDFD,   0, cProperty_AL },
    { 0xFE00,  15, cProperty_CM },
    { 0xFE10,   0, cProperty_IS },
    { 0xFE11,   1, cProperty_CL },
    { 0xFE13,   1, cProperty_IS },
    { 0xFE15,   1, cProperty_EX },
    { 0xFE17,   0, cProperty_OP },
    { 0xFE18,   0, cProperty_CL },
    { 0xFE19,   0, cProperty_IN },
    { 0xFE20,   6, cProperty_CM },
    { 0xFE35,   0, cProperty_OP },
    { 0xFE36,   0, cProperty_CL },
    { 0xFE37,   0, cProperty_OP },
    { 0xFE38,   0, cProperty_CL },
    { 0xFE39,   0, cProperty_OP },
    { 0xFE3A,   0, cProperty_CL },
    { 0xFE3B,   0, cProperty_OP },
    { 0xFE3C,   0, cProperty_CL },
    { 0xFE3D,   0, cProperty_OP },
    { 0xFE3E,   0, cProperty_CL },
    { 0xFE3F,   0, cProperty_OP },
    { 0xFE40,   0, cProperty_CL },
    { 0xFE41,   0, cProperty_OP },
    { 0xFE42,   0, cProperty_CL },
    { 0xFE43,   0, cProperty_OP },
    { 0xFE44,   0, cProperty_CL },
    { 0xFE47,   0, cProperty_OP },
    { 0xFE48,   0, cProperty_CL },
    { 0xFE50,   0, cProperty_CL },
    { 0xFE52,   0, cProperty_CL },
    { 0xFE54,   1, cProperty_NS },
    { 0xFE56,   1, cProperty_EX },
    { 0xFE59,   0, cProperty_OP },
    { 0xFE5A,   0, cProperty_CL },
    { 0xFE5B,   0, cProperty_OP },
    { 0xFE5C,   0, cProperty_CL },
    { 0xFE5D,   0, cProperty_OP },
    { 0xFE5E,   0, cProperty_CL },
    { 0xFE69,   0, cProperty_PR },
    { 0xFE6A,   0, cProperty_PO },
    { 0xFE70,   4, cProperty_AL },
    { 0xFE76, 134, cProperty_AL },
    { 0xFEFF,   0, cProperty_WJ },
    { 0xFF01,   0, cProperty_EX },
    { 0xFF04,   0, cProperty_PR },
    { 0xFF05,   0, cProperty_PO },
    { 0xFF08,   0, cProperty_OP },
    { 0xFF09,   0, cProperty_CL },
    { 0xFF0C,   0, cProperty_CL },
    { 0xFF0E,   0, cProperty_CL },
    { 0xFF1A,   1, cProperty_NS },
    { 0xFF1F,   0, cProperty_EX },
    { 0xFF3B,   0, cProperty_OP },
    { 0xFF3D,   0, cProperty_CL },
    { 0xFF5B,   0, cProperty_OP },
    { 0xFF5D,   0, cProperty_CL },
    { 0xFF5F,   0, cProperty_OP },
    { 0xFF60,   1, cProperty_CL },
    { 0xFF62,   0, cProperty_OP },
    { 0xFF63,   1, cProperty_CL },
    { 0xFF65,   0, cProperty_NS },
    { 0xFF66,   0, cProperty_AL },
    { 0xFF67,   9, cProperty_CJ },
    { 0xFF71,  44, cProperty_AL },
    { 0xFF9E,   1, cProperty_NS },
    { 0xFFA0,  30, cProperty_AL },
    { 0xFFC2,   5, cProperty_AL },
    { 0xFFCA,   5, cProperty_AL },
    { 0xFFD2,   5, cProperty_AL },
    { 0xFFDA,   2, cProperty_AL },
    { 0xFFE0,   0, cProperty_PO },
    { 0xFFE1,   0, cProperty_PR },
    { 0xFFE5,   1, cProperty_PR },
    { 0xFFE8,   6, cProperty_AL },
    { 0xFFF9,   2, cProperty_CM },
    { 0xFFFC,   0, cProperty_CB },
    { 0xFFFD,   0, cProperty_AI },
};

//
// LineBreakActionを決めるテーブルです。
//
static const LineBreakAction cLineBreakActionTable[cProperty_PairTableEnd][cProperty_PairTableEnd] =
{
    { cProhibit  , cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cCmProhibit,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit   },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cProhibit  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect   },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect   },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect   },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cProhibit  ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cDirect    , cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect     },
    { cIndirect  , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect   },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cIndirect  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cDirect     },
    { cDirect    , cProhibit  ,   cProhibit  ,   cIndirect  ,   cIndirect  ,   cIndirect  ,   cProhibit  ,   cProhibit  ,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect  ,   cIndirect  ,   cDirect    ,   cDirect    ,   cProhibit  ,   cCmIndirect,   cProhibit  ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cDirect    ,   cIndirect   },
};

//
// ユニコード文字から改行属性を得ます。
//
// 二分探索で cUnicodeToPriority テーブルを検索します。
// 文字コードがテーブル内に無い場合の改行属性は cProperty_ID です。
//
static LineBreakProperty
convertUtf16ToLineBreakProperty(char16 code)
{
    s32 left = 0;
    s32 right = ARRAY_LENGTH(cUnicodeToProperty);

    while (left < right)
    {
        s32 offset = (right - left) / 2;
        s32 middle = left + offset;
        const UnicodeToLineBreakProperty& entry = cUnicodeToProperty[middle];

        if (offset == 0)
        {
            if (code <= entry.mCode + entry.mNum)
            {
                return static_cast<LineBreakProperty>(entry.mProperty);
            }
            else
            {
                break;
            }
        }
        else if (code < entry.mCode)
        {
            right = middle;
        }
        else
        {
            left = middle;
        }
    }

    // みつからなかったらID
    return cProperty_ID;
}

//
// 改行属性の組からLineBreakActionを決定します。
//
static LineBreakAction
determineLineBreakAction(
    const LineBreakProperty preProperty,
    const LineBreakProperty afterProperty)
{
    NW_ASSERT(preProperty < cProperty_PairTableEnd);
    NW_ASSERT(afterProperty < cProperty_PairTableEnd);

    return cLineBreakActionTable[preProperty][afterProperty];
}

//
// 設定にに合わせて改行属性を確定させます。
//
static LineBreakProperty
treatPropertyFromConfig(
    const char16 code,
    const WordWrapConfig& config)
{
    NW_UNUSED_VARIABLE(config);

    // codeから改行属性を得る
    LineBreakProperty property = convertUtf16ToLineBreakProperty(code);

    // 確定改行をBKにまとめる
    if (property == cProperty_LF || property == cProperty_NL || property == cProperty_CR)
    {
        property = cProperty_BK;
    }

    // 日本語小文字ゃゅょ系は行頭禁止
    if (property == cProperty_CJ)
    {
        property = cProperty_NS;
    }

    // 東アジアの古い文献ではIDあつかいされていたものもAL
    if (property == cProperty_AI)
    {
        property = cProperty_AL;
    }

    // SA(南アジア言語:タイ、ミャンマー、クメール、ラオ)はAL扱いする
    // @note: Unicode規格のデフォルトは文字属性(Mn.Mc)によってCMとALに分ける
    if (property == cProperty_SA)
    {
        property = cProperty_AL;
    }

    // サロゲートはつかわないけど一応ALに
    if (property == cProperty_SG)
    {
        property = cProperty_AL;
    }

    // CBの定義はとりあえずIDにしておく
    if (property == cProperty_CB)
    {
        property = cProperty_ID;
    }

    return property;
}

const char16*
WordWrapping::FindLineBreak(
    const char16* begin,
    const char16* end,
    WordWrapCallback& func,
    const WordWrapConfig& config)
{
    if (begin == end)
    {
        return begin;
    }

    const char16* lastBreakItr = end;

    // 行頭のプロパティ
    LineBreakProperty curProperty = treatPropertyFromConfig(*begin, config);

    // 行頭のスペースはWJへ変換
    if (curProperty == cProperty_SP)
    {
        curProperty = cProperty_WJ;
    }
    else if (curProperty == cProperty_BK)
    {
        return begin;
    }

    // 2文字目からループスタート
    LineBreakProperty preProperty = curProperty;
    const char16* preItr = begin;
    const char16* curItr = begin;
    ++curItr;

    // SPのための対応
    bool isPreSP = false;

    // １行の表示幅に収まる文字列の範囲を得ます。
    const char16* limitItr = func.GetLineBreakLimit(begin, end);
    // １行に収まる最後の文字を指すように補正します。
    limitItr = nw::ut::Max(begin, limitItr - 1);

    // 表示幅制限、強制改行、終端到達が起きるまでループ
    for(; curItr != end; ++curItr)
    {
        // 改行属性を取得
        curProperty = treatPropertyFromConfig(*curItr, config);

        // 属性による分岐
        bool isNeedContinue = false;
        bool isNeedReturn = false;
        bool isBreakable = false;
        bool isDirect = false;

        switch (curProperty)
        {
        // SPは前情報を残しながら次へ
        case cProperty_SP:
            {
                isNeedContinue = true;
                break;
            }

        // BKは強制改行
        case cProperty_BK:
            {
                isNeedReturn = true;
                isBreakable = true;
                break;
            }

        // 改行アクションを決定
        default:
            {
                switch(determineLineBreakAction(preProperty, curProperty))
                {
                case cDirect:
                    isBreakable = true;
                    isDirect = true;
                    break;
                case cIndirect:
                    isBreakable = isPreSP;
                    break;
                case cCmIndirect:
                    isBreakable = isPreSP;
                    break;
                case cCmProhibit:
                    isBreakable = false;
                    break;
                case cProhibit:
                    isBreakable = false;
                    break;
                }
                break;
            }
        }

        // 一行の表示幅を超えているか
        bool isLimit = (limitItr + 1 < curItr);

        // isNeedContinueは解答保留
        // SPが終わるまで改行してよいかどうかわからないため
        // SPが終わるまでループを回す
        if (isNeedContinue)
        {
            // SPの前のPropertyだけ残して進める
            isPreSP = true;
            preItr = curItr;
            //NW_LOG("Skip By Space\n");
            continue;
        }

        // 改行可能
        if(isBreakable)
        {
            // Delegateによる判定にひっかかったら終了
            // 一文字も改行できる場所がない場合はあきらめて
            // Delegateが有効だった文字までにする
            // SP中も改行をしてよい場合、SP中にDelegate判定で許可が出ていた場所を返す
            if(isLimit)
            {
                //NW_LOG("break by Limit %d \n", (lastBreakItr != end ? lastBreakItr.getIndex() : preItr.getIndex() ) );
                if (isPreSP && isDirect)
                {
                    return limitItr;
                }
                else
                {
                    return lastBreakItr != end ? lastBreakItr : limitItr;
                }
            }

            // 改行可能位置を更新
            // Delegateを抜けることが保障される
            //NW_LOG("update breakable %d\n", preItr.getIndex());
            lastBreakItr = preItr;
        }

        // 強制改行により終了(例外として改行を含めて返す)
        if (isNeedReturn)
        {
            //NW_LOG("break by force\n");
            return curItr;
        }

        // Delegateによる保証を更新
        // はみだすようだったら最後の改行候補へ
        if(isLimit)
        {
            return lastBreakItr != end ? lastBreakItr : limitItr;
        }

        // 次の文字へ
        isPreSP = false;
        preItr = curItr;
        preProperty = curProperty;
    }

    // 最後の文字が入るか確認
    // SPによる判断保留中に文字列を完走してしまった場合
    // Delegateで許可された範囲で改行する
    if (limitItr + 1 < end)
    {
        if (isPreSP)
        {
            return limitItr;
        }
        else
        {
            return lastBreakItr != end ? lastBreakItr : limitItr;
        }
    }

    // 正常にテキストを完走した
    //NW_LOG("break by end");
    return preItr;
}

bool
WordWrapping::CalcWordWrapping(
    u32* writeSize,
    char16* out,
    u32 outSize,
    const char16* in,
    u32 inSize,
    WordWrapCallback& func,
    const WordWrapConfig& config)
{
    NW_NULL_ASSERT(out);
    NW_MIN_ASSERT(outSize, 1);
    NW_NULL_ASSERT(in);

    if (writeSize != NULL)
    {
        *writeSize = 0;
    }

    if (!out || !in || outSize == 0)
    {
        return false;
    }

    out[0] = L'\0';

    // 空だったら成功扱い
    if (inSize == 0 || in[0] == L'\0')
    {
        return true;
    }

    const char16* curItr = in;
    const char16* breakItr = in;
    const char16* endItr = in + inSize;

    bool isExistLineLimit = config.mMaxLineNum > 0;

    s32 lineCount = 0;
    s32 totalLength = 0;

    for (;;)
    {
        // 改行位置を検索
        breakItr = FindLineBreak(curItr, endItr, func, config);

        s32 length = breakItr - curItr + 1;
        NW_ASSERT(length > 0);
        s32 remainCapacity = outSize - totalLength - 1;
        s32 copyLength = ut::Min(length, remainCapacity);
        ut::MemCpy(out + totalLength, curItr, sizeof(char16) * copyLength);
        out[totalLength + copyLength] = L'\0';

        // copy時バッファサイズオーバー
        if (length != copyLength)
        {
            if (writeSize != NULL)
            {
                *writeSize = totalLength + copyLength;
            }

            return false;
        }

        // 次の行へ
        totalLength += copyLength;
        curItr = breakItr;
        ++curItr;
        ++lineCount;

        // 問題なく終端に到達
        if (curItr == endItr)
        {
            if (writeSize != NULL)
            {
                *writeSize = totalLength;
            }

            return true;
        }

        // 次のラインに移る前に改行制限を確認
        if (isExistLineLimit && lineCount >= config.mMaxLineNum)
        {
            if (writeSize != NULL)
            {
                *writeSize = totalLength;
            }

            return false;
        }

        // 次のラインに移るために改行を挿入
        // ただしbreakItrが改行コードの場合は無視して二重改行を行わない
        if (*breakItr != L'\n')
        {
            if (u32(totalLength + 1) < outSize)
            {
                out[totalLength + 0] = L'\n';
                out[totalLength + 1] = L'\0';
            }
            else
            {
                //// 改行挿入によるバッファあふれ

                if (writeSize != NULL)
                {
                    *writeSize = totalLength;
                }

                return false;
            }

            totalLength++;
        }

        // 二行目以降の行頭スペース無視が入っている場合
        if (config.mIsIgnoreFirstSpOver2ndLine)
        {
            for (;;)
            {
                LineBreakProperty property = convertUtf16ToLineBreakProperty(*curItr);
                if (property != cProperty_SP)
                {
                    break;
                }

                ++curItr;

                // 終端に到達した場合は最後の改行をなかったことにする
                // この行はなかったことになる
                if (curItr == endItr)
                {
                    --totalLength;
                    out[totalLength] = L'\0';

                    if (writeSize != NULL)
                    {
                        *writeSize = totalLength;
                    }

                    return true;
                }
            }
        }
    }
}

} // namespace font
} // namespace nw
