﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <gl/glew.h>
#endif

#include <nw/assert.h>
#include <nw/font/font_Font.h>
#include <nw/middlewareSymbol.h>

//########################################


namespace nw {
namespace font {

namespace internal {

//########################################
void
TextureObject::Set(
    u32         name,
    const void* pImage,
    TexFmt      format,
    u16         width,
    u16         height,
    u8          sheetNum,
    bool        blackWhiteInterpolationEnabled
)
{
    m_Name              = name;

    m_pImage            = pImage == NULL ? 0 : reinterpret_cast<uptr>(pImage);

    m_Format            = static_cast<u8>(format);
    m_FormatAttribute   = static_cast<u8>(format >> FONT_TEXTUREOBJ_FORMATATTRIBUTE_SHIFT_BIT); // 上位 8 ビットの属性フラグだけを取り出す。
    m_Size.width        = width;
    m_Size.height       = height;

    m_SheetNum = sheetNum;
    m_ColorBlackWhiteInterpolationEnabled = blackWhiteInterpolationEnabled;
}

void
TextureObject::SetTextureSettings(const TextureObject* pSrc)
{
    // 同一の画像をテクスチャとして使っているはず。
    NW_ASSERT(this->m_pImage == pSrc->m_pImage);
    NW_ASSERT(this->m_SheetNum == pSrc->m_SheetNum);

    this->m_Name = pSrc->m_Name;

#if defined(NW_PLATFORM_CAFE)
    this->m_Texture = pSrc->m_Texture;
#endif

}

}   // namespace internal

Glyph::Glyph()
:   isSheetUpdated(false)
{
}

Font::Font()
 : m_IsEnableKerning(true)
 , m_IsEnableExtraMargin(true)
{
    NW_PUT_MIDDLEWARE_SYMBOL(fnt);
}

Font::~Font()
{
}

const CharStrmReader
Font::GetCharStrmReader(char /* dummy */) const
{
    CharStrmReader::ReadNextCharFunc func = NULL;

    switch (GetCharacterCode())
    {
    case CHARACTER_CODE_UNICODE:    func = &CharStrmReader::ReadNextCharUTF8;   break;
    case CHARACTER_CODE_SJIS:       func = &CharStrmReader::ReadNextCharSJIS;   break;
    case CHARACTER_CODE_CP1252:     func = &CharStrmReader::ReadNextCharCP1252; break;

    default:
        NW_ASSERT(false);
        break;
    }

    return CharStrmReader(func);
}

const CharStrmReader
Font::GetCharStrmReader(char16 /* dummy */) const
{
    CharStrmReader::ReadNextCharFunc func = NULL;

    switch (GetCharacterCode())
    {
    case CHARACTER_CODE_UNICODE:    func = &CharStrmReader::ReadNextCharUTF16;  break;

    default:
        NW_ASSERT(false);
        break;
    }

    return CharStrmReader(func);
}

}   // namespace font
}   // namespace nw
