﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/window/dw_WindowContext.h>
#include <nw/dw/window/dw_Window.h>

namespace nw {
namespace internal {
namespace dw {

WindowContext::WindowContext() :
m_ScreenSize(0.f, 0.f),
m_pCurrentWindow(NULL)
{
}

void WindowContext::Initialize(f32 screenWidth, f32 screenHeight)
{
    m_ScreenSize.x = screenWidth;
    m_ScreenSize.y = screenHeight;
}

const Window* WindowContext::PushWindow(const Window& window, UIRenderer& renderer)
{
    (void)renderer;

    const Window* result = m_pCurrentWindow;

    const nw::ut::Rect clientRect = window.GetClientRect();

    f32 x      = clientRect.left;
    f32 y      = clientRect.top;
    f32 width  = nw::ut::Max(clientRect.GetWidth(), 0.f);
    f32 height = nw::ut::Max(clientRect.GetHeight(), 0.f);

    // クライアント領域 左上座標を原点にします。
    gfnd::Graphics::GetInstance()->SetScissor(
        x,
        y,
        width,
        height,
        m_ScreenSize.x,
        m_ScreenSize.y);

    gfnd::Graphics::GetInstance()->SetViewport(
        x,
        y,
        m_ScreenSize.x,
        m_ScreenSize.y,
        0.f,
        1.f,
        m_ScreenSize.x,
        m_ScreenSize.y);

    m_pCurrentWindow = &window;

    return result;
}

void WindowContext::PopWindow(const Window* pPreviousWindow, UIRenderer& renderer)
{
    (void)renderer;

    if(m_pCurrentWindow == NULL)
    {
        return;
    }

    // 原点の設定を元に戻します。
    f32 x      = 0.f;
    f32 y      = 0.f;
    f32 width  = m_ScreenSize.x;
    f32 height = m_ScreenSize.y;

    if(pPreviousWindow != NULL)
    {
        const nw::ut::Rect clientRect = pPreviousWindow->GetClientRect();
        x      = clientRect.left;
        y      = clientRect.top;
        width  = clientRect.GetWidth();
        height = clientRect.GetHeight();
    }

    gfnd::Graphics::GetInstance()->SetViewport(
        x,
        y,
        m_ScreenSize.x,
        m_ScreenSize.y,
        0.f,
        1.f,
        m_ScreenSize.x,
        m_ScreenSize.y);

    gfnd::Graphics::GetInstance()->SetScissor(
        x,
        y,
        width,
        height,
        m_ScreenSize.x,
        m_ScreenSize.y);

    m_pCurrentWindow = pPreviousWindow;
}

const Window* WindowContext::GetCurrentWindow() const
{
    return m_pCurrentWindow;
}

} // dw
} // internal
} // nw
