﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_Thickness.h>

namespace nw {
namespace internal {
namespace dw {

Thickness::Thickness() :
left(0.f),
top(0.f),
right(0.f),
bottom(0.f)
{
}

Thickness::Thickness(float value) :
left(value),
top(value),
right(value),
bottom(value)
{
}

Thickness::Thickness(float x, float y) :
left(x),
top(y),
right(x),
bottom(y)
{
}

Thickness::Thickness(float left, float top, float right, float bottom) :
left(left),
top(top),
right(right),
bottom(bottom)
{
}

Thickness::Thickness(const Thickness& value) :
left(value.left),
top(value.top),
right(value.right),
bottom(value.bottom)
{
}

void Thickness::Set(float l, float t, float r, float b)
{
    this->left   = l;
    this->top    = t;
    this->right  = r;
    this->bottom = b;
}

float Thickness::GetWidth() const
{
    return left + right;
}

float Thickness::GetHeight() const
{
    return top + bottom;
}

Thickness& Thickness::operator += (const Thickness& value)
{
    left   += value.left;
    top    += value.top;
    right  += value.right;
    bottom += value.bottom;
    return *this;
}

Thickness& Thickness::operator -= (const Thickness& value)
{
    left   -= value.left;
    top    -= value.top;
    right  -= value.right;
    bottom -= value.bottom;
    return *this;
}

const Thickness operator + (const Thickness& leftValue, const Thickness& rightValue)
{
    return Thickness(leftValue) += rightValue;
}

const bool operator == (const Thickness& leftValue, const Thickness& rightValue)
{
    return leftValue.left == rightValue.left &&
        leftValue.top == rightValue.top &&
        leftValue.right == rightValue.right &&
        leftValue.bottom == rightValue.bottom;
}

const bool operator != (const Thickness& leftValue, const Thickness& rightValue)
{
    return !(leftValue == rightValue);
}

} // dw
} // internal
} // nw
