﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_FileLoader.h>

#if defined( NW_PLATFORM_WIN32 ) || defined( NW_USE_NINTENDO_SDK )
// TODO: NintendoSdk 対応後、このコメントを削除してください。
  using namespace nw::internal::winext;
#endif

namespace nw {
namespace internal {
namespace dw {

FileLoader::FileLoader(
    FSClient* fsClient,
    FSCmdBlock* fsCmdBlock,
    nw::ut::IAllocator& allocator,
    bool isAutoFree/*=false*/) :
m_fsClient(fsClient),
m_fsCmdBlock(fsCmdBlock),
m_Allocator(allocator),
m_isAutoFree(isAutoFree),
m_pData(NULL),
m_DataSize(0)
{
}

FileLoader::~FileLoader()
{
    Close();
}

bool FileLoader::Open(const char* pFileName, u32 alignment/*=0*/)
{
    NW_ASSERT_NOT_NULL(pFileName);

    nw::ut::FsFileStream stream;

    if(!stream.Open(m_fsClient, m_fsCmdBlock, pFileName, "r"))
    {
        return false;
    }

    u32 dataSize = stream.GetSize();

    if(dataSize == 0)
    {
        stream.Close();
        return false;
    }

    void* pBuffer = m_Allocator.Alloc(
        nw::ut::RoundUp(dataSize, BUFFER_MIN_ALIGNMENT),
        nw::ut::Max<u32>(alignment, BUFFER_MIN_ALIGNMENT));

    if(pBuffer == NULL)
    {
        stream.Close();
        NW_FATAL_ERROR("failed to load file. (out of memory)");
        return false;
    }

    u32 readSize = stream.Read(pBuffer, dataSize);

    stream.Close();

    if(readSize != dataSize)
    {
        NW_FATAL_ERROR("failed to load file. (load incomplete)");
        nw::ut::SafeFree(pBuffer, &m_Allocator);
        return false;
    }

    m_pData = pBuffer;
    m_DataSize = readSize;

    return true;
}

void FileLoader::Close()
{
    m_DataSize = 0;

    if(m_isAutoFree)
    {
        nw::ut::SafeFree(m_pData, &m_Allocator);
    }

    m_pData = NULL;
}

void* FileLoader::GetData() const
{
    return m_pData;
}

u32 FileLoader::GetDataSize() const
{
    return m_DataSize;
}

} // nw::internal::dw
} // nw::internal
} // nw
;
