﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_FocusableElementFinder.h>

namespace nw {
namespace internal {
namespace dw {

FocusableElementFinder::FocusableElementFinder() :
m_pResult(NULL)
{
}

void FocusableElementFinder::Reset()
{
    m_pResult = NULL;
}

UIElement* FocusableElementFinder::GetResult() const
{
    return m_pResult;
}

bool FocusableElementFinder::operator ()(nw::internal::dw::UIElement& element)
{
    if(!element.GetIsFocusable())
    {
        return false;
    }

    m_pResult = &element;
    return true;
}

} // dw
} // internal
} // nw
