﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dev/dev_Pad.h>

#if defined(NW_DEV_PAD_ENABLE)

namespace nw
{
namespace dev
{

//------------------------------------------------------------------------------
Pad::Pad()
 : PadBase( PAD_IDX_MAX, IDX_LS_UP, IDX_RS_UP, IDX_TOUCH ),
   m_PadStatus( NULL )
{
}

//------------------------------------------------------------------------------
void
Pad::Update()
{
    // 前のフレームの状態
    u32 prevHold = GetHoldMask();
    bool prevPointerOn = IsPointerOn();

    // 継承先で実装する更新処理
    UpdateImpl();

    // UpdateImplで設定された値を元に副次的な値を設定
    UpdateDerivativeParams( prevHold, prevPointerOn );
}

} // namespace dev
} // namespace nw

#endif // NW_DEV_PAD_ENABLE
