﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <limits.h>
#include <nw/snd/spy/fnd/os/sndspyfnd_Thread.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

const u32 Thread::INVALID_ID = UINT_MAX;      //!< 無効なIDです。

//---------------------------------------------------------------------------
Thread::RunArgs::RunArgs() :
name(""),
stack(NULL),
stackSize(0),
affinityMask(Thread::CORE_DEFAULT),
priority(Thread::DEFAULT_THREAD_PRIORITY),
param(NULL),
handler(NULL)
{ }

//---------------------------------------------------------------------------
Thread::~Thread()
{
}

//---------------------------------------------------------------------------
bool
Thread::Run(const RunArgs& args)
{
    if(!args.IsValid())
    {
        NW_FATAL_ERROR("invalid arguments.\n");
        return false;
    }

    m_Param = args.param;
    m_Handler = args.handler;

    if(!Create(m_Handle, m_ID, args))
    {
        return false;
    }

    SetName(args.name);

    if(args.affinityMask != CORE_DEFAULT)
    {
        SetAffinityMask(args.affinityMask);
    }

    m_Priority = args.priority;

    // CTR スレッドが Suspend, Resume に対応していないので、
    // ここで必ず Resume します。
    Resume();

    return true;
}

//---------------------------------------------------------------------------
void
Thread::WaitForExit()
{
    Join();
}

//---------------------------------------------------------------------------
void
Thread::Release()
{
    switch(m_State)
    {
    case STATE_EXITED:
        break;

    case STATE_RUNNING:
        NW_FATAL_ERROR("must not Release() for running thread.\n");
        return;

    default:
        return;
    }

    Detach();
    SetState(STATE_RELEASED);
}

//---------------------------------------------------------------------------
s32
Thread::GetPriority() const
{
    return m_Priority;
}

//---------------------------------------------------------------------------
Thread::State
Thread::GetState() const
{
    return static_cast<State>(m_State);
}

//---------------------------------------------------------------------------
void
Thread::SetState(State value)
{
    m_State = value;
}

//---------------------------------------------------------------------------
void
Thread::OnRun()
{
    NW_ASSERT(m_State == STATE_NOT_RUN || m_State == STATE_RELEASED);
    SetState(STATE_RUNNING);
}

//---------------------------------------------------------------------------
void
Thread::OnExit()
{
    NW_ASSERT(m_State == STATE_RUNNING);
    SetState(STATE_EXITED);
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw
