﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../../precompiled.h"

#include <nw/snd/spy/fnd/os/sndspyfnd_Event.h>

#include <Windows.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
Event::Event(bool isManual, bool isInitialState) :
m_EventHandle(NULL)
{
    Initialize(isManual, isInitialState);
}

//---------------------------------------------------------------------------
Event::~Event()
{
    Finalize();
}

//---------------------------------------------------------------------------
void
Event::Wait()
{
    NW_ASSERT_NOT_NULL(m_EventHandle);
    ::WaitForSingleObject(m_EventHandle, INFINITE);
}

//---------------------------------------------------------------------------
bool
Event::TryWait()
{
    NW_ASSERT_NOT_NULL(m_EventHandle);
    return ::WaitForSingleObject(m_EventHandle, 0) == TRUE;
}

//---------------------------------------------------------------------------
void
Event::Set()
{
    NW_ASSERT_NOT_NULL(m_EventHandle);
    ::SetEvent(m_EventHandle);
}

//---------------------------------------------------------------------------
void
Event::Reset()
{
    NW_ASSERT_NOT_NULL(m_EventHandle);
    ::ResetEvent(m_EventHandle);
}

//---------------------------------------------------------------------------
void
Event::Initialize(bool isManual, bool isInitialState)
{
    NW_ASSERT(m_EventHandle == NULL);

    m_EventHandle = ::CreateEvent(NULL, isInitialState, isManual, NULL);
}

//---------------------------------------------------------------------------
void
Event::Finalize()
{
    NW_ASSERT_NOT_NULL(m_EventHandle);

    ::CloseHandle(m_EventHandle);
    m_EventHandle = NULL;
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw
