﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "spy/sndspy_SpyController.cpp"
#include "spy/sndspy_SpyData.cpp"
#include "spy/sndspy_SpyDataFileChannel.cpp"
#include "spy/sndspy_SpyPacketReader.cpp"
#include "spy/sndspy_SpySession.cpp"
#include "spy/modules/sndspy_LogModule.cpp"
#include "spy/modules/sndspy_MarkerModule.cpp"
#include "spy/modules/sndspy_PlotGroup.cpp"
#include "spy/modules/sndspy_PlotItem.cpp"
#include "spy/modules/sndspy_PlotModule.cpp"
#include "spy/modules/sndspy_PlotState.cpp"
#include "spy/modules/sndspy_SpyModule.cpp"
#include "spy/modules/sndspy_TimeModule.cpp"
#include "spy/fnd/basis/sndspyfnd_Memory.cpp"
#include "spy/fnd/os/sndspyfnd_Thread.cpp"
#include "spy/fnd/string/sndspyfnd_FixedString.cpp"
#include "spy/fnd/string/sndspyfnd_String.cpp"

#include <nw/config.h>

#if defined(NW_PLATFORM_CAFE)
    #include "spy/Cafe/sndspy_SpyControllerCafe.cpp"
    #include "spy/fnd/basis/Cafe/sndspyfnd_TimeCafe.cpp"
    #include "spy/fnd/hio/Cafe/sndspyfnd_HioChannelCafe.cpp"
    #include "spy/fnd/hio/Cafe/sndspyfnd_HioInitializerCafe.cpp"
    #include "spy/fnd/os/Cafe/sndspyfnd_ThreadCafe.cpp"
#elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    #include "spy/fnd/basis/Win/sndspyfnd_TimeWin.cpp"
    #include "spy/fnd/hio/Win/sndspyfnd_HioChannelWin.cpp"
    #include "spy/fnd/hio/Win/sndspyfnd_HioInitializerWin.cpp"
    #include "spy/fnd/os/Win/sndspyfnd_ThreadWin.cpp"
    #include "spy/fnd/os/Win/sndspyfnd_CriticalSectionWin.cpp"
    #include "spy/fnd/os/Win/sndspyfnd_EventWin.cpp"
#else
    #error
#endif
