﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/system/dw_Types.h>
#include <nw/snd/dw/snddw_VoicesWindow.h>
#include <nw/snd/dw/snddw_Config.h>

namespace nw {
namespace snd {
namespace dw {

//------------------------------------------------------------------------------
VoicesWindow::VoicesWindow()
: m_Panel()
{
    SetTitle("Voices");
    SetSize(488, 100);

    m_Panel.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
    SetContent(&m_Panel);
}

//------------------------------------------------------------------------------
VoicesWindow::~VoicesWindow()
{
}

//------------------------------------------------------------------------------
u32 VoicesWindow::GetRequiredSize() const
{
    const u32 titleLenMax = Config::GetInstance().GetWindowTitleLengthMax();
    const u32 stringBufferSize = font::CharWriter::GetDispStringBufferSize( titleLenMax );
    const u32 graphicsBufferSize = font::CharWriter::GetGraphicsBufferSize( titleLenMax );

    return 32 * 1024 + stringBufferSize + graphicsBufferSize;
}

} // namespace dw
} // namespace snd
} // namespace nw
