﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_SequenceSoundFile.h>
#include <nw/snd/snd_ElementType.h>
#include <cstring>      // strlen, strncmp

namespace nw {
namespace snd {
namespace internal {

//
// SequenceSoundFile::FileHeader
//
const SequenceSoundFile::DataBlock* SequenceSoundFile::FileHeader::GetDataBlock() const
{
    return reinterpret_cast<const DataBlock*>( GetBlock( ElementType_SequenceSoundFile_DataBlock ) );
}
const SequenceSoundFile::LabelBlock* SequenceSoundFile::FileHeader::GetLabelBlock() const
{
    return reinterpret_cast<const LabelBlock*>( GetBlock( ElementType_SequenceSoundFile_LabelBlock ) );
}


//
// SequenceSoundFile::LabelBlockBody
//

const SequenceSoundFile::LabelInfo* SequenceSoundFile::LabelBlockBody::GetLabelInfo( int index ) const
{
    NW_ASSERT( index < GetLabelCount() );

    return reinterpret_cast<const LabelInfo*>(
            labelInfoReferenceTable.GetReferedItem( index ) );
}

const char* SequenceSoundFile::LabelBlockBody::GetLabel( int index ) const
{
    const LabelInfo* labelInfo = GetLabelInfo( index );
    NW_NULL_ASSERT(labelInfo);
    return labelInfo->label;
}

const char* SequenceSoundFile::LabelBlockBody::GetLabelByOffset( u32 offset ) const
{
    // 線形探索
    for ( int i = 0; i < GetLabelCount(); i++ )
    {
        const LabelInfo* labelInfo = GetLabelInfo( i );
        NW_NULL_ASSERT(labelInfo);
        if ( labelInfo->referToSequenceData.offset == static_cast<s32>(offset) )
        {
            return labelInfo->label;
        }
    }
    return NULL;
}

bool SequenceSoundFile::LabelBlockBody::GetOffset( int index, u32* offsetPtr ) const
{
    const LabelInfo* labelInfo = GetLabelInfo( index );
    NW_NULL_ASSERT(labelInfo);
    *offsetPtr = labelInfo->referToSequenceData.offset;
    return true;
}

bool SequenceSoundFile::LabelBlockBody::GetOffsetByLabel( const char* label, u32* offsetPtr ) const
{
    const std::size_t labelLength = std::strlen( label );

    // 線形探索
    for ( int i = 0; i < GetLabelCount(); i++ )
    {
        const LabelInfo* labelInfo = GetLabelInfo( i );
        NW_NULL_ASSERT(labelInfo);
        if ( std::strncmp( label, labelInfo->label, labelLength ) == 0 )
        {
            *offsetPtr = labelInfo->referToSequenceData.offset;
            return true;
        }
    }
    return false;
}


} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

