﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_BasicSoundPlayer.h>
#include <nw/assert.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

void PlayerParamSet::Initialize()
{
    volume = 1.0f;
    pitch = 1.0f;
    lpfFreq = 0.0f;
    remoteFilter = 0;

    isFrontBypass = false;
    biquadType = BIQUAD_FILTER_TYPE_INHERIT;
    biquadValue = 0.0f;

    panMode = PAN_MODE_DUAL;
    panCurve = PAN_CURVE_SQRT;

    outputLineFlag = OUTPUT_LINE_MAIN;
    tvParam.Initialize();
    for ( int i = 0; i < DRC_OUT_COUNT; i++ )
    {
        drcParam[i].Initialize();
    }
    for ( int i = 0; i < REMOTE_OUT_COUNT; i++ )
    {
        remoteParam[i].Initialize();
    }
}

BasicSoundPlayer::BasicSoundPlayer()
: m_Event(true,true),
  m_ActiveFlag(false),
  m_StartedFlag(false),
  m_PauseFlag(false),
  m_FinishFlag(false),
  m_IsFinalizedForCannotAllocateResource(false)
{
}

void BasicSoundPlayer::Initialize()
{
    m_ActiveFlag = false;
    m_StartedFlag = false;
    m_PauseFlag = false;
    m_FinishFlag = false;
    m_IsFinalizedForCannotAllocateResource = false;

    m_PlayerParamSet.Initialize();
    m_pPlayerHeapDataManager = NULL;
}

void BasicSoundPlayer::Finalize()
{
    m_Event.Signal();
}

void BasicSoundPlayer::SetBiquadFilter( int type, float value )
{
    NW_MINMAX_ASSERT( type, BIQUAD_FILTER_TYPE_MIN, BIQUAD_FILTER_TYPE_MAX );
    NW_MINMAX_ASSERT( value, 0.0f, 1.0f );

    m_PlayerParamSet.biquadType = static_cast<s8>( type );
    m_PlayerParamSet.biquadValue = value;
}

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

