﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/io/sndfnd_File.h>

#include <nw/snd/fnd/io/sndfnd_FileStream.h>

#include <Windows.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

namespace {

//---------------------------------------------------------------------------
DWORD
ConvertAccessMode(File::AccessMode accessMode)
{
    switch(accessMode)
    {
    case File::ACCESS_MODE_READ:
        return GENERIC_READ;

    case File::ACCESS_MODE_WRITE:
        return GENERIC_WRITE;

    case File::ACCESS_MODE_READ_AND_WRITE:
        return GENERIC_READ | GENERIC_WRITE;
    }

    return 0;
}

}

//---------------------------------------------------------------------------
FndResult
File::Open(FileStream* stream, const char* filePath, AccessMode accessMode)
{
    NW_ASSERT_NOT_NULL(stream);

    DWORD desiredAccess = ConvertAccessMode(accessMode);
    NW_ASSERT(desiredAccess > 0);

    HANDLE handle = CreateFileA(
        filePath,
        desiredAccess,
        FILE_SHARE_READ,
        NULL,
        OPEN_ALWAYS,
        FILE_ATTRIBUTE_NORMAL,
        NULL);

    if(handle == INVALID_HANDLE_VALUE)
    {
        switch(GetLastError())
        {
        case ERROR_FILE_NOT_FOUND:
            return FndResult(SNDFND_RESULT_IO_FILE_NOT_FOUND);
        }

        return FndResult(SNDFND_RESULT_FAILED);
    }

    stream->Open(reinterpret_cast<void*>(handle));
    return FndResult(SNDFND_RESULT_TRUE);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
