﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/basis/sndfnd_Time.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
TimeSpan
Time::Current()
{
    return TimeSpan(OSGetTime());
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromNanoSeconds(s64 value)
{
    return TimeSpan(OSNanosecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMicroSeconds(s64 value)
{
    return TimeSpan(OSMicrosecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMilliSeconds(s64 value)
{
    return TimeSpan(OSMillisecondsToTicks(value));
}

//----------------------------------------------------------
s64
TimeSpan::ToNanoSeconds() const
{
    return OSTicksToNanoseconds(m_TickSpan);
}

//----------------------------------------------------------
s64
TimeSpan::ToMicroSeconds() const
{
    return OSTicksToMicroseconds(m_TickSpan);
}

//----------------------------------------------------------
s64
TimeSpan::ToMilliSeconds() const
{
    return OSTicksToMilliseconds(m_TickSpan);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
