﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/vwrlyt/cafe/vwrlyt_HIOListenerCafe.h>

#if defined(NW_VWRLYT_ENABLE)

namespace nw
{
namespace vwrlyt
{

void HIOListener::ReadCallback(HIOStatus status, void* context)
{
    HIOListener* listener = reinterpret_cast<HIOListener*>(context);
    NW_ASSERT( ! listener->m_HasMessage);
    NW_ASSERTMSG(status >= HIO_STATUS_OK, "status[%d] >= HIO_STATUS_OK", status);
    listener->m_HasMessage = true;
}

void HIOListener::ConnectCallback(HIOStatus status, void* context)
{
    if (status == HIO_STATUS_NEW_CONNECTION)
    {
        HIOListener* listener = reinterpret_cast<HIOListener*>(context);
        HIOStatus read_status = HIOReadAsync(listener->m_Handle, cMessageBufSize, listener->m_MessageBuffer, ReadCallback, context);
    }
}

HIOListener::HIOListener()
 : m_IsListening(false)
 , m_HasMessage(false)
{
    m_MessageBuffer[0] = '\0';
}

HIOListener::~HIOListener()
{
    if (m_IsListening)
    {
        EndListen();
    }
}

void HIOListener::StartListen()
{
    m_Handle = HIOOpen("NW4FLytViewer", ConnectCallback, this, HIO_CHANNEL_OPTION_READ, 0);
    NW_ASSERTMSG(m_Handle >= 0, "HIOOpen failed.[%d]", m_Handle);
}

const char* HIOListener::GetMessage()
{
    if (m_HasMessage)
    {
        return m_MessageBuffer;
    }
    else
    {
        return NULL;
    }
}

void HIOListener::ClearMessage()
{
    m_HasMessage = false;
}

void HIOListener::EndListen()
{
    HIOClose(m_Handle);
    m_IsListening = false;
}

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
