﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_ShaderContainer.h>
#include <nw/lyt/lyt_Util.h>
#include <nw/lyt/lyt_Layout.h>
#include <nw/ut/ut_String.h>

namespace nw
{
namespace lyt
{

//----------------------------------------
ShaderRefLink::ShaderRefLink()
{
    m_Name[0] = '\0';
}

//----------------------------------------
ShaderRefLink::~ShaderRefLink()
{
#if defined(NW_PLATFORM_CAFE)
    FreeArchiveShader(&m_ShaderInfo);
#endif
}

//----------------------------------------
void
ShaderRefLink::SetName(
    const char* name)
{
    NW_ASSERT_NOT_NULL(name);

    NW_ASSERT(std::strlen(name) < ShaderNameMax);
    ut::strcpy(m_Name, sizeof(m_Name), name);
}

//----------------------------------------
ShaderContainer::~ShaderContainer()
{
    this->Finalize();
}

//----------------------------------------
void
ShaderContainer::Finalize()
{
    while (!this->empty())
    {
        ShaderRefLink* pLink = &this->front();
        this->erase(pLink);
        Layout::DeleteObj(pLink);
    }
}

//----------------------------------------
ArchiveShaderInfo*
ShaderContainer::RegistShader(const char* name)
{
    NW_ASSERT(name);

    ShaderRefLink* pLink = Layout::NewObj<ShaderRefLink>();
    if (pLink == NULL)
    {
        return NULL;
    }

    pLink->SetName(name);

    this->push_back(pLink);

    return &pLink->GetShaderInfo();
}

//----------------------------------------
void
ShaderContainer::UnregistShader(ArchiveShaderInfo* info)
{
    NW_ASSERT_NOT_NULL(info);

    for (Iterator iter = this->GetBeginIter(); iter != this->GetEndIter(); ++iter)
    {
        if (&iter->GetShaderInfo() == info)
        {
            this->erase(iter);
            Layout::DeleteObj(&(*iter));
            break;
        }
    }
}

//----------------------------------------
const ArchiveShaderInfo*
ShaderContainer::FindShaderByName(const char* name) const
{
    ConstIterator iter_end = this->GetEndIter();
    for (ConstIterator iter = this->GetBeginIter(); iter != iter_end; ++iter)
    {
        if (internal::EqualsShaderName(name, iter->GetResourceName()))
        {
            return &iter->GetShaderInfo();
        }
    }

    return NULL;
}

} // namespace nw::lyt
} // namespace nw
