﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_ControlCreator.h>
#include <nw/lyt/lyt_Resources.h>

namespace nw
{
namespace lyt
{

ControlSrc::ControlSrc()
 : m_ControlName(NULL)
 , m_ControlUserName(NULL)
 , m_FunctionalPaneNum(0)
 , m_FunctionalAnimNum(0)
 , m_FunctionalPaneNamesPtr(NULL)
 , m_ControlFunctionalAnimNameOffsetsPtr(NULL)
 , m_pExtUserDataList(NULL)
{
}

void ControlSrc::Init(const void* dataPtr, const res::ExtUserDataList* pUserDataBlock)
{
    const res::Control* pResControl = static_cast<const res::Control*>(dataPtr);
    m_ControlName = internal::ConvertOffsToPtr<char>(dataPtr, sizeof(res::Control));
    m_ControlUserName = internal::ConvertOffsToPtr<char>(dataPtr, pResControl->controlUserNameOffset);
    m_FunctionalPaneNum = pResControl->controlFunctionalPaneNum;
    m_FunctionalAnimNum = pResControl->controlFunctionalAnimNum;
    m_FunctionalPaneNamesPtr = internal::ConvertOffsToPtr<char>(dataPtr, pResControl->controlFunctionalPaneNamesOffset);
    m_ControlFunctionalAnimNameOffsetsPtr = internal::ConvertOffsToPtr<void>(dataPtr, pResControl->controlFunctionalPaneNamesOffset +
        m_FunctionalPaneNum * ResourceNameStrMax);
    m_ControlFunctionalPaneParameterNameOffsetsPtr = internal::ConvertOffsToPtr<void>(dataPtr, pResControl->controlFunctionalPaneParameterNameOffsetsOffset);
    m_ControlFunctionalAnimParameterNameOffsetsPtr = internal::ConvertOffsToPtr<void>(dataPtr, pResControl->controlFunctionalAnimParameterNameOffsetsOffset);
    m_pExtUserDataList = pUserDataBlock;
}

const char* ControlSrc::GetFunctionalPaneName(u32 index) const
{
    if (index < GetFunctionalPaneNum()) {
        return &m_FunctionalPaneNamesPtr[index * ResourceNameStrMax];
    } else {
        NW_ERR("index exceeded [%d/%d]", index, GetFunctionalPaneNum());
        return NULL;
    }
}

const char* ControlSrc::FindFunctionalPaneName(const char* parameterName) const
{
    for (u32 i = 0; i < m_FunctionalPaneNum; i++) {
        const char* name = internal::ConvertOffsToPtr<char>(m_ControlFunctionalPaneParameterNameOffsetsPtr,
            static_cast<const ut::ResU32*>(m_ControlFunctionalPaneParameterNameOffsetsPtr)[i]);
        if (std::strcmp(name, parameterName) == 0) {
            return &m_FunctionalPaneNamesPtr[i * ResourceNameStrMax];
        }
    }
    return NULL;
}

const char* ControlSrc::GetFunctionalAnimName(u32 index) const
{
    if (index < GetFunctionalAnimNum()) {
        return internal::ConvertOffsToPtr<char>(m_ControlFunctionalAnimNameOffsetsPtr, static_cast<const ut::ResU32*>(m_ControlFunctionalAnimNameOffsetsPtr)[index]);
    } else {
        NW_ERR("index exceeded [%d/%d]", index, GetFunctionalAnimNum());
        return NULL;
    }
}

const char* ControlSrc::FindFunctionalAnimName(const char* parameterName) const
{
    for (u32 i = 0; i < m_FunctionalAnimNum; i++) {
        const char* name = internal::ConvertOffsToPtr<char>(m_ControlFunctionalAnimParameterNameOffsetsPtr,
            static_cast<const ut::ResU32*>(m_ControlFunctionalAnimParameterNameOffsetsPtr)[i]);
        if (std::strcmp(name, parameterName) == 0) {
            return internal::ConvertOffsToPtr<char>(m_ControlFunctionalAnimNameOffsetsPtr, static_cast<const ut::ResU32*>(m_ControlFunctionalAnimNameOffsetsPtr)[i]);
        }
    }
    return NULL;
}

u16
ControlSrc::GetExtUserDataNum() const
{
    if (! m_pExtUserDataList)
    {
        return 0;
    }

    return m_pExtUserDataList->num;
}

const res::ExtUserData*
ControlSrc::GetExtUserDataArray() const
{
    if (! m_pExtUserDataList)
    {
        return 0;
    }

    return internal::ConvertOffsToPtr<const res::ExtUserData>(m_pExtUserDataList, sizeof(*m_pExtUserDataList));
}

const res::ExtUserData*
ControlSrc::FindExtUserDataByName(const char* name) const
{
    const res::ExtUserData* pExtUserData = GetExtUserDataArray();
    if (! pExtUserData)
    {
        return 0;
    }

    for (int i = 0; i < m_pExtUserDataList->num; ++i, ++pExtUserData)
    {
        if (0 == std::strcmp(name, pExtUserData->GetName()))
        {
            return pExtUserData;
        }
    }

    return 0;
}

} // namespace nw::lyt
} // namespace nw
