﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_ControlCreator.h>
#include <nw/ctrl/ctrl_SelectButton.h>

namespace nw
{
namespace ctrl
{

void SelectButton::Build(const lyt::ControlSrc& controlSrc, lyt::Layout* layout)
{
    AnimButton::Build(controlSrc, layout);

    // Cancelアニメの取得
    m_CancelAnimator = layout->CreateGroupAnimatorAuto(controlSrc.FindFunctionalAnimName("Cancel"), false);
    NW_ASSERTMSG(m_CancelAnimator, "cannot create CancelAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Cancel"), layout->GetName());
}

bool SelectButton::HitTest(const math::VEC2& vec2) const
{
    // Cancelアニメを再生しているときは当たりが発生しないようにします。
    if (m_State == STATE_CANCEL) {
        return false;
    } else {
        return AnimButton::HitTest(vec2);
    }
}

bool SelectButton::ProcessOff()
{
    // DOWN及びDOWN_IDLE状態でOffを受け付けないように修正します。
    switch (m_State) {
    case STATE_OFF_IDLE:
        return true;
    case STATE_ON:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_DOWN:
        return true;
    case STATE_DOWN_IDLE:
        return true;
    case STATE_CANCEL:
        return true;
    };

    return true;
}

bool SelectButton::ProcessCancel()
{
    // Cancelイベントを受け付けるようにします。
    switch (m_State) {
    case STATE_OFF_IDLE:
        return true;
    case STATE_ON:
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        return true;
    case STATE_DOWN:
        return false;
    case STATE_DOWN_IDLE:
        ChangeState(STATE_CANCEL);
        StartCancel();
        return true;
    case STATE_CANCEL:
        return true;
    };

    return true;
}

void SelectButton::FinishCancel()
{
    ChangeState(STATE_OFF_IDLE);
    // OnOffアニメの状態をOFF_IDLEの状態に戻します。
    if (m_OnOffAnimator) {
        m_OnOffAnimator->StopAtMin();
    }
}

} // namespace nw::ctrl
} // namespace nw
