﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_SYS_IO_ERROR_H__
#define NW_WINEXT_SYS_IO_ERROR_H__

#include <winext/types.h>


#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------*
 *    -- GENERAL --
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *    -- FILE SYSTEM --
 *---------------------------------------------------------------------------*/
#define FSA_STATUS_OK                       0

#define FSA_STATUS_ERROR_BASE               (-196608)
/* FSA service is not initialized */
#define FSA_STATUS_NOT_INIT                 (FSA_STATUS_ERROR_BASE-1)
/* FSA shim or IPC was too busy */
#define FSA_STATUS_BUSY                     (FSA_STATUS_ERROR_BASE-2)
/* Command canceled */
#define FSA_STATUS_CANCELED                 (FSA_STATUS_ERROR_BASE-3)
/* Indicates end of directory */
#define FSA_STATUS_END_OF_DIRECTORY         (FSA_STATUS_ERROR_BASE-4)
/* Indicates end of file */
#define FSA_STATUS_END_OF_FILE              (FSA_STATUS_ERROR_BASE-5)

/* Reached to max number of mount points */
#define FSA_STATUS_MAX_MOUNTPOINTS          (FSA_STATUS_ERROR_BASE-16)
/* Reached to max number of volumes */
#define FSA_STATUS_MAX_VOLUMES              (FSA_STATUS_ERROR_BASE-17)
/* Reached to max number of clients */
#define FSA_STATUS_MAX_CLIENTS              (FSA_STATUS_ERROR_BASE-18)
/* Reached to max number of file handles */
#define FSA_STATUS_MAX_FILES                (FSA_STATUS_ERROR_BASE-19)
/* Reached to max number of dir handles */
#define FSA_STATUS_MAX_DIRS                 (FSA_STATUS_ERROR_BASE-20)
/* Target is already opened or locked by another transaction */
#define FSA_STATUS_ALREADY_OPEN             (FSA_STATUS_ERROR_BASE-21)
/* Target path already exists */
#define FSA_STATUS_ALREADY_EXISTS           (FSA_STATUS_ERROR_BASE-22)
/* Target path is not found */
#define FSA_STATUS_NOT_FOUND                (FSA_STATUS_ERROR_BASE-23)
/* Target path already exists */
#define FSA_STATUS_NOT_EMPTY                (FSA_STATUS_ERROR_BASE-24)
/* Attempted to access file with bad file mode */
#define FSA_STATUS_ACCESS_ERROR             (FSA_STATUS_ERROR_BASE-25)
/* Did not have permission to complete operation */
#define FSA_STATUS_PERMISSION_ERROR         (FSA_STATUS_ERROR_BASE-26)
/* Cannot complete transaction due to corrupted data block */
#define FSA_STATUS_DATA_CORRUPTED           (FSA_STATUS_ERROR_BASE-27)
/* Request would cause one of the ancestor directories to exceed its quota
 * Or no free space left in storage */
#define FSA_STATUS_STORAGE_FULL             (FSA_STATUS_ERROR_BASE-28)
/* Transaction journal is full, need to flush */
#define FSA_STATUS_JOURNAL_FULL             (FSA_STATUS_ERROR_BASE-29)

/* Operation is not available now */
#define FSA_STATUS_UNAVAILABLE_CMD          (FSA_STATUS_ERROR_BASE-31)
/* Operation is not supported by FS */
#define FSA_STATUS_UNSUPPORTED_CMD          (FSA_STATUS_ERROR_BASE-32)
/* Specified parameter is invalid */
#define FSA_STATUS_INVALID_PARAM            (FSA_STATUS_ERROR_BASE-33)
/* Specified path is invalid */
#define FSA_STATUS_INVALID_PATH             (FSA_STATUS_ERROR_BASE-34)
/* Specified buffer is invalid */
#define FSA_STATUS_INVALID_BUFFER           (FSA_STATUS_ERROR_BASE-35)
/* Specified alignment is invalid */
#define FSA_STATUS_INVALID_ALIGNMENT        (FSA_STATUS_ERROR_BASE-36)
/* Specified client handle is invalid */
#define FSA_STATUS_INVALID_CLIENT_HANDLE    (FSA_STATUS_ERROR_BASE-37)
/* Specified file handle is invalid */
#define FSA_STATUS_INVALID_FILE_HANDLE      (FSA_STATUS_ERROR_BASE-38)
/* Specified dir handle is invalid */
#define FSA_STATUS_INVALID_DIR_HANDLE       (FSA_STATUS_ERROR_BASE-39)
/* Specified path is directory instead of a file. */
#define FSA_STATUS_NOT_FILE                 (FSA_STATUS_ERROR_BASE-40)
/* Specified path is file instead of a directory. */
#define FSA_STATUS_NOT_DIR                  (FSA_STATUS_ERROR_BASE-41)
/* Request would push the file over the size limit (not the quota limit). */
#define FSA_STATUS_FILE_TOO_BIG             (FSA_STATUS_ERROR_BASE-42)
/* Attempted to access out of accessible area */
#define FSA_STATUS_OUT_OF_RANGE             (FSA_STATUS_ERROR_BASE-43)
/* Internal resources ran short */
#define FSA_STATUS_OUT_OF_RESOURCES         (FSA_STATUS_ERROR_BASE-44)

/* Medium is not ready to use, user has to put medium correctly */
#define FSA_STATUS_MEDIA_NOT_READY          (FSA_STATUS_ERROR_BASE-64)
/* Medium is in some bad condition */
#define FSA_STATUS_MEDIA_ERROR              (FSA_STATUS_ERROR_BASE-65)
/* Medium is in some bad condition */
#define FSA_STATUS_WRITE_PROTECTED          (FSA_STATUS_ERROR_BASE-66)

#define FSA_STATUS_ERROR_BASE_END           (FSA_STATUS_ERROR_BASE-1024)

/*
 * DEPRECATED: THIS MACRO IS KEPT FOR BUILD COMPATIBILITY.
 *             THIS WILL BE REMOVED IN FUTURE.
 */
/* Fatal system error, call FSAGetError() to get precise error codes */
#define FSA_STATUS_SYSTEM_ERROR             (FSA_STATUS_ERROR_BASE-1024)

/*---------------------------------------------------------------------------*
 *    -- NETWORK --
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *    -- USB --
 *---------------------------------------------------------------------------*/
#define UHS_STATUS_OK                           0
#define UHS_STATUS_ERROR_BASE                   (-2162688)
#define UHS_STATUS_TXN_CANCELLED                (UHS_STATUS_ERROR_BASE -1)
#define UHS_STATUS_LIMIT_EXCEEDED               (UHS_STATUS_ERROR_BASE -2)
#define UHS_STATUS_LOCAL_ARGUMENT_INVALID       (UHS_STATUS_ERROR_BASE -3)
#define UHS_STATUS_LOCAL_STATE_INVALID          (UHS_STATUS_ERROR_BASE -4)
#define UHS_STATUS_LOCAL_BUF_ERROR              (UHS_STATUS_ERROR_BASE -5)
#define UHS_STATUS_INVALID_HANDLE               (UHS_STATUS_ERROR_BASE -6)
#define UHS_STATUS_OBJ_ALLOC_FAIL               (UHS_STATUS_ERROR_BASE -7)
#define UHS_STATUS_INVALID_STATE                (UHS_STATUS_ERROR_BASE -8)
#define UHS_STATUS_EXISTS                       (UHS_STATUS_ERROR_BASE -9)
#define UHS_STATUS_NONEXISTIENT                 (UHS_STATUS_ERROR_BASE -10)
#define UHS_STATUS_FIFO_ERROR                   (UHS_STATUS_ERROR_BASE -11)
#define UHS_STATUS_INVALID_COMMAND              (UHS_STATUS_ERROR_BASE -12)
#define UHS_STATUS_SERVER_STATE_INVALID         (UHS_STATUS_ERROR_BASE -14)
#define UHS_STATUS_SERVER_ARGUMENT_INVALID      (UHS_STATUS_ERROR_BASE -15)
#define UHS_STATUS_UNEXPECTED_EVENT             (UHS_STATUS_ERROR_BASE -16)
#define UHS_STATUS_INVALID_INTERFACE_VECTOR     (UHS_STATUS_ERROR_BASE -17)
#define UHS_STATUS_BUSY                         (UHS_STATUS_ERROR_BASE -18)
#define UHS_STATUS_INTERFACE_NOT_ACQUIRED       (UHS_STATUS_ERROR_BASE -19)
#define UHS_STATUS_HC_NOT_RESPONDING            (UHS_STATUS_ERROR_BASE -20)
#define UHS_STATUS_INVALID_DEVICE               (UHS_STATUS_ERROR_BASE -21)
#define UHS_STATUS_INVALID_ENDPOINT             (UHS_STATUS_ERROR_BASE -22)
#define UHS_STATUS_INVALID_ENDPOINT_STATE       (UHS_STATUS_ERROR_BASE -23)
#define UHS_STATUS_INVALID_ENDPOINT_NUM         (UHS_STATUS_ERROR_BASE -24)
#define UHS_STATUS_INVALID_ENDPOINT_TYPE        (UHS_STATUS_ERROR_BASE -25)
#define UHS_STATUS_INVALID_ENDPOINT_DIR         (UHS_STATUS_ERROR_BASE -26)
#define UHS_STATUS_NOT_ENDPOINT_OWNER           (UHS_STATUS_ERROR_BASE -27)
#define UHS_STATUS_INVALID_IF                   (UHS_STATUS_ERROR_BASE -28)
#define UHS_STATUS_INVALID_ALT_IF               (UHS_STATUS_ERROR_BASE -29)
#define UHS_STATUS_TD_ERROR                     (UHS_STATUS_ERROR_BASE -30)
#define UHS_STATUS_TD_DATA_BUFFER_ERROR         (UHS_STATUS_ERROR_BASE -31)
#define UHS_STATUS_TD_BABBLE                    (UHS_STATUS_ERROR_BASE -32)
#define UHS_STATUS_TD_XACTERR                   (UHS_STATUS_ERROR_BASE -33)
#define UHS_STATUS_TD_MISSED_MICROFRAME         (UHS_STATUS_ERROR_BASE -34)
#define UHS_STATUS_TD_PERIODIC_SPLIT_ERROR      (UHS_STATUS_ERROR_BASE -35)
#define UHS_STATUS_TD_STALL_ERROR               (UHS_STATUS_ERROR_BASE -36)
#define UHS_STATUS_TD_PROTOCOL_ERROR            (UHS_STATUS_ERROR_BASE -37)
#define UHS_STATUS_TD_XFER_ERROR                (UHS_STATUS_ERROR_BASE -38)
#define UHS_STATUS_URB_STATE_INVALID            (UHS_STATUS_ERROR_BASE -39)
#define UHS_STATUS_DEVICE_STATE_INVALID         (UHS_STATUS_ERROR_BASE -40)
#define UHS_STATUS_DEVICE_DISCONNECT            (UHS_STATUS_ERROR_BASE -41)
#define UHS_STATUS_HC_STATE_INVALID             (UHS_STATUS_ERROR_BASE -42)
#define UHS_STATUS_EP_TYPE_INVALID              (UHS_STATUS_ERROR_BASE -43)
#define UHS_STATUS_EP_DIR_INVALID               (UHS_STATUS_ERROR_BASE -44)
#define UHS_STATUS_EP_URB_LIMIT                 (UHS_STATUS_ERROR_BASE -45)
#define UHS_STATUS_EP_CLOSED                    (UHS_STATUS_ERROR_BASE -46)
#define UHS_STATUS_EP_STATE_INVALID             (UHS_STATUS_ERROR_BASE -47)
#define UHS_STATUS_UNEXPECTED_SHORT_XFER        (UHS_STATUS_ERROR_BASE -48)
#define UHS_STATUS_INVALID_STRING_DESCRIPTOR    (UHS_STATUS_ERROR_BASE -49)
#define UHS_STATUS_INVALID_DEVICE_DESCRIPTOR    (UHS_STATUS_ERROR_BASE -50)
#define UHS_STATUS_INVALID_CONFIG_DESCRIPTOR    (UHS_STATUS_ERROR_BASE -51)
#define UHS_STATUS_INVALID_INTERFACE_DESCRIPTOR (UHS_STATUS_ERROR_BASE -52)
#define UHS_STATUS_INVALID_ENDPOINT_DESCRIPTOR  (UHS_STATUS_ERROR_BASE -53)
#define UHS_STATUS_ADDRESS_ERROR                (UHS_STATUS_ERROR_BASE -54)
#define UHS_STATUS_INVALID_PORT                 (UHS_STATUS_ERROR_BASE -55)
#define UHS_STATUS_LOCAL_OBJ_MSG_ERROR          (UHS_STATUS_ERROR_BASE -56)
#define UHS_STATUS_LIST_ERROR                   (UHS_STATUS_ERROR_BASE -57)
#define UHS_STATUS_INACTIVE                     (UHS_STATUS_ERROR_BASE -58)
#define UHS_STATUS_TIMEOUT                      (UHS_STATUS_ERROR_BASE -59)
#define UHS_STATUS_INVALID_BANDWIDTH            (UHS_STATUS_ERROR_BASE -60)
#define UHS_STATUS_INVALID_SIZE                 (UHS_STATUS_ERROR_BASE -61)
#define UHS_STATUS_LOCKED                       (UHS_STATUS_ERROR_BASE -62)

/*---------------------------------------------------------------------------*
 *    -- CCR --
 *---------------------------------------------------------------------------*/
#define CCR_ERROR_NONE                      0

// CCR lib/shim errors
#define CCR_ERROR_ACCESS                    -1179647
#define CCR_ERROR_ALLOC_IPC_BUFFER          -1179646
#define CCR_ERROR_NOT_IMPLEMENTED           -1179645
#define CCR_ERROR_INVALID                   -1179644
#define CCR_ERROR_READ                      -1179643
#define CCR_ERROR_NO_INPUT                  -1179642
#define CCR_ERROR_DESTINATION_ID            -1179641
#define CCR_ERROR_PATH_LENGTH               -1179640
#define CCR_ERROR_PORT_ID                   -1179639

// CCR RM errors
#define CCR_ERROR_INVALID_RM_CMD            -1179548
#define CCR_ERROR_INVALID_IOCTLV_CMD        -1179547
#define CCR_ERROR_VECTOR_COUNT              -1179546
#define CCR_ERROR_MEMORY_BANK               -1179545
#define CCR_ERROR_DATA_ALIGNMENT            -1179544
#define CCR_ERROR_DATA_SIZE                 -1179543
#define CCR_ERROR_REQUEST_CANCELLED         -1179542
#define CCR_ERROR_REQUEST_TIMEOUT           -1179541
#define CCR_ERROR_REQUEST_ABORTED           -1179540
#define CCR_ERROR_DRH_NOT_ATTACHED          -1179539
#define CCR_ERROR_CDC_RX_LENGTH             -1179538
#define CCR_ERROR_ALLOC_TASK                -1179537
#define CCR_ERROR_SAME_FW_VERSION           -1179536
#define CDC_ERROR_CDC_SYNC_FLAG             -1179535
#define CDC_ERROR_CDC_PROTOCOL_VERSION      -1179534
#define CDC_ERROR_CDC_SESSION_ID            -1179533
#define CDC_ERROR_CDC_SESSION_END           -1179532
#define CDC_ERROR_CDC_SEQUENCE              -1179531
#define CDC_ERROR_CDC_DESTINATION_ID        -1179530
#define CDC_ERROR_CDC_SOURCE_ID             -1179529
#define CDC_ERROR_CDC_REQRSPIND             -1179528
#define CDC_ERROR_CDC_MESSAGE_TYPE          -1179527
#define CDC_ERROR_CDC_MESSAGE_SIGNAL        -1179526
#define CDC_ERROR_CDC_RESULT_CODE           -1179525
#define CDC_ERROR_CDC_PAYLOAD_LENGTH        -1179524
#define CDC_ERROR_CDC_BIN_HEADER            -1179523
#define CDC_ERROR_WPS_TIMEOUT               -1179522
#define CDC_ERROR_USE_SDK_2_03              -1179521
#define CDC_ERROR_ES2_UP_TO_DATE            -1179520
#define CDC_ERROR_DRH_NOT_ATTACHED          -1179519

/*---------------------------------------------------------------------------*
 *    -- USR CFG --
 *---------------------------------------------------------------------------*/
#define UC_RVAL_OK                              0
#define UC_RVAL_UNKNOWN_ERROR                   -2097153  // unclassified error
#define UC_RVAL_SYSTEM_ERROR                    -2097154  // system error below UC
#define UC_RVAL_ALLOC_ERROR                     -2097155  // error allocating data
#define UC_RVAL_INVALID_OP_ERROR                -2097156  // invalid RPC operation
#define UC_RVAL_INVALID_ARG_ERROR               -2097157  // invalid argument, such as NULL pointer
#define UC_RVAL_INVALID_TYPE_ERROR              -2097158  // invalid type for operation
#define UC_RVAL_UNSUPPORTED_ERROR               -2097159  // feature not supported

#define UC_RVAL_ITEM_ACCESS_ERROR               -2097160 // accessing node in an unsupported manner (e.g. reading value non leaf node)
#define UC_RVAL_KEY_NOT_FOUND_ERROR             -2097161 // node key not found
#define UC_RVAL_BAD_MODIFY_ERROR                -2097162 // modifying a nodes attributes
#define UC_RVAL_STRING_LENGTH_ERROR             -2097163 // string/buffer too long for allocated area
#define UC_RVAL_INVALID_ROOTKEY_ERROR           -2097164 // a problem with the rootkey
#define UC_RVAL_INVALID_LOC_ERROR               -2097165 // loc portion of the key is invalid
#define UC_RVAL_BAD_COMMENT_ERROR               -2097166 // comment bad (not ending right or on wrong type of node)
#define UC_RVAL_ACCESS_READ_ERROR               -2097167 // no read access
#define UC_RVAL_ACCESS_WRITE_ERROR              -2097168 // no write access
#define UC_RVAL_ACCESS_CREATE_ERROR             -2097169 // no create access
#define UC_RVAL_FILESYS_NAME_ERROR              -2097170 // file name malformed for device

#define UC_RVAL_FILESYS_INIT_ERROR              -2097171 // error initing a file system
#define UC_RVAL_FILESYS_MOUNT_ERROR             -2097172 // error mounting a file system
#define UC_RVAL_FILE_OPEN_ERROR                 -2097173 // error opening file - usually means file doesn't exist
#define UC_RVAL_FILE_STAT_ERROR                 -2097174 // error stating file
#define UC_RVAL_FILE_READ_ERROR                 -2097175 // error reading file
#define UC_RVAL_FILE_WRITE_ERROR                -2097176 // error writing file
#define UC_RVAL_FILE_SIZE_ERROR                 -2097177 // xml file bigger than max size
#define UC_RVAL_FILE_REMOVE_ERROR               -2097178 // error removing/deleting file
#define UC_RVAL_FILE_RENAME_ERROR               -2097179 // error renaming a file

#define UC_RVAL_FILE_CLOSE_ERROR                -2097180 // error closing file
#define UC_RVAL_FILE_SEEK_ERROR                 -2097181 // error seeking in file
#define UC_RVAL_FILE_CONFIRM_ERROR              -2097182 // Confirm file either existed or not existed as expected
#define UC_RVAL_FILE_BACKUP_ERROR               -2097183 // Backup file doesn't exist as expected
#define UC_RVAL_FILE_MALFORMED_ERROR            -2097184 // XML data is malformed
#define UC_RVAL_VERSION_ERROR                   -2097185 // Version number either doesn't exist or is wrong
#define UC_RVAL_NO_IPC_BUFFERS_ERROR            -2097186 // Ran out of IPC buffers
#define UC_RVAL_TIMEOUT_ERROR                   -2097187 // Some sort of timeout
#define UC_RVAL_FILE_LOCK_NEEDED_ERROR          -2097188 // Expected serialization of file creates/deletes violated... May need a file lock.  (This one means assumptions aren't true)

#define UC_RVAL_SYSCTX_NOT_FOUND_ERROR          -2097189 // System context not found or invalid
#define UC_RVAL_INVALID_TRIGGER_ERROR           -2097190 // Trigger index is out of range
#define UC_RVAL_TRIGGER_NOT_FOUND_ERROR         -2097191 // Trigger with specified ID not found

#define UC_RVAL_SYSPROT_INIT_ERROR              -2097192 // system protection error
#define UC_RVAL_SYSPROT_MEMBLOCK_ERROR          -2097193
#define UC_RVAL_SYSPROT_SRAM_ERROR              -2097194
#define UC_RVAL_SYSPROT_DEVICES_ERROR           -2097195
#define UC_RVAL_SYSPROT_FINE_GRAIN_ERROR        -2097196

#define UC_RVAL_FILE_NOT_FOUND_ERROR            -2097197 // no target file
#define UC_RVAL_INCORRECT_VERSION_ERROR         -2097198 // higher version is already installed

#ifdef __cplusplus
}
#endif

#endif // NW_WINEXT_SYS_IO_ERROR_H__
