﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_PAD_H_
#define NW_WINEXT_PAD_H_

#include <winext/types.h>
#include <winext/cafe/os.h>

namespace nw {
namespace internal {
namespace winext {

// CAUTION: Define PAD_USESPEC as long as bread boards or prototype
//          controllers (including DS4) are in use.
#define NW_WINEXT_PAD_USESPEC

#ifdef  __MWERKS__
#pragma warn_padding off
#endif

typedef struct PADStatus
{
    u16 button;                 // Or-ed PAD_BUTTON_* bits
    s8  stickX;                 // -128 <= stickX       <= 127
    s8  stickY;                 // -128 <= stickY       <= 127
    s8  substickX;              // -128 <= substickX    <= 127
    s8  substickY;              // -128 <= substickY    <= 127
    u8  triggerLeft;            //    0 <= triggerLeft  <= 255
    u8  triggerRight;           //    0 <= triggerRight <= 255
    u8  analogA;                //    0 <= analogA      <= 255
    u8  analogB;                //    0 <= analogB      <= 255
    s8  err;                    // one of PAD_ERR_* number
} PADStatus;

#ifdef  __MWERKS__
#pragma warn_padding reset
#endif

#define NW_WINEXT_PAD_MAX_CONTROLLERS     4

#define NW_WINEXT_PAD_BUTTON_LEFT         0x0001
#define NW_WINEXT_PAD_BUTTON_RIGHT        0x0002
#define NW_WINEXT_PAD_BUTTON_DOWN         0x0004
#define NW_WINEXT_PAD_BUTTON_UP           0x0008
#define NW_WINEXT_PAD_TRIGGER_Z           0x0010
#define NW_WINEXT_PAD_BUTTON_Z            NW_WINEXT_PAD_TRIGGER_Z
#define NW_WINEXT_PAD_TRIGGER_R           0x0020
#define NW_WINEXT_PAD_BUTTON_R            NW_WINEXT_PAD_TRIGGER_R
#define NW_WINEXT_PAD_TRIGGER_L           0x0040
#define NW_WINEXT_PAD_BUTTON_L            NW_WINEXT_PAD_TRIGGER_L
#define NW_WINEXT_PAD_BUTTON_A            0x0100
#define NW_WINEXT_PAD_BUTTON_B            0x0200
#define NW_WINEXT_PAD_BUTTON_X            0x0400
#define NW_WINEXT_PAD_BUTTON_Y            0x0800
#define NW_WINEXT_PAD_BUTTON_MENU         0x1000
#define NW_WINEXT_PAD_BUTTON_START        0x1000

//#define PAD_CHAN0               0
//#define PAD_CHAN1               1
//#define PAD_CHAN2               2
//#define PAD_CHAN3               3

#define NW_WINEXT_PAD_CHAN0_BIT           0x80000000
//#define PAD_CHAN1_BIT           0x40000000
//#define PAD_CHAN2_BIT           0x20000000
//#define PAD_CHAN3_BIT           0x10000000

#define NW_WINEXT_PAD_ERR_NONE            0
#define NW_WINEXT_PAD_ERR_NO_CONTROLLER   -1
//#define PAD_ERR_NOT_READY       -2
//#define PAD_ERR_TRANSFER        -3

//#define PAD_MOTOR_STOP          0
//#define PAD_MOTOR_RUMBLE        1
//#define PAD_MOTOR_STOP_HARD     2

#ifdef  NW_WINEXT_PAD_USESPEC
//#define PAD_SPEC_0              0       // bread board    (ver 0.x)
//#define PAD_SPEC_1              1       // 1st prototypes (ver 1.0)
//#define PAD_SPEC_2              2       // 2nd prototypes (ver 3.0 FPGA)
//#define PAD_SPEC_3              3       // DS3
//#define PAD_SPEC_4              4       // DS4
//#define PAD_SPEC_5              5       // DS5 (production version)
#endif  // NW_WINEXT_PAD_USESPEC

// clamp algorithm for stick
#define NW_WINEXT_PAD_STICK_CLAMP_OCTA_WITH_MARGIN         0
//#define PAD_STICK_CLAMP_OCTA_WITHOUT_MARGIN      1
#define NW_WINEXT_PAD_STICK_CLAMP_CIRCLE_WITH_MARGIN       2
//#define PAD_STICK_CLAMP_CIRCLE_WITHOUT_MARGIN    3
// clamp algorithm for trigger
#define NW_WINEXT_PAD_TRIGGER_FIXED_BASE       0
//#define PAD_TRIGGER_INDIVIDUAL_BASE  1


void PADInit             ( void );
void PADRead             ( PADStatus* status );

void PADClamp            ( PADStatus* status );
void PADClampCircle      ( PADStatus* status );
void PADClamp2           ( PADStatus* status, u32 type );
void PADClampCircle2     ( PADStatus* status, u32 type );

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_PAD_H_
