﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSCORE_H_
#define NW_WINEXT_OSCORE_H_

#define MAX_SYSTEM_CORES     3
#define MAX_CORES_ESPRESSO   3
#define MAX_CORES_BROADWAY   1

#define OS_COREID_0          0
#define OS_COREID_1          1
#define OS_COREID_2          2

#define CACHE_BLOCK_SIZE     32
#define L1_CACHE_LINE_SIZE   32
#define L2_CACHE_LINE_SIZE   64
#define LL_CACHE_FETCH_SIZE  64   // last-level cache fetch size. Can be 32 or 64 bytes.

#define PPC_IO_BUFFER_SIZE_MIN LL_CACHE_FETCH_SIZE
#define PPC_IO_BUFFER_ALIGN    LL_CACHE_FETCH_SIZE

#ifndef _ASSEMBLER

#include <winext/types.h>

namespace nw {
namespace internal {
namespace winext {

u32 OSGetCoreCount(void);
u32 OSGetCoreId(void);
u32 OSGetMainCoreId(void);
BOOL OSIsMainCore(void);

#endif // _ASSEMBLER

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSCORE_H_
