﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/sndedit.h
 *
 * @file sndedit.h
 */

#ifndef NW_SNDEDIT_H_
#define NW_SNDEDIT_H_

//---------------------------------------------------------------------------
//! @namespace nw::snd::edit
//!
//! @brief    サウンドインゲーム編集ライブラリの名前空間です。 @n
//!           @n
//!           このライブラリを利用すると、ゲームで利用中のサウンドアーカイブの内容を
//!           SoundMaker から編集することができるようになります。 @n
//!           詳しい使い方については、各クラスの解説と edit デモを参照ください。
//!           @n
//!           なお、このライブラリを利用するには、別途 libnw4f_snddev.a をリンク
//!           する必要があります。 @n
//!           @n
//!           【注意】 @n
//!           このライブラリには、β版のクラスが含まれています。 @n
//!           これらのクラスが提供する機能は、予告なく変更される可能性があります。
//---------------------------------------------------------------------------

#include <nw/snd/edit/sndedit_SoundArchiveEditor.h>
#include <nw/snd/edit/sndedit_SoundEditSession.h>
#include <nw/snd/edit/util/sndedit_UpdateCachesHelper.h>


#endif /* NW_SNDEDIT_H_ */

