﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_PLOT_ITEM_PACKET_H_
#define NW_SND_SPY_PLOT_ITEM_PACKET_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/modules/sndspy_PacketUtility.h>

namespace nw {
namespace snd {
namespace spy {

//! @briefprivate
class SpyPlotItemPacket
{
public:
    static const u32 PACKET_VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(1, 1, 1, 0);
    static const s32 MAX_NAME_LENGTH = 255;     //< プロットアイテム名の最大値。
    static const s32 MAX_GROUP_NAME_LENGTH = 255;
    static const s32 MAX_STATE_NAME_LENGTH = 255;
    static const s32 MAX_STATE_VALUE_LENGTH = 255;

    enum DataType
    {
        DataType_ItemValue = 0,
        DataType_ItemMetadata,
        DataType_Reset,
        DataType_GroupMetadata,
        DataType_GroupDetach,
        DataType_StateMetadata,
        DataType_StateValue,
    };

    //! @briefprivate パケット共通データ
    struct PacketCommonData
    {
        u8  dataType;   ///< パケットデータタイプ
        u8  padding[3];
    };

    //! @briefprivate メタデータパケット
    struct ItemMetadataPacketPayload
    {
        PacketCommonData common;

        u32 id;

        double minValue;
        double maxValue;

        struct
        {
            u8 r;
            u8 g;
            u8 b;
            u8 a;
        } color;

        u8 interpolationMode;
        u8 padding[3];

        StringData<u8, MAX_NAME_LENGTH> name;

        u32 groupId;
    };

    //! @briefprivate 値パケット
    struct ItemValuePacketPayload
    {
        PacketCommonData common;

        u32 id;
        double value;
    };

    struct ResetPacketPayload
    {
        PacketCommonData common;
    };

    struct GroupMetadataPacketPayload
    {
        PacketCommonData common;

        u32 id;
        StringData<u8, MAX_GROUP_NAME_LENGTH> name;
    };

    struct GroupDetachPacketPayload
    {
        PacketCommonData common;

        u32 id;
    };

    struct StateMetadataPacketPayload
    {
        PacketCommonData common;

        u32 id;

        StringData<u8, MAX_STATE_NAME_LENGTH> name;

        u32 groupId;
    };

    struct StateValuePacketPayload
    {
        PacketCommonData common;

        u32 id;

        struct
        {
            u8 r;
            u8 g;
            u8 b;
            u8 a;
        } color;

        StringData<u8, MAX_STATE_VALUE_LENGTH> state;

        // このパケットは可変長です。
        // state が最後のメンバーでなければなりません。
    };
};

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_PLOT_ITEM_PACKET_H_
