﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_LOG_H_
#define NW_SND_SPY_SPY_LOG_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/sndspy_SpyDataInfo.h>
#include <nw/snd/spy/sndspy_SpyData.h>
#include <nw/snd/spy/modules/sndspy_SpyModule.h>

namespace nw {
namespace snd {
namespace spy {

class SpyController;

//! @briefprivate
class LogModule : public SpySimpleModule
{
public: // コンストラクタ
    LogModule();

public: // メソッド
    static bool WriteFormat(SpyController& controller, const char* format, ...)
    {
        va_list arglist;
        va_start(arglist, format);

        bool result = WriteFormatV(controller, format, arglist);

        va_end(arglist);

        return result;
    }

    static bool WriteFormatWithCategory(SpyController& controller, const char* category, const char* format, ...)
    {
        va_list arglist;
        va_start(arglist, format);

        bool result = WriteFormatVWithCategory(controller, category, format, arglist);

        va_end(arglist);

        return result;
    }

    static bool WriteFormatV(SpyController& controller, const char* format, va_list arglist);
    static bool WriteFormatVWithCategory(SpyController& controller, const char* category, const char* format, va_list arglist);

    bool WriteFormat(const char* format, ...)
    {
        if(!IsInstalled())
        {
            return false;
        }

        va_list arglist;
        va_start(arglist, format);
        bool result = LogModule::WriteFormatV(*GetController(), format, arglist);
        va_end(arglist);

        return result;
    }

    bool WriteFormatWithCategory(const char* category, const char* format, ...)
    {
        if(!IsInstalled())
        {
            return false;
        }

        va_list arglist;
        va_start(arglist, format);
        bool result = LogModule::WriteFormatVWithCategory(*GetController(), category, format, arglist);
        va_end(arglist);

        return result;
    }

    bool WriteFormatV(const char* format, va_list arglist)
    {
        if(!IsInstalled())
        {
            return false;
        }
        return LogModule::WriteFormat(*GetController(), format, arglist);
    }

    bool WriteFormatVWithCategory(const char* category, const char* format, va_list arglist)
    {
        if(!IsInstalled())
        {
            return false;
        }
        return LogModule::WriteFormatVWithCategory(*GetController(), category, format, arglist);
    }
};

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_SPY_LOG_H_
