﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/snd_WavePlayer.h
 *
 * @file snd_WavePlayer.h
 */

#ifndef NW_SND_WAVE_PLAYER_H_
#define NW_SND_WAVE_PLAYER_H_

#include <nw/snd/snd_MultiVoice.h>

namespace nw {
namespace snd {

//! @briefprivate
class WavePlayer
{
public:
    typedef void (*VoiceCallback)( void* arg );

    // ------------------------------------------------------------------------
    // 確保と解放
    bool Initialize(
        int channelCount,
        /* int voiceOutCount, */
        int priority,
        VoiceCallback callback, // このコールバックが呼ばれたあとでしか、
                                // WaveBuffer::buffreAddress 上のデータの解放および
                                // Voice インスタンスを使い回しをしてはいけない
        void* callbackArg );
    void Finalize();

    // ------------------------------------------------------------------------
    // 再生制御
    void Start();
    void Stop();
    void Pause( bool isPauseOn );

    // ------------------------------------------------------------------------
    // 再生状態
    bool IsActive() const;
    bool IsRun() const;
    bool IsPause() const;
    u32 GetCurrentPlayingSample() const;

    // ------------------------------------------------------------------------
    // 波形データ設定
    void SetWaveInfo( SampleFormat format, int sampleRate, int interpolationType );
    void SetAdpcmParam( int channel, /*int voiceOut,*/const AdpcmParam& param );
    void AppendWaveBuffer( int channel, /*int voiceOut,*/ WaveBuffer* pBuffer, bool lastFlag );

    // ------------------------------------------------------------------------
    // パラメータ設定
    void SetPriority( int priority );
    void SetVolume( f32 volume );
    void SetPitch( f32 pitch );
    void SetPanMode( PanMode mode );
    void SetPanCurve( PanCurve curve );
    void SetPan( f32 pan );
    void SetSurroundPan( f32 span );
    void SetLpfFreq( f32 lpfFreq );
    void SetBiquadFilter( int type, f32 value );

    // ------------------------------------------------------------------------
    // 出力パラメータ
    void SetOutputLine( u32 lineFlag );
    void SetMainOutVolume( f32 volume );
#if defined(NW_PLATFORM_CAFE)
    void SetRemoteOutVolume( int remoteIndex, f32 volume );
#else
    NW_DEPRECATED_FUNCTION_MSG( void SetRemoteOutVolume( int remoteIndex, f32 volume ), "This API is only supported for Cafe.");
#endif
    void detail_SetDrcOutVolume( int drcIndex, f32 volume ); // SDK 対応まで非公開
    void SetDrcOutVolume( f32 volume )
    {
        detail_SetDrcOutVolume( 0, volume );
    }
    void SetMainSend( f32 send );
    void SetFxSend( AuxBus bus, f32 send );


private:
    static void MultiVoiceCallbackFunc(
        internal::driver::MultiVoice* voice,
        internal::driver::MultiVoice::VoiceCallbackStatus status,
        void* arg );

    internal::driver::MultiVoice* m_pMultiVoice;
    VoiceCallback m_Callback;
    void* m_pCallbackArg;
};

} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_WAVE_PLAYER_H_ */

